/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import tr.model.action.Interval;
import tr.model.action.Period;
import tr.model.action.PeriodType;
import tr.prefs.recurrence.RecurrencePrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodWeekday
extends Period {
    public static final byte ID = 1;
    public static final String BUNDLE_KEY = "period.weekday";

    @Override
    public Period clone() {
        return new PeriodWeekday();
    }

    @Override
    public final byte getID() {
        return 1;
    }

    @Override
    public final String getBundleKey() {
        return BUNDLE_KEY;
    }

    private Date calculateStartDate(Date date) {
        assert (date != null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 7) {
            calendar.add(6, 2);
        } else if (dayOfWeek == 1) {
            calendar.add(6, 1);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date calculateEndDate(Date date) {
        assert (date != null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 7) {
            calendar.add(6, 2);
        } else if (dayOfWeek == 1) {
            calendar.add(6, 1);
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private Date addWeekdays(Date date, int weekdays) {
        assert (date != null);
        assert (weekdays > 0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = 0;
        switch (calendar.get(7)) {
            case 2: {
                days = weekdays + weekdays / 5 * 2;
                break;
            }
            case 3: {
                days = weekdays + (weekdays + 1) / 5 * 2;
                break;
            }
            case 4: {
                days = weekdays + (weekdays + 2) / 5 * 2;
                break;
            }
            case 5: {
                days = weekdays + (weekdays + 3) / 5 * 2;
                break;
            }
            case 6: {
                days = weekdays + (weekdays + 4) / 5 * 2;
                break;
            }
            case 7: {
                days = weekdays + (weekdays - 1) / 5 * 2 + 1;
                break;
            }
            case 1: {
                days = weekdays + (weekdays - 1) / 5 * 2;
            }
        }
        calendar.add(6, days);
        return calendar.getTime();
    }

    private Date minusWeekdays(Date date, int weekdays) {
        assert (date != null);
        assert (weekdays > 0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = 0;
        switch (calendar.get(7)) {
            case 6: {
                days = weekdays + weekdays / 5 * 2;
                break;
            }
            case 5: {
                days = weekdays + (weekdays + 1) / 5 * 2;
                break;
            }
            case 4: {
                days = weekdays + (weekdays + 2) / 5 * 2;
                break;
            }
            case 3: {
                days = weekdays + (weekdays + 3) / 5 * 2;
                break;
            }
            case 2: {
                days = weekdays + (weekdays + 4) / 5 * 2;
                break;
            }
            case 1: {
                days = weekdays + (weekdays - 1) / 5 * 2 + 1;
                break;
            }
            case 7: {
                days = weekdays + (weekdays - 1) / 5 * 2;
            }
        }
        calendar.add(6, days * -1);
        return calendar.getTime();
    }

    @Override
    public List<Date> getSelectedDates(Date startDate, Date templateDate) {
        assert (startDate != null);
        assert (templateDate != null);
        Calendar templateCal = Calendar.getInstance();
        templateCal.setTime(templateDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(11, templateCal.get(11));
        cal.set(12, templateCal.get(12));
        cal.set(13, templateCal.get(13));
        cal.set(14, templateCal.get(14));
        Vector<Date> dates = new Vector<Date>(1);
        dates.add(cal.getTime());
        return dates;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PeriodWeekday;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public void initialise(Date startDate) {
    }

    @Override
    public int getDefaultAdvanceNbr() {
        return RecurrencePrefs.getNbrFutureWeekday();
    }

    @Override
    public PeriodType getType() {
        return PeriodType.WEEKDAY;
    }

    @Override
    public Interval getPeriod(Date date) {
        return new Interval(this.calculateStartDate(date), this.calculateEndDate(date));
    }

    @Override
    public Interval addPeriods(Interval interval, int n) {
        if (n > 0) {
            return this.getPeriod(this.addWeekdays(interval.start, n));
        }
        if (n < 0) {
            return this.getPeriod(this.minusWeekdays(interval.start, Math.abs(n)));
        }
        return this.getPeriod(interval.start);
    }
}

