/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.SelectedItemsTable;
import org.netbeans.modules.maven.apisupport.PluginBackwardPropertyUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.spi.customizer.SelectedItemsTablePersister;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PublicPackagesPanel
extends JPanel
implements SelectedItemsTablePersister,
HelpCtx.Provider {
    private static final String ALL_SUBPACKAGES = ".*";
    private static final String ALL_SUBPACKAGES_2 = ".**";
    private static final int COALESCE_LIMIT = 2;
    private static final String PUBLIC_PACKAGE = "publicPackage";
    private static final String PUBLIC_PACKAGES = "publicPackages";
    private final SelectedItemsTable.SelectedItemsTableModel tableModel;
    private final ModelHandle2 handle;
    private final Project project;
    private ModelOperation<POMModel> operation;
    private JTable exportTable;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public PublicPackagesPanel(ModelHandle2 handle, Project prj) {
        this.handle = handle;
        this.project = prj;
        this.tableModel = new SelectedItemsTable.SelectedItemsTableModel((SelectedItemsTablePersister)this);
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(this.exportTable.getBackground());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.exportTable = new SelectedItemsTable(this.tableModel);
        this.jLabel1.setLabelFor(this.exportTable);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PublicPackagesPanel.class, (String)"PublicPackagesPanel.jLabel1.text"));
        this.jScrollPane1.setViewportView(this.exportTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(411, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 517, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE)));
    }

    public SortedMap<String, Boolean> read() {
        TreeMap<String, Boolean> pkgMap = new TreeMap<String, Boolean>();
        SortedSet packageNames = FileUtilities.getPackageNames((Project)this.project);
        for (String pkgName : packageNames) {
            pkgMap.put(pkgName, Boolean.FALSE);
        }
        String[] publicPkgs = PluginBackwardPropertyUtils.getPluginPropertyList(this.project, PUBLIC_PACKAGES, PUBLIC_PACKAGE, "manifest");
        if (publicPkgs != null) {
            for (int i = 0; i < publicPkgs.length; ++i) {
                String prefix = null;
                String curPkg = publicPkgs[i];
                if (curPkg.endsWith(ALL_SUBPACKAGES)) {
                    prefix = curPkg.substring(0, curPkg.length() - ALL_SUBPACKAGES.length());
                } else if (curPkg.endsWith(ALL_SUBPACKAGES_2)) {
                    prefix = curPkg.substring(0, curPkg.length() - ALL_SUBPACKAGES_2.length());
                }
                if (prefix == null) {
                    pkgMap.put(curPkg, Boolean.TRUE);
                    continue;
                }
                for (String pkgName : packageNames) {
                    if (!pkgName.startsWith(prefix)) continue;
                    pkgMap.put(pkgName, Boolean.TRUE);
                }
            }
        }
        return pkgMap;
    }

    public void write(SortedMap<String, Boolean> items) {
        if (this.operation != null) {
            this.handle.removePOMModification(this.operation);
        }
        final TreeMap<String, Boolean> selItems = new TreeMap<String, Boolean>(items);
        this.operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pomModel) {
                Build build = pomModel.getProject().getBuild();
                boolean selEmpty = true;
                for (Boolean selected : selItems.values()) {
                    if (!selected.booleanValue()) continue;
                    selEmpty = false;
                    break;
                }
                Plugin nbmPlugin = null;
                if (build != null) {
                    nbmPlugin = PluginBackwardPropertyUtils.findPluginFromBuild(build);
                } else {
                    build = pomModel.getFactory().createBuild();
                    pomModel.getProject().setBuild(build);
                }
                Configuration config = null;
                if (nbmPlugin != null) {
                    config = nbmPlugin.getConfiguration();
                } else {
                    nbmPlugin = pomModel.getFactory().createPlugin();
                    nbmPlugin.setGroupId("org.apache.netbeans.utilities");
                    nbmPlugin.setArtifactId("nbm-maven-plugin");
                    nbmPlugin.setExtensions(Boolean.TRUE);
                    build.addPlugin(nbmPlugin);
                }
                if (config == null) {
                    config = pomModel.getFactory().createConfiguration();
                    nbmPlugin.setConfiguration(config);
                }
                List configElems = config.getConfigurationElements();
                POMExtensibilityElement packages = null;
                for (Object elem : configElems) {
                    if (!PublicPackagesPanel.PUBLIC_PACKAGES.equals(elem.getQName().getLocalPart())) continue;
                    packages = elem;
                    break;
                }
                if (selEmpty) {
                    if (packages != null) {
                        config.removeExtensibilityElement(packages);
                    }
                    return;
                }
                packages = ModelUtils.getOrCreateChild((POMComponent)config, (String)PublicPackagesPanel.PUBLIC_PACKAGES, (POMModel)pomModel);
                List elems = packages.getAnyElements();
                for (POMExtensibilityElement elem : elems) {
                    packages.removeAnyElement(elem);
                }
                for (String elemText : PublicPackagesPanel.getPublicPackagesForPlugin(selItems)) {
                    POMExtensibilityElement publicP = pomModel.getFactory().createPOMExtensibilityElement(new QName(PublicPackagesPanel.PUBLIC_PACKAGE));
                    publicP.setElementText(elemText);
                    packages.addExtensibilityElement(publicP);
                }
            }
        };
        this.handle.addPOMModification(this.operation);
    }

    public static SortedSet<String> getPublicPackagesForPlugin(SortedMap<String, Boolean> selItems) {
        TreeSet<String> result = new TreeSet<String>();
        HashSet processed = new HashSet();
        for (Map.Entry<String, Boolean> entry : selItems.entrySet()) {
            if (!entry.getValue().booleanValue() || processed.contains(entry.getKey())) continue;
            boolean allSubpackages = true;
            HashSet<String> processedCandidates = new HashSet<String>();
            String prefix = entry.getKey() + ".";
            for (String key : selItems.keySet()) {
                if (!key.startsWith(prefix)) continue;
                if (((Boolean)selItems.get(key)).booleanValue()) {
                    processedCandidates.add(key);
                    continue;
                }
                allSubpackages = false;
                break;
            }
            if (allSubpackages && processedCandidates.size() > 2) {
                result.add(entry.getKey() + ALL_SUBPACKAGES);
                processed.addAll(processedCandidates);
                continue;
            }
            result.add(entry.getKey());
        }
        return result;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("maven_settings");
    }
}

