/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;

public abstract class AbstractDiskCache<K, T extends Serializable> {
    private static final Logger LOG = Logger.getLogger(AbstractDiskCache.class.getName());
    protected K key;
    private WeakReference<CacheEntry<T>> entryRef;

    protected AbstractDiskCache() {
    }

    protected AbstractDiskCache(K key) {
        this.key = key;
    }

    public final synchronized T loadData() {
        CacheEntry<T> e = this.loadEntry();
        return e != null ? (T)e.getData() : null;
    }

    public final boolean isCompatible() {
        CacheEntry<T> e = this.loadEntry();
        return e != null && e.isCompatible(this);
    }

    public final boolean isValid() {
        CacheEntry<T> e = this.loadEntry();
        return e != null && e.isValid(this);
    }

    public final synchronized void storeData(T data) {
        CacheEntry<T> entry = new CacheEntry<T>(this, data);
        if (this.doStoreEntry(entry)) {
            this.entryRef = new WeakReference<CacheEntry<CacheEntry<T>>>(entry);
        }
    }

    public final synchronized void invalidate() {
        this.entryRef = null;
        File cacheFile = this.cacheFile();
        if (cacheFile.canRead()) {
            cacheFile.delete();
        }
    }

    protected final synchronized CacheEntry<T> loadEntry() {
        CacheEntry<T> ret;
        CacheEntry<T> cacheEntry = ret = this.entryRef != null ? (CacheEntry<T>)this.entryRef.get() : null;
        if (ret == null && !GradleExperimentalSettings.getDefault().isCacheDisabled()) {
            ret = this.doLoadEntry();
            this.entryRef = ret != null ? new WeakReference<CacheEntry<CacheEntry<CacheEntry<CacheEntry<T>>>>>(ret) : null;
        }
        return ret;
    }

    protected CacheEntry<T> doLoadEntry() {
        CacheEntry ret = null;
        File cacheFile = this.cacheFile();
        if (cacheFile.canRead()) {
            try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(cacheFile));){
                ret = (CacheEntry)is.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                LOG.log(Level.INFO, "Could no load project info from {0} due to: {1}", new Object[]{cacheFile, ex.getMessage()});
                cacheFile.delete();
            }
        }
        return ret;
    }

    protected boolean doStoreEntry(CacheEntry<T> entry) {
        boolean bl;
        File cacheFile = this.cacheFile();
        if (!cacheFile.exists()) {
            cacheFile.getParentFile().mkdirs();
        }
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(cacheFile));
        try {
            os.writeObject(entry);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Failed to persist info to {0} due to {1}", new Object[]{cacheFile, ex.getMessage()});
                cacheFile.delete();
                return false;
            }
        }
        os.close();
        return bl;
    }

    protected abstract int cacheVersion();

    protected abstract File cacheFile();

    protected abstract Set<File> cacheInvalidators();

    public static final class CacheEntry<T extends Serializable>
    implements Serializable {
        static final long serialVersionUID = 1L;
        int version;
        long timestamp;
        Set<File> sourceFiles;
        T data;

        protected CacheEntry() {
        }

        protected CacheEntry(AbstractDiskCache<?, T> cache, T data) {
            this.timestamp = System.currentTimeMillis();
            this.version = cache.cacheVersion();
            this.sourceFiles = cache.cacheInvalidators();
            this.data = data;
        }

        public boolean isCompatible(AbstractDiskCache<?, T> cache) {
            return this.version == cache.cacheVersion();
        }

        public boolean isValid(AbstractDiskCache<?, T> cache) {
            boolean ret;
            boolean bl = ret = this.data != null && this.isCompatible(cache);
            if (ret && this.sourceFiles != null) {
                for (File f : this.sourceFiles) {
                    if (f.exists() && f.lastModified() <= this.timestamp) continue;
                    ret = false;
                    break;
                }
            }
            return ret;
        }

        public T getData() {
            return this.data;
        }

        public String toString() {
            Class<?> dataClass = this.data != null ? this.data.getClass() : null;
            return "CacheEntryImpl{data:version=" + dataClass + ":" + this.version + ", timestamp=" + new Date(this.timestamp) + ", sourceFiles=" + this.sourceFiles + "}";
        }
    }
}

