/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cloud.oracle.assets.SuggestedItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public class PolicyGenerator {
    public static List<String> getPolicyStatementsFor(Collection<OCIItem> items) {
        OCIItem execution = PolicyGenerator.getExecutionEnvironment(items);
        if (execution == null) {
            return List.of();
        }
        String principalType = PolicyGenerator.getPrincipalType(execution);
        ArrayList<String> result = new ArrayList<String>();
        for (OCIItem item : items) {
            switch (item.getKey().getPath()) {
                case "Database": {
                    result.add("Allow any-user to manage autonomous-database-family in compartment id " + item.getCompartmentId() + " where ALL { request.principal.compartment.id = '" + execution.getCompartmentId() + "' }");
                    break;
                }
                case "Bucket": {
                    result.add("Allow any-user to manage object-family in compartment id " + item.getCompartmentId() + " where ALL { request.principal.type = '" + principalType + "', request.principal.compartment.id = '" + execution.getCompartmentId() + "' }");
                    break;
                }
                case "Vault": {
                    result.add("Allow any-user to read secret-family in compartment id " + item.getCompartmentId() + " where ALL { request.principal.type = '" + principalType + "', request.principal.compartment.id = '" + execution.getCompartmentId() + "' }");
                }
            }
        }
        return result;
    }

    private static String getPrincipalType(OCIItem executionEnvironment) {
        if ("ComputeInstance".equals(executionEnvironment.getKey().getPath())) {
            return "instance";
        }
        return "cluster";
    }

    private static OCIItem getExecutionEnvironment(Collection<OCIItem> items) {
        OCIItem execution = null;
        for (OCIItem item : items) {
            if (!"Cluster".equals(item.getKey().getPath()) && !"ComputeInstance".equals(item.getKey().getPath())) continue;
            if (execution != null) {
                throw new IllegalStateException("More than one execution environment found");
            }
            execution = item;
        }
        return execution;
    }

    public static String createPolicies(Collection<OCIItem> items) {
        List<String> statements = PolicyGenerator.getPolicyStatementsFor(items);
        if (statements.isEmpty()) {
            return "# Resolve execution environment suggestion";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PolicyGenerator.prettyPrintStatements(statements));
        sb.append(PolicyGenerator.resolveSuggestions(items));
        return sb.toString();
    }

    private static String prettyPrintStatements(List<String> statements) {
        String[] newLineBefore = new String[]{"in ", "where ", "}"};
        String[] newLineAfter = new String[]{"\\{", ",", "}"};
        String result = String.join((CharSequence)"\n", statements);
        for (String keyword : newLineBefore) {
            result = result.replaceAll(keyword, "\n" + keyword);
        }
        for (String keyword : newLineAfter) {
            result = result.replaceAll(keyword, keyword + "\n");
        }
        return result;
    }

    private static String resolveSuggestions(Collection<OCIItem> items) {
        StringBuilder sb = new StringBuilder();
        items.stream().filter(item -> "Suggested".equals(item.getKey().getPath())).forEach(item -> sb.append("# Resolve suggestion:").append(((SuggestedItem)item).getPath()).append("\n"));
        return sb.toString();
    }
}

