/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseConnectionCredentials;
import com.oracle.bmc.database.model.DatabaseConnectionString;
import com.oracle.bmc.database.model.ExternalDatabaseConnector;
import com.oracle.bmc.database.model.ExternalDatabaseConnectorSummary;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectorType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalMacsConnectorSummary
extends ExternalDatabaseConnectorSummary {
    @JsonProperty(value="connectionString")
    private final DatabaseConnectionString connectionString;
    @JsonProperty(value="connectionCredentials")
    private final DatabaseConnectionCredentials connectionCredentials;
    @JsonProperty(value="connectorAgentId")
    private final String connectorAgentId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalMacsConnectorSummary(String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String displayName, String id, ExternalDatabaseConnector.LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, String externalDatabaseId, String connectionStatus, Date timeConnectionStatusLastUpdated, DatabaseConnectionString connectionString, DatabaseConnectionCredentials connectionCredentials, String connectorAgentId) {
        super(compartmentId, freeformTags, definedTags, displayName, id, lifecycleState, lifecycleDetails, timeCreated, externalDatabaseId, connectionStatus, timeConnectionStatusLastUpdated);
        this.connectionString = connectionString;
        this.connectionCredentials = connectionCredentials;
        this.connectorAgentId = connectorAgentId;
    }

    public DatabaseConnectionString getConnectionString() {
        return this.connectionString;
    }

    public DatabaseConnectionCredentials getConnectionCredentials() {
        return this.connectionCredentials;
    }

    public String getConnectorAgentId() {
        return this.connectorAgentId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalMacsConnectorSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", connectionString=").append(String.valueOf((Object)this.connectionString));
        sb.append(", connectionCredentials=").append(String.valueOf((Object)this.connectionCredentials));
        sb.append(", connectorAgentId=").append(String.valueOf(this.connectorAgentId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalMacsConnectorSummary)) {
            return false;
        }
        ExternalMacsConnectorSummary other = (ExternalMacsConnectorSummary)((Object)o);
        return Objects.equals((Object)this.connectionString, (Object)other.connectionString) && Objects.equals((Object)this.connectionCredentials, (Object)other.connectionCredentials) && Objects.equals(this.connectorAgentId, other.connectorAgentId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.connectionCredentials == null ? 43 : this.connectionCredentials.hashCode());
        result = result * 59 + (this.connectorAgentId == null ? 43 : this.connectorAgentId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private ExternalDatabaseConnector.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="externalDatabaseId")
        private String externalDatabaseId;
        @JsonProperty(value="connectionStatus")
        private String connectionStatus;
        @JsonProperty(value="timeConnectionStatusLastUpdated")
        private Date timeConnectionStatusLastUpdated;
        @JsonProperty(value="connectionString")
        private DatabaseConnectionString connectionString;
        @JsonProperty(value="connectionCredentials")
        private DatabaseConnectionCredentials connectionCredentials;
        @JsonProperty(value="connectorAgentId")
        private String connectorAgentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(ExternalDatabaseConnector.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder externalDatabaseId(String externalDatabaseId) {
            this.externalDatabaseId = externalDatabaseId;
            this.__explicitlySet__.add("externalDatabaseId");
            return this;
        }

        public Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            this.__explicitlySet__.add("connectionStatus");
            return this;
        }

        public Builder timeConnectionStatusLastUpdated(Date timeConnectionStatusLastUpdated) {
            this.timeConnectionStatusLastUpdated = timeConnectionStatusLastUpdated;
            this.__explicitlySet__.add("timeConnectionStatusLastUpdated");
            return this;
        }

        public Builder connectionString(DatabaseConnectionString connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder connectionCredentials(DatabaseConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            this.__explicitlySet__.add("connectionCredentials");
            return this;
        }

        public Builder connectorAgentId(String connectorAgentId) {
            this.connectorAgentId = connectorAgentId;
            this.__explicitlySet__.add("connectorAgentId");
            return this;
        }

        public ExternalMacsConnectorSummary build() {
            ExternalMacsConnectorSummary model = new ExternalMacsConnectorSummary(this.compartmentId, this.freeformTags, this.definedTags, this.displayName, this.id, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.externalDatabaseId, this.connectionStatus, this.timeConnectionStatusLastUpdated, this.connectionString, this.connectionCredentials, this.connectorAgentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalMacsConnectorSummary model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("externalDatabaseId")) {
                this.externalDatabaseId(model.getExternalDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("connectionStatus")) {
                this.connectionStatus(model.getConnectionStatus());
            }
            if (model.wasPropertyExplicitlySet("timeConnectionStatusLastUpdated")) {
                this.timeConnectionStatusLastUpdated(model.getTimeConnectionStatusLastUpdated());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("connectionCredentials")) {
                this.connectionCredentials(model.getConnectionCredentials());
            }
            if (model.wasPropertyExplicitlySet("connectorAgentId")) {
                this.connectorAgentId(model.getConnectorAgentId());
            }
            return this;
        }
    }
}

