/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiskPerformanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="diskIops")
    private final Float diskIops;
    @JsonProperty(value="diskThroughputInMbps")
    private final Float diskThroughputInMbps;

    @Deprecated
    @ConstructorProperties(value={"diskIops", "diskThroughputInMbps"})
    public DiskPerformanceDetails(Float diskIops, Float diskThroughputInMbps) {
        this.diskIops = diskIops;
        this.diskThroughputInMbps = diskThroughputInMbps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getDiskIops() {
        return this.diskIops;
    }

    public Float getDiskThroughputInMbps() {
        return this.diskThroughputInMbps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskPerformanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("diskIops=").append(String.valueOf(this.diskIops));
        sb.append(", diskThroughputInMbps=").append(String.valueOf(this.diskThroughputInMbps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiskPerformanceDetails)) {
            return false;
        }
        DiskPerformanceDetails other = (DiskPerformanceDetails)((Object)o);
        return Objects.equals(this.diskIops, other.diskIops) && Objects.equals(this.diskThroughputInMbps, other.diskThroughputInMbps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.diskIops == null ? 43 : this.diskIops.hashCode());
        result = result * 59 + (this.diskThroughputInMbps == null ? 43 : this.diskThroughputInMbps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="diskIops")
        private Float diskIops;
        @JsonProperty(value="diskThroughputInMbps")
        private Float diskThroughputInMbps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder diskIops(Float diskIops) {
            this.diskIops = diskIops;
            this.__explicitlySet__.add("diskIops");
            return this;
        }

        public Builder diskThroughputInMbps(Float diskThroughputInMbps) {
            this.diskThroughputInMbps = diskThroughputInMbps;
            this.__explicitlySet__.add("diskThroughputInMbps");
            return this;
        }

        public DiskPerformanceDetails build() {
            DiskPerformanceDetails model = new DiskPerformanceDetails(this.diskIops, this.diskThroughputInMbps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiskPerformanceDetails model) {
            if (model.wasPropertyExplicitlySet("diskIops")) {
                this.diskIops(model.getDiskIops());
            }
            if (model.wasPropertyExplicitlySet("diskThroughputInMbps")) {
                this.diskThroughputInMbps(model.getDiskThroughputInMbps());
            }
            return this;
        }
    }
}

