/*****************************************************************************
 *
 * This file is part of Mapnik (c++ mapping toolkit)
 *
 * Copyright (C) 2021 Artem Pavlenko
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

#ifndef MAPNIK_DATASOURCE_GEOMETRY_TYPE_HPP
#define MAPNIK_DATASOURCE_GEOMETRY_TYPE_HPP

#include <cstdint>

namespace mapnik {

enum datasource_geometry_t : std::uint8_t { Unknown = 0, Point = 1, LineString = 2, Polygon = 3, Collection = 4 };

}

#endif // MAPNIK_DATASOURCE_GEOMETRY_TYPE_HPP
