# -*- coding: utf-8 -*-
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from collections import OrderedDict
import functools
import re
from typing import Dict, Callable, Mapping, MutableMapping, MutableSequence, Optional, Sequence, Tuple, Type, Union

from googlecloudsdk.generated_clients.gapic_clients.run_v2 import gapic_version as package_version

from google.api_core.client_options import ClientOptions
from google.api_core import exceptions as core_exceptions
from google.api_core import gapic_v1
from google.api_core import retry_async as retries
from google.auth import credentials as ga_credentials   # type: ignore
from google.oauth2 import service_account              # type: ignore


try:
    OptionalRetry = Union[retries.AsyncRetry, gapic_v1.method._MethodDefault, None]
except AttributeError:  # pragma: NO COVER
    OptionalRetry = Union[retries.AsyncRetry, object, None]  # type: ignore

from google.api import launch_stage_pb2  # type: ignore
from google.api_core import operation  # type: ignore
from google.api_core import operation_async  # type: ignore
from cloudsdk.google.protobuf import field_mask_pb2  # type: ignore
from cloudsdk.google.protobuf import timestamp_pb2  # type: ignore
from googlecloudsdk.generated_clients.gapic_clients.run_v2.services.worker_pools import pagers
from googlecloudsdk.generated_clients.gapic_clients.run_v2.types import condition
from googlecloudsdk.generated_clients.gapic_clients.run_v2.types import instance_split
from googlecloudsdk.generated_clients.gapic_clients.run_v2.types import vendor_settings
from googlecloudsdk.generated_clients.gapic_clients.run_v2.types import worker_pool
from googlecloudsdk.generated_clients.gapic_clients.run_v2.types import worker_pool as gcr_worker_pool
from googlecloudsdk.generated_clients.gapic_clients.run_v2.types import worker_pool_revision_template
from .transports.base import WorkerPoolsTransport, DEFAULT_CLIENT_INFO
from .transports.grpc_asyncio import WorkerPoolsGrpcAsyncIOTransport
from .client import WorkerPoolsClient


class WorkerPoolsAsyncClient:
    """Cloud Run WorkerPool Control Plane API."""

    _client: WorkerPoolsClient

    # Copy defaults from the synchronous client for use here.
    # Note: DEFAULT_ENDPOINT is deprecated. Use _DEFAULT_ENDPOINT_TEMPLATE instead.
    DEFAULT_ENDPOINT = WorkerPoolsClient.DEFAULT_ENDPOINT
    DEFAULT_MTLS_ENDPOINT = WorkerPoolsClient.DEFAULT_MTLS_ENDPOINT
    _DEFAULT_ENDPOINT_TEMPLATE = WorkerPoolsClient._DEFAULT_ENDPOINT_TEMPLATE
    _DEFAULT_UNIVERSE = WorkerPoolsClient._DEFAULT_UNIVERSE

    connector_path = staticmethod(WorkerPoolsClient.connector_path)
    parse_connector_path = staticmethod(WorkerPoolsClient.parse_connector_path)
    crypto_key_path = staticmethod(WorkerPoolsClient.crypto_key_path)
    parse_crypto_key_path = staticmethod(WorkerPoolsClient.parse_crypto_key_path)
    revision_path = staticmethod(WorkerPoolsClient.revision_path)
    parse_revision_path = staticmethod(WorkerPoolsClient.parse_revision_path)
    secret_path = staticmethod(WorkerPoolsClient.secret_path)
    parse_secret_path = staticmethod(WorkerPoolsClient.parse_secret_path)
    secret_version_path = staticmethod(WorkerPoolsClient.secret_version_path)
    parse_secret_version_path = staticmethod(WorkerPoolsClient.parse_secret_version_path)
    common_billing_account_path = staticmethod(WorkerPoolsClient.common_billing_account_path)
    parse_common_billing_account_path = staticmethod(WorkerPoolsClient.parse_common_billing_account_path)
    common_folder_path = staticmethod(WorkerPoolsClient.common_folder_path)
    parse_common_folder_path = staticmethod(WorkerPoolsClient.parse_common_folder_path)
    common_organization_path = staticmethod(WorkerPoolsClient.common_organization_path)
    parse_common_organization_path = staticmethod(WorkerPoolsClient.parse_common_organization_path)
    common_project_path = staticmethod(WorkerPoolsClient.common_project_path)
    parse_common_project_path = staticmethod(WorkerPoolsClient.parse_common_project_path)
    common_location_path = staticmethod(WorkerPoolsClient.common_location_path)
    parse_common_location_path = staticmethod(WorkerPoolsClient.parse_common_location_path)

    @classmethod
    def from_service_account_info(cls, info: dict, *args, **kwargs):
        """Creates an instance of this client using the provided credentials
            info.

        Args:
            info (dict): The service account private key info.
            args: Additional arguments to pass to the constructor.
            kwargs: Additional arguments to pass to the constructor.

        Returns:
            WorkerPoolsAsyncClient: The constructed client.
        """
        return WorkerPoolsClient.from_service_account_info.__func__(WorkerPoolsAsyncClient, info, *args, **kwargs)  # type: ignore

    @classmethod
    def from_service_account_file(cls, filename: str, *args, **kwargs):
        """Creates an instance of this client using the provided credentials
            file.

        Args:
            filename (str): The path to the service account private key json
                file.
            args: Additional arguments to pass to the constructor.
            kwargs: Additional arguments to pass to the constructor.

        Returns:
            WorkerPoolsAsyncClient: The constructed client.
        """
        return WorkerPoolsClient.from_service_account_file.__func__(WorkerPoolsAsyncClient, filename, *args, **kwargs)  # type: ignore

    from_service_account_json = from_service_account_file

    @classmethod
    def get_mtls_endpoint_and_cert_source(cls, client_options: Optional[ClientOptions] = None):
        """Return the API endpoint and client cert source for mutual TLS.

        The client cert source is determined in the following order:
        (1) if `GOOGLE_API_USE_CLIENT_CERTIFICATE` environment variable is not "true", the
        client cert source is None.
        (2) if `client_options.client_cert_source` is provided, use the provided one; if the
        default client cert source exists, use the default one; otherwise the client cert
        source is None.

        The API endpoint is determined in the following order:
        (1) if `client_options.api_endpoint` if provided, use the provided one.
        (2) if `GOOGLE_API_USE_CLIENT_CERTIFICATE` environment variable is "always", use the
        default mTLS endpoint; if the environment variable is "never", use the default API
        endpoint; otherwise if client cert source exists, use the default mTLS endpoint, otherwise
        use the default API endpoint.

        More details can be found at https://google.aip.dev/auth/4114.

        Args:
            client_options (google.api_core.client_options.ClientOptions): Custom options for the
                client. Only the `api_endpoint` and `client_cert_source` properties may be used
                in this method.

        Returns:
            Tuple[str, Callable[[], Tuple[bytes, bytes]]]: returns the API endpoint and the
                client cert source to use.

        Raises:
            google.auth.exceptions.MutualTLSChannelError: If any errors happen.
        """
        return WorkerPoolsClient.get_mtls_endpoint_and_cert_source(client_options)  # type: ignore

    @property
    def transport(self) -> WorkerPoolsTransport:
        """Returns the transport used by the client instance.

        Returns:
            WorkerPoolsTransport: The transport used by the client instance.
        """
        return self._client.transport

    @property
    def api_endpoint(self):
        """Return the API endpoint used by the client instance.

        Returns:
            str: The API endpoint used by the client instance.
        """
        return self._client._api_endpoint

    @property
    def universe_domain(self) -> str:
        """Return the universe domain used by the client instance.

        Returns:
            str: The universe domain used
                by the client instance.
        """
        return self._client._universe_domain

    get_transport_class = functools.partial(type(WorkerPoolsClient).get_transport_class, type(WorkerPoolsClient))

    def __init__(self, *,
            credentials: Optional[ga_credentials.Credentials] = None,
            transport: Optional[Union[str, WorkerPoolsTransport, Callable[..., WorkerPoolsTransport]]] = "grpc_asyncio",
            client_options: Optional[ClientOptions] = None,
            client_info: gapic_v1.client_info.ClientInfo = DEFAULT_CLIENT_INFO,
            ) -> None:
        """Instantiates the worker pools async client.

        Args:
            credentials (Optional[google.auth.credentials.Credentials]): The
                authorization credentials to attach to requests. These
                credentials identify the application to the service; if none
                are specified, the client will attempt to ascertain the
                credentials from the environment.
            transport (Optional[Union[str,WorkerPoolsTransport,Callable[..., WorkerPoolsTransport]]]):
                The transport to use, or a Callable that constructs and returns a new transport to use.
                If a Callable is given, it will be called with the same set of initialization
                arguments as used in the WorkerPoolsTransport constructor.
                If set to None, a transport is chosen automatically.
                NOTE: "rest" transport functionality is currently in a
                beta state (preview). We welcome your feedback via an
                issue in this library's source repository.
            client_options (Optional[Union[google.api_core.client_options.ClientOptions, dict]]):
                Custom options for the client.

                1. The ``api_endpoint`` property can be used to override the
                default endpoint provided by the client when ``transport`` is
                not explicitly provided. Only if this property is not set and
                ``transport`` was not explicitly provided, the endpoint is
                determined by the GOOGLE_API_USE_MTLS_ENDPOINT environment
                variable, which have one of the following values:
                "always" (always use the default mTLS endpoint), "never" (always
                use the default regular endpoint) and "auto" (auto-switch to the
                default mTLS endpoint if client certificate is present; this is
                the default value).

                2. If the GOOGLE_API_USE_CLIENT_CERTIFICATE environment variable
                is "true", then the ``client_cert_source`` property can be used
                to provide a client certificate for mTLS transport. If
                not provided, the default SSL client certificate will be used if
                present. If GOOGLE_API_USE_CLIENT_CERTIFICATE is "false" or not
                set, no client certificate will be used.

                3. The ``universe_domain`` property can be used to override the
                default "googleapis.com" universe. Note that ``api_endpoint``
                property still takes precedence; and ``universe_domain`` is
                currently not supported for mTLS.

            client_info (google.api_core.gapic_v1.client_info.ClientInfo):
                The client info used to send a user-agent string along with
                API requests. If ``None``, then default info will be used.
                Generally, you only need to set this if you're developing
                your own client library.

        Raises:
            google.auth.exceptions.MutualTlsChannelError: If mutual TLS transport
                creation failed for any reason.
        """
        self._client = WorkerPoolsClient(
            credentials=credentials,
            transport=transport,
            client_options=client_options,
            client_info=client_info,

        )

    async def create_worker_pool(self,
            request: Optional[Union[gcr_worker_pool.CreateWorkerPoolRequest, dict]] = None,
            *,
            parent: Optional[str] = None,
            worker_pool: Optional[gcr_worker_pool.WorkerPool] = None,
            worker_pool_id: Optional[str] = None,
            retry: OptionalRetry = gapic_v1.method.DEFAULT,
            timeout: Union[float, object] = gapic_v1.method.DEFAULT,
            metadata: Sequence[Tuple[str, str]] = (),
            ) -> operation_async.AsyncOperation:
        r"""Creates a new WorkerPool in a given project and
        location.

        .. code-block:: python

            # This snippet has been automatically generated and should be regarded as a
            # code template only.
            # It will require modifications to work:
            # - It may require correct/in-range values for request initialization.
            # - It may require specifying regional endpoints when creating the service
            #   client as shown in:
            #   https://googleapis.dev/python/google-api-core/latest/client_options.html
            from googlecloudsdk.generated_clients.gapic_clients import run_v2

            async def sample_create_worker_pool():
                # Create a client
                client = run_v2.WorkerPoolsAsyncClient()

                # Initialize request argument(s)
                request = run_v2.CreateWorkerPoolRequest(
                    parent="parent_value",
                    worker_pool_id="worker_pool_id_value",
                )

                # Make the request
                operation = client.create_worker_pool(request=request)

                print("Waiting for operation to complete...")

                response = (await operation).result()

                # Handle the response
                print(response)

        Args:
            request (Optional[Union[googlecloudsdk.generated_clients.gapic_clients.run_v2.types.CreateWorkerPoolRequest, dict]]):
                The request object. Request message for creating a
                WorkerPool.
            parent (:class:`str`):
                Required. The location and project in
                which this worker pool should be
                created. Format:
                projects/{project}/locations/{location},
                where {project} can be project id or
                number. Only lowercase characters,
                digits, and hyphens.

                This corresponds to the ``parent`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            worker_pool (:class:`googlecloudsdk.generated_clients.gapic_clients.run_v2.types.WorkerPool`):
                Required. The WorkerPool instance to
                create.

                This corresponds to the ``worker_pool`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            worker_pool_id (:class:`str`):
                Required. The unique identifier for the WorkerPool. It
                must begin with letter, and cannot end with hyphen; must
                contain fewer than 50 characters. The name of the worker
                pool becomes {parent}/workerPools/{worker_pool_id}.

                This corresponds to the ``worker_pool_id`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry_async.AsyncRetry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.api_core.operation_async.AsyncOperation:
                An object representing a long-running operation.

                The result type for the operation will be :class:`googlecloudsdk.generated_clients.gapic_clients.run_v2.types.WorkerPool` WorkerPool acts as a top-level container that manages a set of
                   configurations and revision templates which implement
                   a pull-based workload. WorkerPool exists to provide a
                   singular abstraction which can be access controlled,
                   reasoned about, and which encapsulates software
                   lifecycle decisions such as rollout policy and team
                   resource ownership.

        """
        # Create or coerce a protobuf request object.
        # - Quick check: If we got a request object, we should *not* have
        #   gotten any keyword arguments that map to the request.
        has_flattened_params = any([parent, worker_pool, worker_pool_id])
        if request is not None and has_flattened_params:
            raise ValueError("If the `request` argument is set, then none of "
                             "the individual field arguments should be set.")

        # - Use the request object if provided (there's no risk of modifying the input as
        #   there are no flattened fields), or create one.
        if not isinstance(request, gcr_worker_pool.CreateWorkerPoolRequest):
            request = gcr_worker_pool.CreateWorkerPoolRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if parent is not None:
            request.parent = parent
        if worker_pool is not None:
            request.worker_pool = worker_pool
        if worker_pool_id is not None:
            request.worker_pool_id = worker_pool_id

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = self._client._transport._wrapped_methods[self._client._transport.create_worker_pool]

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((
                ("parent", request.parent),
            )),
        )

        # Validate the universe domain.
        self._client._validate_universe_domain()

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Wrap the response in an operation future.
        response = operation_async.from_gapic(
            response,
            self._client._transport.operations_client,
            gcr_worker_pool.WorkerPool,
            metadata_type=gcr_worker_pool.WorkerPool,
        )

        # Done; return the response.
        return response

    async def get_worker_pool(self,
            request: Optional[Union[worker_pool.GetWorkerPoolRequest, dict]] = None,
            *,
            name: Optional[str] = None,
            retry: OptionalRetry = gapic_v1.method.DEFAULT,
            timeout: Union[float, object] = gapic_v1.method.DEFAULT,
            metadata: Sequence[Tuple[str, str]] = (),
            ) -> worker_pool.WorkerPool:
        r"""Gets information about a WorkerPool.

        .. code-block:: python

            # This snippet has been automatically generated and should be regarded as a
            # code template only.
            # It will require modifications to work:
            # - It may require correct/in-range values for request initialization.
            # - It may require specifying regional endpoints when creating the service
            #   client as shown in:
            #   https://googleapis.dev/python/google-api-core/latest/client_options.html
            from googlecloudsdk.generated_clients.gapic_clients import run_v2

            async def sample_get_worker_pool():
                # Create a client
                client = run_v2.WorkerPoolsAsyncClient()

                # Initialize request argument(s)
                request = run_v2.GetWorkerPoolRequest(
                    name="name_value",
                )

                # Make the request
                response = await client.get_worker_pool(request=request)

                # Handle the response
                print(response)

        Args:
            request (Optional[Union[googlecloudsdk.generated_clients.gapic_clients.run_v2.types.GetWorkerPoolRequest, dict]]):
                The request object. Request message for obtaining a
                WorkerPool by its full name.
            name (:class:`str`):
                Required. The full name of the WorkerPool. Format:
                projects/{project}/locations/{location}/workerPools/{worker_pool},
                where {project} can be project id or number.

                This corresponds to the ``name`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry_async.AsyncRetry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            googlecloudsdk.generated_clients.gapic_clients.run_v2.types.WorkerPool:
                WorkerPool acts as a top-level
                container that manages a set of
                configurations and revision templates
                which implement a pull-based workload.
                WorkerPool exists to provide a singular
                abstraction which can be access
                controlled, reasoned about, and which
                encapsulates software lifecycle
                decisions such as rollout policy and
                team resource ownership.

        """
        # Create or coerce a protobuf request object.
        # - Quick check: If we got a request object, we should *not* have
        #   gotten any keyword arguments that map to the request.
        has_flattened_params = any([name])
        if request is not None and has_flattened_params:
            raise ValueError("If the `request` argument is set, then none of "
                             "the individual field arguments should be set.")

        # - Use the request object if provided (there's no risk of modifying the input as
        #   there are no flattened fields), or create one.
        if not isinstance(request, worker_pool.GetWorkerPoolRequest):
            request = worker_pool.GetWorkerPoolRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if name is not None:
            request.name = name

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = self._client._transport._wrapped_methods[self._client._transport.get_worker_pool]

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((
                ("name", request.name),
            )),
        )

        # Validate the universe domain.
        self._client._validate_universe_domain()

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Done; return the response.
        return response

    async def list_worker_pools(self,
            request: Optional[Union[worker_pool.ListWorkerPoolsRequest, dict]] = None,
            *,
            parent: Optional[str] = None,
            retry: OptionalRetry = gapic_v1.method.DEFAULT,
            timeout: Union[float, object] = gapic_v1.method.DEFAULT,
            metadata: Sequence[Tuple[str, str]] = (),
            ) -> pagers.ListWorkerPoolsAsyncPager:
        r"""Lists WorkerPools. Results are sorted by creation
        time, descending.

        .. code-block:: python

            # This snippet has been automatically generated and should be regarded as a
            # code template only.
            # It will require modifications to work:
            # - It may require correct/in-range values for request initialization.
            # - It may require specifying regional endpoints when creating the service
            #   client as shown in:
            #   https://googleapis.dev/python/google-api-core/latest/client_options.html
            from googlecloudsdk.generated_clients.gapic_clients import run_v2

            async def sample_list_worker_pools():
                # Create a client
                client = run_v2.WorkerPoolsAsyncClient()

                # Initialize request argument(s)
                request = run_v2.ListWorkerPoolsRequest(
                    parent="parent_value",
                )

                # Make the request
                page_result = client.list_worker_pools(request=request)

                # Handle the response
                async for response in page_result:
                    print(response)

        Args:
            request (Optional[Union[googlecloudsdk.generated_clients.gapic_clients.run_v2.types.ListWorkerPoolsRequest, dict]]):
                The request object. Request message for retrieving a list
                of WorkerPools.
            parent (:class:`str`):
                Required. The location and project to
                list resources on. Location must be a
                valid Google Cloud region, and cannot be
                the "-" wildcard. Format:
                projects/{project}/locations/{location},
                where {project} can be project id or
                number.

                This corresponds to the ``parent`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry_async.AsyncRetry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            googlecloudsdk.generated_clients.gapic_clients.run_v2.services.worker_pools.pagers.ListWorkerPoolsAsyncPager:
                Response message containing a list of
                WorkerPools.
                Iterating over this object will yield
                results and resolve additional pages
                automatically.

        """
        # Create or coerce a protobuf request object.
        # - Quick check: If we got a request object, we should *not* have
        #   gotten any keyword arguments that map to the request.
        has_flattened_params = any([parent])
        if request is not None and has_flattened_params:
            raise ValueError("If the `request` argument is set, then none of "
                             "the individual field arguments should be set.")

        # - Use the request object if provided (there's no risk of modifying the input as
        #   there are no flattened fields), or create one.
        if not isinstance(request, worker_pool.ListWorkerPoolsRequest):
            request = worker_pool.ListWorkerPoolsRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if parent is not None:
            request.parent = parent

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = self._client._transport._wrapped_methods[self._client._transport.list_worker_pools]

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((
                ("parent", request.parent),
            )),
        )

        # Validate the universe domain.
        self._client._validate_universe_domain()

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # This method is paged; wrap the response in a pager, which provides
        # an `__aiter__` convenience method.
        response = pagers.ListWorkerPoolsAsyncPager(
            method=rpc,
            request=request,
            response=response,
            metadata=metadata,
        )

        # Done; return the response.
        return response

    async def update_worker_pool(self,
            request: Optional[Union[gcr_worker_pool.UpdateWorkerPoolRequest, dict]] = None,
            *,
            worker_pool: Optional[gcr_worker_pool.WorkerPool] = None,
            update_mask: Optional[field_mask_pb2.FieldMask] = None,
            retry: OptionalRetry = gapic_v1.method.DEFAULT,
            timeout: Union[float, object] = gapic_v1.method.DEFAULT,
            metadata: Sequence[Tuple[str, str]] = (),
            ) -> operation_async.AsyncOperation:
        r"""Updates a WorkerPool.

        .. code-block:: python

            # This snippet has been automatically generated and should be regarded as a
            # code template only.
            # It will require modifications to work:
            # - It may require correct/in-range values for request initialization.
            # - It may require specifying regional endpoints when creating the service
            #   client as shown in:
            #   https://googleapis.dev/python/google-api-core/latest/client_options.html
            from googlecloudsdk.generated_clients.gapic_clients import run_v2

            async def sample_update_worker_pool():
                # Create a client
                client = run_v2.WorkerPoolsAsyncClient()

                # Initialize request argument(s)
                request = run_v2.UpdateWorkerPoolRequest(
                )

                # Make the request
                operation = client.update_worker_pool(request=request)

                print("Waiting for operation to complete...")

                response = (await operation).result()

                # Handle the response
                print(response)

        Args:
            request (Optional[Union[googlecloudsdk.generated_clients.gapic_clients.run_v2.types.UpdateWorkerPoolRequest, dict]]):
                The request object. Request message for updating a worker
                pool.
            worker_pool (:class:`googlecloudsdk.generated_clients.gapic_clients.run_v2.types.WorkerPool`):
                Required. The WorkerPool to be
                updated.

                This corresponds to the ``worker_pool`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            update_mask (:class:`google.protobuf.field_mask_pb2.FieldMask`):
                Optional. The list of fields to be
                updated.

                This corresponds to the ``update_mask`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry_async.AsyncRetry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.api_core.operation_async.AsyncOperation:
                An object representing a long-running operation.

                The result type for the operation will be :class:`googlecloudsdk.generated_clients.gapic_clients.run_v2.types.WorkerPool` WorkerPool acts as a top-level container that manages a set of
                   configurations and revision templates which implement
                   a pull-based workload. WorkerPool exists to provide a
                   singular abstraction which can be access controlled,
                   reasoned about, and which encapsulates software
                   lifecycle decisions such as rollout policy and team
                   resource ownership.

        """
        # Create or coerce a protobuf request object.
        # - Quick check: If we got a request object, we should *not* have
        #   gotten any keyword arguments that map to the request.
        has_flattened_params = any([worker_pool, update_mask])
        if request is not None and has_flattened_params:
            raise ValueError("If the `request` argument is set, then none of "
                             "the individual field arguments should be set.")

        # - Use the request object if provided (there's no risk of modifying the input as
        #   there are no flattened fields), or create one.
        if not isinstance(request, gcr_worker_pool.UpdateWorkerPoolRequest):
            request = gcr_worker_pool.UpdateWorkerPoolRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if worker_pool is not None:
            request.worker_pool = worker_pool
        if update_mask is not None:
            request.update_mask = update_mask

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = self._client._transport._wrapped_methods[self._client._transport.update_worker_pool]

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((
                ("worker_pool.name", request.worker_pool.name),
            )),
        )

        # Validate the universe domain.
        self._client._validate_universe_domain()

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Wrap the response in an operation future.
        response = operation_async.from_gapic(
            response,
            self._client._transport.operations_client,
            gcr_worker_pool.WorkerPool,
            metadata_type=gcr_worker_pool.WorkerPool,
        )

        # Done; return the response.
        return response

    async def delete_worker_pool(self,
            request: Optional[Union[worker_pool.DeleteWorkerPoolRequest, dict]] = None,
            *,
            name: Optional[str] = None,
            retry: OptionalRetry = gapic_v1.method.DEFAULT,
            timeout: Union[float, object] = gapic_v1.method.DEFAULT,
            metadata: Sequence[Tuple[str, str]] = (),
            ) -> operation_async.AsyncOperation:
        r"""Deletes a WorkerPool.

        .. code-block:: python

            # This snippet has been automatically generated and should be regarded as a
            # code template only.
            # It will require modifications to work:
            # - It may require correct/in-range values for request initialization.
            # - It may require specifying regional endpoints when creating the service
            #   client as shown in:
            #   https://googleapis.dev/python/google-api-core/latest/client_options.html
            from googlecloudsdk.generated_clients.gapic_clients import run_v2

            async def sample_delete_worker_pool():
                # Create a client
                client = run_v2.WorkerPoolsAsyncClient()

                # Initialize request argument(s)
                request = run_v2.DeleteWorkerPoolRequest(
                    name="name_value",
                )

                # Make the request
                operation = client.delete_worker_pool(request=request)

                print("Waiting for operation to complete...")

                response = (await operation).result()

                # Handle the response
                print(response)

        Args:
            request (Optional[Union[googlecloudsdk.generated_clients.gapic_clients.run_v2.types.DeleteWorkerPoolRequest, dict]]):
                The request object. Request message to delete a
                WorkerPool by its full name.
            name (:class:`str`):
                Required. The full name of the WorkerPool. Format:
                projects/{project}/locations/{location}/workerPools/{worker_pool},
                where {project} can be project id or number.

                This corresponds to the ``name`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry_async.AsyncRetry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.api_core.operation_async.AsyncOperation:
                An object representing a long-running operation.

                The result type for the operation will be :class:`googlecloudsdk.generated_clients.gapic_clients.run_v2.types.WorkerPool` WorkerPool acts as a top-level container that manages a set of
                   configurations and revision templates which implement
                   a pull-based workload. WorkerPool exists to provide a
                   singular abstraction which can be access controlled,
                   reasoned about, and which encapsulates software
                   lifecycle decisions such as rollout policy and team
                   resource ownership.

        """
        # Create or coerce a protobuf request object.
        # - Quick check: If we got a request object, we should *not* have
        #   gotten any keyword arguments that map to the request.
        has_flattened_params = any([name])
        if request is not None and has_flattened_params:
            raise ValueError("If the `request` argument is set, then none of "
                             "the individual field arguments should be set.")

        # - Use the request object if provided (there's no risk of modifying the input as
        #   there are no flattened fields), or create one.
        if not isinstance(request, worker_pool.DeleteWorkerPoolRequest):
            request = worker_pool.DeleteWorkerPoolRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if name is not None:
            request.name = name

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = self._client._transport._wrapped_methods[self._client._transport.delete_worker_pool]

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((
                ("name", request.name),
            )),
        )

        # Validate the universe domain.
        self._client._validate_universe_domain()

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Wrap the response in an operation future.
        response = operation_async.from_gapic(
            response,
            self._client._transport.operations_client,
            worker_pool.WorkerPool,
            metadata_type=worker_pool.WorkerPool,
        )

        # Done; return the response.
        return response

    async def __aenter__(self) -> "WorkerPoolsAsyncClient":
        return self

    async def __aexit__(self, exc_type, exc, tb):
        await self.transport.close()

DEFAULT_CLIENT_INFO = gapic_v1.client_info.ClientInfo(gapic_version=package_version.__version__)


__all__ = (
    "WorkerPoolsAsyncClient",
)
