/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ThinkPowerProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN_REQUEST = 1;
    public static final int MSG_LOGIN_RESPONSE = 2;
    public static final int MSG_HEARTBEAT_REQUEST = 3;
    public static final int MSG_HEARTBEAT_RESPONSE = 4;
    public static final int MSG_RECORD_REPORT = 5;
    public static final int MSG_RECORD_RESPONSE = 6;

    public ThinkPowerProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int type, int index, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(type);
            response.writeByte(index);
            if (content != null) {
                response.writeShort(content.readableBytes());
                response.writeBytes(content);
                content.release();
            } else {
                response.writeShort(0);
            }
            response.writeShort(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, response.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private void decodeValue(Position position, int type, ByteBuf buf) {
        switch (type) {
            case 1: {
                position.setValid(true);
                position.setLatitude((double)BufferUtil.readSignedMagnitudeInt(buf) * 1.0E-7);
                position.setLongitude((double)BufferUtil.readSignedMagnitudeInt(buf) * 1.0E-7);
                position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
                position.setCourse((double)buf.readUnsignedShort() * 0.01);
                break;
            }
            case 2: {
                position.setValid(buf.readUnsignedByte() > 0);
                break;
            }
            case 3: {
                buf.skipBytes(3);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                buf.skipBytes(2);
                break;
            }
            case 9: {
                buf.readUnsignedByte();
                break;
            }
            case 10: {
                buf.readUnsignedByte();
                break;
            }
            case 16: {
                if (buf.readUnsignedByte() <= 0) break;
                position.set("alarm", "sos");
                break;
            }
            case 18: {
                position.set("battery", (double)buf.readUnsignedShort() * 0.1);
                break;
            }
            case 19: {
                if (buf.readUnsignedByte() <= 0) break;
                position.set("alarm", "lowBattery");
                break;
            }
            case 22: {
                buf.readUnsignedShort();
                break;
            }
            case 23: {
                buf.readUnsignedByte();
                break;
            }
            case 24: {
                buf.readUnsignedShort();
                break;
            }
            case 25: {
                buf.readUnsignedByte();
                break;
            }
            case 80: {
                if (buf.readUnsignedByte() <= 0) break;
                position.set("alarm", "removing");
                break;
            }
            case 81: {
                if (buf.readUnsignedByte() <= 0) break;
                position.set("alarm", "tampering");
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short type = buf.readUnsignedByte();
        short index = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 1) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            String id = buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString();
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
            ByteBuf content = Unpooled.buffer();
            content.writeByte(deviceSession != null ? 0 : 4);
            this.sendResponse(channel, 2, index, content);
        } else if (type == 3) {
            this.sendResponse(channel, 4, index, null);
        } else if (type == 5) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            buf.readUnsignedByte();
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date(buf.readUnsignedInt() * 1000L));
            while (buf.readableBytes() > 2) {
                this.decodeValue(position, buf.readUnsignedByte(), buf);
            }
            this.sendResponse(channel, 6, index, null);
            return position;
        }
        return null;
    }
}

