/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class EasyTrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("..,").number("(d+),").expression("([^,]{2}),").expression("([AV]),").number("(xx)(xx)(xx),").number("(xx)(xx)(xx),").number("(x)(x{7}),").number("(x)(x{7}),").number("(x{4}),").number("(x{4}),").number("(x{8}),").number("(x+),").number("(d+),").number("(x+),").number("(x+)").groupBegin().number(",(x+)").groupBegin().number(",d+").number(",(d*)").number(",(x+)").number(",(d+.d+)").number(",(d+)").groupEnd("?").groupEnd("?").any().compile();
    private static final Pattern PATTERN_CELL = new PatternBuilder().text("*").expression("..,").number("(d+),").text("JZ,").number("([01]),").number("(d+),").number("(d+),").number("(d+),").number("(d+)").any().compile();
    private static final Pattern PATTERN_OBD = new PatternBuilder().text("*").expression("..,").number("(d+),").text("OB,").text("BD$").number("V(d+.d);").number("R(d+);").number("S(d+);").number("P(d+.d);").number("O(d+.d);").number("C(d+);").number("L(d+.d);").number("[XY][MH]d+.d+;").number("Md+.?d*;").number("F(d+.d+);").number("T(d+);").any().compile();

    public EasyTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(long status) {
        if ((status & 0x2000000L) != 0L) {
            return "geofenceEnter";
        }
        if ((status & 0x4000000L) != 0L) {
            return "geofenceExit";
        }
        if ((status & 0x8000000L) != 0L) {
            return "lowBattery";
        }
        if ((status & 0x20000000L) != 0L) {
            return "vibration";
        }
        if ((status & 0x80000000L) != 0L) {
            return "overspeed";
        }
        if ((status & 0x10000L) != 0L) {
            return "sos";
        }
        if ((status & 0x40000L) != 0L) {
            return "powerCut";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        String type = sentence.substring(20, 22);
        if (channel != null && (type.equals("TX") || type.equals("MQ"))) {
            channel.writeAndFlush((Object)new NetworkMessage(sentence + "#", remoteAddress));
        }
        if (type.equals("OB")) {
            return this.decodeObd(channel, remoteAddress, sentence);
        }
        if (type.equals("JZ")) {
            return this.decodeCell(channel, remoteAddress, sentence);
        }
        return this.decodeLocation(channel, remoteAddress, sentence);
    }

    private Position decodeLocation(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("command", parser.next());
        position.setValid(parser.next().equals("A"));
        DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextHexInt(), parser.nextHexInt(), parser.nextHexInt()).setTime(parser.nextHexInt(), parser.nextHexInt(), parser.nextHexInt());
        position.setTime(dateBuilder.getDate());
        if (BitUtil.check(parser.nextHexInt().intValue(), 3)) {
            position.setLatitude((double)(-parser.nextHexInt().intValue()) / 600000.0);
        } else {
            position.setLatitude((double)parser.nextHexInt().intValue() / 600000.0);
        }
        if (BitUtil.check(parser.nextHexInt().intValue(), 3)) {
            position.setLongitude((double)(-parser.nextHexInt().intValue()) / 600000.0);
        } else {
            position.setLongitude((double)parser.nextHexInt().intValue() / 600000.0);
        }
        position.setSpeed(UnitsConverter.knotsFromKph((double)parser.nextHexInt().intValue() / 100.0));
        double course = (double)parser.nextHexInt().intValue() * 0.01;
        if (course < 360.0) {
            position.setCourse(course);
        }
        long status = parser.nextHexLong();
        position.set("alarm", this.decodeAlarm(status));
        position.set("blocked", (status & 0x80000L) > 0L);
        position.set("ignition", (status & 0x800000L) > 0L);
        position.set("status", status);
        position.set("rssi", parser.nextHexInt());
        position.set("power", parser.nextDouble());
        position.set("fuel", parser.nextHexInt());
        position.set("odometer", parser.nextHexInt() * 100);
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext(4)) {
            position.set("driverUniqueId", parser.next());
            position.set("temp1", (double)parser.nextHexInt().intValue() * 0.01);
            position.set("adc1", parser.nextDouble());
            position.set("sat", parser.nextInt());
        }
        return position;
    }

    private Position decodeCell(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_CELL, sentence);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        if (channel != null && parser.nextInt() > 0) {
            String response = String.format("*ET,%s,JZ,undefined#", imei);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        int cid = parser.nextInt();
        int lac = parser.nextInt();
        int mcc = parser.nextInt();
        int mnc = parser.nextInt();
        position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid)));
        return position;
    }

    private Position decodeObd(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_OBD, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("battery", parser.nextDouble());
        position.set("rpm", parser.nextInt());
        position.set("obdSpeed", parser.nextInt());
        position.set("throttle", parser.nextDouble());
        position.set("engineLoad", parser.nextDouble());
        position.set("coolantTemp", parser.nextInt());
        position.set("fuel", parser.nextDouble());
        position.set("fuelConsumption", parser.nextDouble());
        position.set("hours", parser.nextInt());
        return position;
    }
}

