/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class CarcellProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("([$%])").number("(d+),").groupBegin().number("([NS])(dd)(dd).(dddd),").number("([EW])(ddd)(dd).(dddd),").or().text("CEL,").number("([NS])(d+.d+),").number("([EW])(d+.d+),").groupEnd().number("(d+),").number("(d+),").groupBegin().number("([-+]ddd)([-+]ddd)([-+]ddd),").or().number("(d+),").groupEnd().number("(d+),").number("(d+),").number("(d),").number("(d+),").expression("([CG]),?").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d),").number("(d),").groupBegin().number("(d),").expression("([AF])").number("(d),").number("(d+),").or().number("(dd),").expression("([AF])").number("(d),").number("(d{2,4}),").number("(d{20}),").groupEnd().number("(xx)").any().compile();

    public CarcellProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.set("archive", parser.next().equals("%"));
        position.setValid(true);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext(8)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_MIN));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_MIN));
        }
        if (parser.hasNext(4)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        }
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
        position.setCourse(parser.nextInt(0));
        if (parser.hasNext(3)) {
            position.set("x", parser.nextInt(0));
            position.set("y", parser.nextInt(0));
            position.set("z", parser.nextInt(0));
        }
        if (parser.hasNext(1)) {
            position.set("acceleration", parser.nextInt(0));
        }
        Double internalBattery = (parser.nextDouble(0.0) + 100.0) * 0.0294;
        position.set("battery", internalBattery);
        position.set("rssi", parser.nextInt(0));
        position.set("jamming", parser.next().equals("1"));
        position.set("gps", parser.nextInt(0));
        position.set("clockType", parser.next());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.set("blocked", parser.next().equals("1"));
        position.set("ignition", parser.next().equals("1"));
        if (parser.hasNext(4)) {
            position.set("cloned", parser.next().equals("1"));
            parser.next();
            String painelStatus = parser.next();
            if (painelStatus.equals("1")) {
                position.set("alarm", "general");
            }
            position.set("painel", painelStatus.equals("2"));
            Double mainVoltage = parser.nextDouble(0.0) / 100.0;
            position.set("power", mainVoltage);
        }
        if (parser.hasNext(5)) {
            position.set("timeUntilDelivery", parser.nextInt(0));
            parser.next();
            position.set("input", parser.next());
            Double mainVoltage = parser.nextDouble(0.0) / 100.0;
            position.set("power", mainVoltage);
            position.set("iccid", parser.next());
        }
        return position;
    }
}

