/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VolumeAttributeDescription;
import com.amazon.aes.webservices.client.VolumeAttributeType;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DescribeVolumeAttribute
extends BaseCmd {
    private static final String[] AUTO_ENABLE_DESC = new String[]{"Retrieves whether IO will be automatically enabled in the case of a volume event.", "Valid options are 'true' and 'false'."};
    private static final String PRODUCT_CODE_DESC = "Describe the product code associated with the specified VOLUME.";
    private String volumeId;
    private VolumeAttributeType type;

    public DescribeVolumeAttribute(String[] args) {
        super("ec2dvolatt", "ec2-describe-volume-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(DescribeVolumeAttribute.createOption("a", "auto-enable-io", AUTO_ENABLE_DESC));
        result.addOption(DescribeVolumeAttribute.createOption("p", "product-code", PRODUCT_CODE_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "VOLUME";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("auto-enable-io");
        this.printOption("product-code");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes a volume attribute. Only one attribute can be specified");
        System.out.println("     per call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.describeVolumeAttribute(this.volumeId, this.type);
        out.printRequestId(System.out, (RequestResult)rsp);
        out.output(System.out, (VolumeAttributeDescription)rsp.getResponse());
        return true;
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VOLUME");
        this.volumeId = this.getNonOptions()[0];
        this.assertOnlyOneOptionSet(new String[]{"auto-enable-io", "product-code"});
        this.warnIfTooManyNonOptions();
        if (this.isOptionSet("auto-enable-io")) {
            this.type = VolumeAttributeType.autoEnableIO;
        } else if (this.isOptionSet("product-code")) {
            this.type = VolumeAttributeType.productCodes;
        }
    }

    public static void main(String[] args) {
        new DescribeVolumeAttribute(args).invoke();
    }
}

