/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ResValuesFile {
    private final ResPackage mPackage;
    private final ResTypeSpec mType;
    private final ResType mConfig;
    private final Set<ResResource> mResources = new LinkedHashSet<ResResource>();

    public ResValuesFile(ResPackage pkg, ResTypeSpec type, ResType config) {
        this.mPackage = pkg;
        this.mType = type;
        this.mConfig = config;
    }

    public String getPath() {
        return "values" + this.mConfig.getFlags().getQualifiers() + "/" + this.mType.getName() + (this.mType.getName().endsWith("s") ? "" : "s") + ".xml";
    }

    public Set<ResResource> listResources() {
        return this.mResources;
    }

    public boolean isSynthesized(ResResource res) {
        return this.mPackage.isSynthesized(res.getResSpec().getId());
    }

    public void addResource(ResResource res) {
        this.mResources.add(res);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResValuesFile other = (ResValuesFile)obj;
        if (!Objects.equals(this.mType, other.mType)) {
            return false;
        }
        return Objects.equals(this.mConfig, other.mConfig);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.mType != null ? this.mType.hashCode() : 0);
        hash = 31 * hash + (this.mConfig != null ? this.mConfig.hashCode() : 0);
        return hash;
    }
}

