/**
The [`Intl.RelativeTimeFormat`](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat)
object is a constructor for objects that enable language-sensitive relative time formatting.

[Compatibility](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/RelativeTimeFormat#Browser_compatibility).

@returns {Intl.RelativeTimeFormat}
*/
Intl.RelativeTimeFormat = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.es2020.intl.d.ts
/**
Formats a value and a unit according to the locale
and formatting options of the given
[`Intl.RelativeTimeFormat`](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat)
object.

While this method automatically provides the correct plural forms,
the grammatical form is otherwise as neutral as possible.

It is the caller's responsibility to handle cut-off logic
such as deciding between displaying "in 7 days" or "in 1 week".
This API does not support relative dates involving compound units.
e.g "in 5 days and 4 hours".

@param {Number} value -  Numeric value to use in the internationalized relative time message
@param {("year" | "years" | "quarter" | "quarters" | "month" | "months" | "week" | "weeks" | "day" | "days" | "hour" | "hours" | "minute" | "minutes" | "second" | "seconds")} unit RelativeTimeFormatUnit - - [Unit](https://tc39.es/ecma402/#sec-singularrelativetimeunit) to use in the relative time internationalized message.
@returns {String}
**/
Intl.RelativeTimeFormat.prototype.format = function(value, unit) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.es2020.intl.d.ts
/**
Returns an array of objects representing the relative time format in parts that can be used for custom locale-aware formatting.

@param {Number} value - Numeric value to use in the internationalized relative time message
@param {("year" | "years" | "quarter" | "quarters" | "month" | "months" | "week" | "weeks" | "day" | "days" | "hour" | "hours" | "minute" | "minutes" | "second" | "seconds")} unit RelativeTimeFormatUnit - - [Unit](https://tc39.es/ecma402/#sec-singularrelativetimeunit) to use in the relative time internationalized message.
@returns {RelativeTimeFormatPart[]}
**/
Intl.RelativeTimeFormat.prototype.formatToParts = function(value, unit) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.es2020.intl.d.ts
/**
Provides access to the locale and options computed during initialization of this `Intl.RelativeTimeFormat` object.

[MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/RelativeTimeFormat/resolvedOptions).

@returns {ResolvedRelativeTimeFormatOptions}
**/
Intl.RelativeTimeFormat.prototype.resolvedOptions = function() {};

