/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.runtime.AbstractOptimizedLoopNode;
import com.oracle.truffle.runtime.BaseOSRRootNode;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedLoopNode;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTVMCI;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.options.OptionValues;

public abstract class OptimizedOSRLoopNode
extends AbstractOptimizedLoopNode
implements ReplaceObserver {
    private volatile OptimizedCallTarget compiledOSRLoop;
    private volatile SpeculationLog speculationLog;
    private int baseLoopCount;
    private final int osrThreshold;
    private final boolean firstTierBackedgeCounts;
    private volatile boolean compilationDisabled;

    private OptimizedOSRLoopNode(RepeatingNode repeatingNode, int osrThreshold, boolean firstTierBackedgeCounts) {
        super(repeatingNode);
        this.osrThreshold = osrThreshold;
        this.firstTierBackedgeCounts = firstTierBackedgeCounts;
    }

    protected AbstractLoopOSRRootNode createRootNode(FrameDescriptor rootFrameDescriptor, Class<? extends VirtualFrame> clazz) {
        return new LoopOSRRootNode(this, new FrameDescriptor(), clazz);
    }

    public final Node copy() {
        OptimizedOSRLoopNode copy = (OptimizedOSRLoopNode)super.copy();
        copy.compiledOSRLoop = null;
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        Object status;
        RepeatingNode loopBody = this.repeatingNode;
        if (CompilerDirectives.inInterpreter()) {
            try {
                Object status2 = loopBody.initialLoopStatus();
                while (loopBody.shouldContinue(status2)) {
                    if (this.compiledOSRLoop == null) {
                        status2 = this.profilingLoop(frame);
                        continue;
                    }
                    status2 = this.compilingLoop(frame);
                }
                Object object = status2;
                return object;
            }
            finally {
                this.baseLoopCount = 0;
            }
        }
        if (CompilerDirectives.hasNextTier()) {
            Object status3;
            long iterationsCompleted = 0L;
            try {
                while (this.inject(loopBody.shouldContinue(status3 = loopBody.executeRepeatingWithValue(frame)))) {
                    ++iterationsCompleted;
                    if (CompilerDirectives.inInterpreter()) {
                        Object object = this.execute(frame);
                        return object;
                    }
                    TruffleSafepoint.poll((Node)this);
                }
            }
            finally {
                if (this.firstTierBackedgeCounts && iterationsCompleted > 1L) {
                    LoopNode.reportLoopCount((Node)this, (int)OptimizedOSRLoopNode.toIntOrMaxInt(iterationsCompleted));
                }
            }
            return status3;
        }
        while (this.inject(loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(frame)))) {
            if (CompilerDirectives.inInterpreter()) {
                return this.execute(frame);
            }
            TruffleSafepoint.poll((Node)this);
        }
        return status;
    }

    static int toIntOrMaxInt(long i) {
        return i > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object profilingLoop(VirtualFrame frame) {
        RepeatingNode loopBody = this.repeatingNode;
        long iterations = 0L;
        try {
            Object status;
            while (loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(frame))) {
                if (++iterations + (long)this.baseLoopCount > (long)this.osrThreshold && !this.compilationDisabled) {
                    this.compileLoop(frame);
                    Object object = status;
                    return object;
                }
                TruffleSafepoint.poll((Node)this);
            }
            Object object = status;
            return object;
        }
        finally {
            this.reportLoopIterations(iterations);
        }
    }

    private void reportLoopIterations(long iterations) {
        this.baseLoopCount = OptimizedOSRLoopNode.toIntOrMaxInt((long)this.baseLoopCount + iterations);
        this.profileCounted(iterations);
        LoopNode.reportLoopCount((Node)this, (int)OptimizedOSRLoopNode.toIntOrMaxInt(iterations));
    }

    final void reportChildLoopCount(int iterations) {
        int newBaseLoopCount = this.baseLoopCount + iterations;
        if (newBaseLoopCount < 0) {
            newBaseLoopCount = Integer.MAX_VALUE;
        }
        this.baseLoopCount = newBaseLoopCount;
    }

    public final void forceOSR() {
        this.baseLoopCount = this.osrThreshold;
        RootNode rootNode = this.getRootNode();
        VirtualFrame dummyFrame = Truffle.getRuntime().createVirtualFrame(new Object[]{}, rootNode != null ? rootNode.getFrameDescriptor() : new FrameDescriptor());
        this.compileLoop(dummyFrame);
    }

    public final OptimizedCallTarget getCompiledOSRLoop() {
        return this.compiledOSRLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compilingLoop(VirtualFrame frame) {
        RepeatingNode loopBody = this.repeatingNode;
        long iterations = 0L;
        try {
            Object status;
            do {
                OptimizedCallTarget target;
                if ((target = this.compiledOSRLoop) == null) {
                    Object object = loopBody.initialLoopStatus();
                    return object;
                }
                if (!target.isSubmittedForCompilation()) {
                    if (target.isValid()) {
                        Object object = this.callOSR(target, frame);
                        return object;
                    }
                    this.invalidateOSRTarget("OSR compilation failed or cancelled");
                    Object object = loopBody.initialLoopStatus();
                    return object;
                }
                ++iterations;
                TruffleSafepoint.poll((Node)this);
            } while (loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(frame)));
            Object object = status;
            return object;
        }
        finally {
            this.reportLoopIterations(iterations);
        }
    }

    private Object callOSR(OptimizedCallTarget target, VirtualFrame frame) {
        Object status = target.callOSR(frame);
        if (!this.repeatingNode.initialLoopStatus().equals(status)) {
            return status;
        }
        if (!target.isValid()) {
            this.invalidateOSRTarget("OSR compilation got invalidated");
        }
        return status;
    }

    private void compileLoop(final VirtualFrame frame) {
        this.atomic(new Runnable(){
            final /* synthetic */ OptimizedOSRLoopNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.compilationDisabled) {
                    return;
                }
                if (this.this$0.compiledOSRLoop == null) {
                    this.this$0.compiledOSRLoop = this.this$0.compileImpl(frame);
                }
            }
        });
    }

    private AbstractLoopOSRRootNode createRootNodeImpl(RootNode root, Class<? extends VirtualFrame> frameClass) {
        return this.createRootNode(root == null ? null : root.getFrameDescriptor(), frameClass);
    }

    private OptimizedCallTarget compileImpl(VirtualFrame frame) {
        OptimizedCallTarget osrTarget;
        RootNode root = this.getRootNode();
        if (this.speculationLog == null) {
            this.speculationLog = OptimizedTruffleRuntime.getRuntime().createSpeculationLog();
        }
        if (!(osrTarget = (OptimizedCallTarget)this.createRootNodeImpl(root, frame.getClass()).getCallTarget()).acceptForCompilation()) {
            this.compilationDisabled = true;
            return null;
        }
        osrTarget.setSpeculationLog(this.speculationLog);
        osrTarget.compile(true);
        return osrTarget;
    }

    public final boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        this.callNodeReplacedOnOSRTarget(oldNode, newNode, reason);
        return false;
    }

    private void callNodeReplacedOnOSRTarget(final Node oldNode, final Node newNode, final CharSequence reason) {
        this.atomic(new Runnable(){
            final /* synthetic */ OptimizedOSRLoopNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                OptimizedCallTarget target = this.this$0.compiledOSRLoop;
                if (target != null) {
                    this.this$0.resetCompiledOSRLoop();
                    target.nodeReplaced(oldNode, newNode, reason);
                }
            }
        });
    }

    private void resetCompiledOSRLoop() {
        OptimizedCallTarget target = this.compiledOSRLoop;
        if (target != null && target.isCompilationFailed()) {
            this.compilationDisabled = true;
        }
        this.compiledOSRLoop = null;
    }

    private void invalidateOSRTarget(final CharSequence reason) {
        this.atomic(new Runnable(){
            final /* synthetic */ OptimizedOSRLoopNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                OptimizedCallTarget target = this.this$0.compiledOSRLoop;
                if (target != null) {
                    this.this$0.resetCompiledOSRLoop();
                    target.invalidate(reason);
                }
            }
        });
    }

    public static LoopNode create(RepeatingNode repeat) {
        EngineData engine = OptimizedTVMCI.getEngineData(null);
        OptionValues engineOptions = engine.engineOptions;
        if (engine.compilation && ((Boolean)engineOptions.get(OptimizedRuntimeOptions.OSR)).booleanValue()) {
            return OptimizedOSRLoopNode.createDefault(repeat, engineOptions);
        }
        return OptimizedLoopNode.create(repeat);
    }

    private static LoopNode createDefault(RepeatingNode repeatableNode, OptionValues options) {
        return new OptimizedDefaultOSRLoopNode(repeatableNode, (Integer)options.get(OptimizedRuntimeOptions.OSRCompilationThreshold), (Boolean)options.get(OptimizedRuntimeOptions.FirstTierBackedgeCounts));
    }

    static final class LoopOSRRootNode
    extends AbstractLoopOSRRootNode {
        LoopOSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(loop, frameDescriptor, clazz);
        }
    }

    static abstract class AbstractLoopOSRRootNode
    extends BaseOSRRootNode {
        protected final Class<? extends VirtualFrame> clazz;

        AbstractLoopOSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(null, frameDescriptor, (NodeInterface)loop);
            this.clazz = clazz;
        }

        public SourceSection getSourceSection() {
            return this.getLoopNode().getSourceSection();
        }

        OptimizedOSRLoopNode getLoopNode() {
            return (OptimizedOSRLoopNode)this.loopNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object executeOSR(VirtualFrame frame) {
            Object status;
            VirtualFrame parentFrame = this.clazz.cast(frame.getArguments()[0]);
            OptimizedOSRLoopNode loop = this.getLoopNode();
            RepeatingNode loopBody = loop.repeatingNode;
            long iterationsCompleted = 0L;
            try {
                while (loop.inject(loopBody.shouldContinue(status = loopBody.executeRepeatingWithValue(parentFrame)))) {
                    if (CompilerDirectives.hasNextTier()) {
                        ++iterationsCompleted;
                    }
                    if (CompilerDirectives.inInterpreter()) {
                        Object object = loopBody.initialLoopStatus();
                        return object;
                    }
                    TruffleSafepoint.poll((Node)loop);
                }
            }
            finally {
                if (loop.firstTierBackedgeCounts && iterationsCompleted > 1L) {
                    LoopNode.reportLoopCount((Node)this, (int)OptimizedOSRLoopNode.toIntOrMaxInt(iterationsCompleted));
                }
            }
            return status;
        }

        public final boolean isCloningAllowed() {
            return false;
        }

        public final String toString() {
            return this.getLoopNode().getRepeatingNode().toString() + "<OSR>";
        }
    }

    private static final class OptimizedDefaultOSRLoopNode
    extends OptimizedOSRLoopNode {
        OptimizedDefaultOSRLoopNode(RepeatingNode repeatableNode, int osrThreshold, boolean firstTierBackedgeCounts) {
            super(repeatableNode, osrThreshold, firstTierBackedgeCounts);
        }
    }
}

