/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIamWorkRequestRequest
extends BmcRequest<Void> {
    private String iamWorkRequestId;
    private String opcRequestId;

    public String getIamWorkRequestId() {
        return this.iamWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().iamWorkRequestId(this.iamWorkRequestId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",iamWorkRequestId=").append(String.valueOf(this.iamWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIamWorkRequestRequest)) {
            return false;
        }
        GetIamWorkRequestRequest other = (GetIamWorkRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.iamWorkRequestId, other.iamWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.iamWorkRequestId == null ? 43 : this.iamWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIamWorkRequestRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String iamWorkRequestId = null;
        private String opcRequestId = null;

        public Builder iamWorkRequestId(String iamWorkRequestId) {
            this.iamWorkRequestId = iamWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIamWorkRequestRequest o) {
            this.iamWorkRequestId(o.getIamWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIamWorkRequestRequest build() {
            GetIamWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIamWorkRequestRequest buildWithoutInvocationCallback() {
            GetIamWorkRequestRequest request = new GetIamWorkRequestRequest();
            request.iamWorkRequestId = this.iamWorkRequestId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

