/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterMappingsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterParamsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FiltersMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.InitParamTableModel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FilterPanel
extends SectionInnerPanel {
    private DDDataObject dObj;
    private Filter filter;
    private JButton linkButton;
    private FilterParamsPanel filterParamsPanel;
    private FilterMappingsTablePanel filterMappingsPanel;
    private JButton browseButton;
    private JLabel descriptionLabel;
    private JTextArea descriptionTA;
    private JPanel filler;
    private JLabel filterClassLabel;
    private JTextField filterClassTF;
    private JLabel filterNameLabel;
    private JTextField filterNameTF;
    private JLabel filterParamsLabel;

    public FilterPanel(SectionView sectionView, DDDataObject dObj, Filter filter) {
        super(sectionView);
        this.dObj = dObj;
        this.filter = filter;
        this.initComponents();
        this.filterNameTF.setText(filter.getFilterName());
        this.addValidatee(this.filterNameTF);
        Utils.makeTextAreaLikeTextField((JTextArea)this.descriptionTA, (JTextField)this.filterNameTF);
        this.descriptionTA.setText(filter.getDefaultDescription());
        this.addModifier(this.descriptionTA);
        InitParamTableModel model = new InitParamTableModel();
        this.filterParamsPanel = new FilterParamsPanel(dObj, model);
        this.filterParamsPanel.setModel(filter, filter.getInitParam());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add((Component)((Object)this.filterParamsPanel), gridBagConstraints);
        this.filterClassTF.setText(filter.getFilterClass());
        this.addValidatee(this.filterClassTF);
        this.linkButton = new LinkButton((LinkCookie)this, (Object)filter, "ClassName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        Mnemonics.setLocalizedText((AbstractButton)this.linkButton, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_goToSource"));
        this.add(this.linkButton, gridBagConstraints);
        this.setAccessibility();
    }

    private void setAccessibility() {
        this.filterParamsLabel.setLabelFor(this.filterParamsPanel.getTable());
    }

    public void linkButtonPressed(Object ddBean, String property) {
        if ("ClassName".equals(property)) {
            DDUtils.openEditorFor(this.dObj, ((Filter)ddBean).getFilterClass());
        }
    }

    private void initComponents() {
        this.filterNameLabel = new JLabel();
        this.filterNameTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTA = new JTextArea();
        this.filterClassLabel = new JLabel();
        this.filterClassTF = new JTextField();
        this.browseButton = new JButton();
        this.filler = new JPanel();
        this.filterParamsLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.filterNameLabel.setLabelFor(this.filterNameTF);
        Mnemonics.setLocalizedText((JLabel)this.filterNameLabel, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_filterName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.filterNameLabel, gridBagConstraints);
        this.filterNameTF.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.filterNameTF, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTA);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.descriptionTA.setRows(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.descriptionTA, gridBagConstraints);
        this.filterClassLabel.setLabelFor(this.filterClassTF);
        Mnemonics.setLocalizedText((JLabel)this.filterClassLabel, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_filterClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.filterClassLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.filterClassTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_browse"));
        this.browseButton.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.add(this.browseButton, gridBagConstraints);
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.filterParamsLabel, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_initParams"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add(this.filterParamsLabel, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        try {
            String className;
            SourceGroup[] groups = DDUtils.getJavaSourceGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && (className = DDUtils.getResourcePath(groups, fo)).length() > 0 && !className.equals(this.filterClassTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.dObj.setChangedFromUI(true);
                this.filterClassTF.setText(className);
                this.filter.setFilterClass(className);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JComponent getErrorComponent(String name) {
        if ("FilterName".equals(name)) {
            return this.filterNameTF;
        }
        if ("FilterClass".equals(name)) {
            return this.filterClassTF;
        }
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
        if (comp == this.filterNameTF) {
            String val = value;
            if (val.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Filter Name", (JComponent)this.filterNameTF));
                return;
            }
            Filter[] filters = this.dObj.getWebApp().getFilter();
            for (int i = 0; i < filters.length; ++i) {
                if (this.filter == filters[i] || !val.equals(filters[i].getFilterName())) continue;
                this.getSectionView().getErrorPanel().setError(new Error(0, 3, val, (JComponent)this.filterNameTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (comp == this.filterClassTF) {
            String text = value;
            if (text.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Filter Class", (JComponent)this.filterClassTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    public void setValue(JComponent source, Object value) {
        if (source == this.filterNameTF) {
            String text = (String)value;
            FilterMapping[] maps = DDUtils.getFilterMappings(this.dObj.getWebApp(), this.filter);
            for (int i = 0; i < maps.length; ++i) {
                maps[i].setFilterName(text);
            }
            this.filter.setFilterName(text);
            SectionPanel enclosingPanel = this.getSectionView().findSectionPanel((Object)this.filter);
            enclosingPanel.setTitle(((FiltersMultiViewElement.FiltersView)this.getSectionView()).getFilterTitle(this.filter));
            enclosingPanel.getNode().setDisplayName(text);
        } else if (source == this.filterClassTF) {
            String text = (String)value;
            this.filter.setFilterClass(text.length() == 0 ? null : text);
        } else if (source == this.descriptionTA) {
            String text = (String)value;
            this.filter.setDescription(text.length() == 0 ? null : text);
        }
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.filterNameTF) {
            this.filterNameTF.setText(this.filter.getFilterName());
        } else if (source == this.filterClassTF) {
            this.filterClassTF.setText(this.filter.getFilterClass());
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }
}

