/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.elements.common.MethodElement;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.completion.provider.CompletionAccessor;
import org.netbeans.modules.groovy.editor.completion.provider.GroovyElementsProvider;
import org.netbeans.modules.groovy.editor.java.JavaElementHandle;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.groovy.editor.utils.GroovyUtils;
import org.openide.filesystems.FileObject;

public final class JavaElementHandler {
    private static final Logger LOG = Logger.getLogger(GroovyElementsProvider.class.getName());
    private final ParserResult info;
    private final CompletionContext context;

    private JavaElementHandler(ParserResult info, CompletionContext context) {
        this.info = info;
        this.context = context;
    }

    public static JavaElementHandler forCompilationInfo(ParserResult info, CompletionContext context) {
        return new JavaElementHandler(info, context);
    }

    public Map<MethodSignature, CompletionItem> getMethods(String className, String prefix, int anchor, String[] typeParameters, boolean emphasise, Set<AccessLevel> levels, boolean nameOnly) {
        JavaSource javaSource = this.createJavaSource();
        if (javaSource == null) {
            return Collections.emptyMap();
        }
        FileObject f = this.info.getSnapshot().getSource().getFileObject();
        CountDownLatch cnt = new CountDownLatch(1);
        Map<MethodSignature, CompletionItem> result = Collections.synchronizedMap(new HashMap());
        try {
            javaSource.runUserActionTask((Task)new MethodCompletionHelper(cnt, javaSource, f, className, typeParameters, levels, prefix, anchor, result, emphasise, nameOnly, this.context.isStaticMembers()), true);
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Problem in runUserActionTask :  {0}", ex.getMessage());
            return Collections.emptyMap();
        }
        try {
            cnt.await();
        }
        catch (InterruptedException ex) {
            LOG.log(Level.FINEST, "InterruptedException while waiting on latch :  {0}", ex.getMessage());
            return Collections.emptyMap();
        }
        return result;
    }

    public Map<FieldSignature, CompletionItem> getFields(String className, String prefix, int anchor, boolean emphasise) {
        JavaSource javaSource = this.createJavaSource();
        if (javaSource == null) {
            return Collections.emptyMap();
        }
        CountDownLatch cnt = new CountDownLatch(1);
        Map<FieldSignature, CompletionItem> result = Collections.synchronizedMap(new HashMap());
        FileObject f = this.info.getSnapshot().getSource().getFileObject();
        try {
            javaSource.runUserActionTask((Task)new FieldCompletionHelper(cnt, javaSource, f, className, Collections.singleton(AccessLevel.PUBLIC), prefix, anchor, result, emphasise, this.context.isStaticMembers()), true);
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Problem in runUserActionTask :  {0}", ex.getMessage());
            return Collections.emptyMap();
        }
        try {
            cnt.await();
        }
        catch (InterruptedException ex) {
            LOG.log(Level.FINEST, "InterruptedException while waiting on latch :  {0}", ex.getMessage());
            return Collections.emptyMap();
        }
        return result;
    }

    private JavaSource createJavaSource() {
        FileObject fileObject = this.info.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)fileObject), (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    private static class MethodCompletionHelper
    implements Task<CompilationController> {
        private final CountDownLatch cnt;
        private final JavaSource javaSource;
        private final FileObject groovySource;
        private final String className;
        private final String[] typeParameters;
        private final Set<AccessLevel> levels;
        private final String prefix;
        private final int anchor;
        private final boolean emphasise;
        private final Map<MethodSignature, CompletionItem> proposals;
        private final boolean nameOnly;
        private final boolean staticMethods;

        public MethodCompletionHelper(CountDownLatch cnt, JavaSource javaSource, FileObject groovySource, String className, String[] typeParameters, Set<AccessLevel> levels, String prefix, int anchor, Map<MethodSignature, CompletionItem> proposals, boolean emphasise, boolean nameOnly, boolean staticMethods) {
            this.cnt = cnt;
            this.javaSource = javaSource;
            this.groovySource = groovySource;
            this.className = className;
            this.typeParameters = typeParameters;
            this.levels = levels;
            this.prefix = prefix;
            this.anchor = anchor;
            this.proposals = proposals;
            this.emphasise = emphasise;
            this.nameOnly = nameOnly;
            this.staticMethods = staticMethods;
        }

        public void run(CompilationController info) throws Exception {
            Elements elements = info.getElements();
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror type) {
                    if (staticMethods && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                        return false;
                    }
                    if (e.getKind() != ElementKind.METHOD) {
                        return false;
                    }
                    for (AccessLevel level : levels) {
                        if (!level.getJavaAcceptor().accept(e, type)) continue;
                        return true;
                    }
                    return false;
                }
            };
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement te = elements.getTypeElement(this.className);
            if (te != null) {
                for (ExecutableElement element : ElementFilter.methodsIn(te.getEnclosedElements())) {
                    if (!acceptor.accept((Element)element, te.asType())) continue;
                    String simpleName = element.getSimpleName().toString();
                    TypeMirror returnType = element.getReturnType();
                    String returnTypeString = info.getTypeUtilities().getTypeName(returnType, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString();
                    if (!simpleName.toUpperCase(Locale.ENGLISH).startsWith(this.prefix.toUpperCase(Locale.ENGLISH)) || simpleName.contains("$")) continue;
                    JavaElementHandle h = new JavaElementHandle(simpleName, this.className, ElementHandle.create((Element)element), this.signatureOf(te, element, info.getTypes()), Utilities.modelModifiersToGsf(element.getModifiers()));
                    CompletionItem ci = CompletionAccessor.instance().createJavaMethod(this.className, simpleName, this.getParametersForElement(info, te, element), returnTypeString, element.getModifiers(), this.anchor, this.emphasise, this.nameOnly);
                    this.proposals.put(this.getSignature(te, element, info.getTypes()), CompletionAccessor.instance().assignHandle(ci, h));
                }
            }
            this.cnt.countDown();
        }

        private List<String> signatureOf(TypeElement classElement, ExecutableElement exe, Types types) {
            MethodSignature sign = this.getSignature(classElement, exe, types);
            return Arrays.asList(sign.getParameters());
        }

        private List<MethodElement.MethodParameter> getParametersForElement(CompilationController info, TypeElement classElement, ExecutableElement exe) {
            ArrayList<MethodElement.MethodParameter> result = new ArrayList<MethodElement.MethodParameter>();
            if (exe == null) {
                return result;
            }
            List<? extends VariableElement> params = exe.getParameters();
            for (VariableElement variableElement : params) {
                String typeName;
                String fullName;
                TypeMirror tm = variableElement.asType();
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    fullName = this.substituteActualType(tm, classElement, exe, info.getTypes());
                    typeName = GroovyUtils.stripPackage(fullName);
                } else if (tm.getKind() == TypeKind.ARRAY && variableElement == params.get(params.size() - 1) && exe.isVarArgs()) {
                    tm = ((ArrayType)tm).getComponentType();
                    fullName = info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString() + "...";
                    typeName = info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]).toString() + "...";
                } else {
                    fullName = info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString();
                    typeName = info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]).toString();
                }
                result.add(new MethodElement.MethodParameter(fullName, typeName, variableElement.getSimpleName().toString()));
            }
            return result;
        }

        private String substituteActualType(TypeMirror type, TypeElement classElement, ExecutableElement element, Types types) {
            String typeString;
            List<? extends TypeParameterElement> declaredTypeParameters = element.getTypeParameters();
            if (declaredTypeParameters.isEmpty()) {
                declaredTypeParameters = classElement.getTypeParameters();
            }
            int j = -1;
            for (TypeParameterElement typeParameterElement : declaredTypeParameters) {
                ++j;
                if (!typeParameterElement.getSimpleName().toString().equals(type.toString())) continue;
                break;
            }
            if (j >= 0 && j < this.typeParameters.length) {
                typeString = this.typeParameters[j];
                if ("java.lang.Object".equals(typeString)) {
                    typeString = type.toString();
                }
            } else {
                typeString = type.toString();
            }
            return typeString;
        }

        private MethodSignature getSignature(TypeElement classElement, ExecutableElement element, Types types) {
            String name = element.getSimpleName().toString();
            String[] parameters = new String[element.getParameters().size()];
            for (int i = 0; i < parameters.length; ++i) {
                VariableElement var = element.getParameters().get(i);
                TypeMirror type = var.asType();
                String typeString = null;
                typeString = type.getKind() == TypeKind.TYPEVAR ? this.substituteActualType(type, classElement, element, types) : type.toString();
                int index = typeString.indexOf(60);
                if (index >= 0) {
                    typeString = typeString.substring(0, index);
                }
                parameters[i] = typeString;
            }
            return new MethodSignature(name, parameters);
        }
    }

    private static class FieldCompletionHelper
    implements Task<CompilationController> {
        private final CountDownLatch cnt;
        private final JavaSource javaSource;
        private final String className;
        private final Set<AccessLevel> levels;
        private final String prefix;
        private final int anchor;
        private final boolean emphasise;
        private final Map<FieldSignature, CompletionItem> proposals;
        private final FileObject groovySource;
        private final boolean staticMembers;

        public FieldCompletionHelper(CountDownLatch cnt, JavaSource javaSource, FileObject groovySource, String className, Set<AccessLevel> levels, String prefix, int anchor, Map<FieldSignature, CompletionItem> proposals, boolean emphasise, boolean staticMembers) {
            this.cnt = cnt;
            this.javaSource = javaSource;
            this.groovySource = groovySource;
            this.className = className;
            this.levels = levels;
            this.prefix = prefix;
            this.anchor = anchor;
            this.proposals = proposals;
            this.emphasise = emphasise;
            this.staticMembers = staticMembers;
        }

        public void run(CompilationController info) throws Exception {
            Elements elements = info.getElements();
            if (elements != null) {
                info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        if (!e.getKind().isField()) {
                            return false;
                        }
                        if (staticMembers && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                            return false;
                        }
                        for (AccessLevel level : levels) {
                            if (!level.getJavaAcceptor().accept(e, type)) continue;
                            return true;
                        }
                        return false;
                    }
                };
                info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement te = elements.getTypeElement(this.className);
                if (te != null) {
                    for (VariableElement element : ElementFilter.fieldsIn(te.getEnclosedElements())) {
                        if (!acceptor.accept((Element)element, te.asType())) continue;
                        String simpleName = element.getSimpleName().toString();
                        TypeMirror type = element.asType();
                        if (!simpleName.toUpperCase(Locale.ENGLISH).startsWith(this.prefix.toUpperCase(Locale.ENGLISH))) continue;
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, simpleName + " " + type.toString());
                        }
                        JavaElementHandle jh = new JavaElementHandle(simpleName, this.className, ElementHandle.create((Element)element), null, Utilities.modelModifiersToGsf(element.getModifiers()));
                        CompletionItem.JavaFieldItem ci = new CompletionItem.JavaFieldItem(this.className, simpleName, type, element.getModifiers(), this.anchor, this.emphasise);
                        this.proposals.put(this.getSignature(te, element), CompletionAccessor.instance().assignHandle(ci, jh));
                    }
                }
            }
            this.cnt.countDown();
        }

        private FieldSignature getSignature(TypeElement classElement, VariableElement element) {
            String name = element.getSimpleName().toString();
            return new FieldSignature(name);
        }
    }
}

