/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.elements.common.MethodElement;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedClass;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedElement;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedField;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedMethod;
import org.netbeans.modules.groovy.editor.utils.GroovyUtils;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public final class GroovyIndex {
    private static final Logger LOG = Logger.getLogger(GroovyIndex.class.getName());
    private static final GroovyIndex EMPTY = new GroovyIndex(null);
    private static final String CLUSTER_URL = "cluster:";
    private static String clusterUrl = null;
    private static String cachedPrefix = null;
    private static boolean cachedInsensitive = true;
    private static Pattern cachedCamelCasePattern = null;
    private final QuerySupport querySupport;

    private GroovyIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static GroovyIndex get(Collection<FileObject> roots) {
        try {
            return new GroovyIndex(QuerySupport.forRoots((String)"groovy", (int)9, (FileObject[])roots.toArray(new FileObject[0])));
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return EMPTY;
        }
    }

    public Set<IndexedClass> getClassesFromPackage(String packageName) {
        HashSet<IndexedClass> result = new HashSet<IndexedClass>();
        for (IndexedClass indexedClass : this.getAllClasses()) {
            String pkgName = GroovyUtils.getPackageName(indexedClass.getFqn());
            if (!packageName.equals(pkgName)) continue;
            result.add(indexedClass);
        }
        return result;
    }

    public Set<IndexedClass> getAllClasses() {
        return this.getClasses(".*", QuerySupport.Kind.REGEXP);
    }

    public Set<IndexedClass> getClasses(String name, QuerySupport.Kind kind) {
        String field;
        String classFqn = null;
        if (name != null && name.endsWith(".") && QuerySupport.Kind.CAMEL_CASE != kind) {
            classFqn = name.substring(0, name.length() - 1);
            name = "";
        }
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        switch (kind) {
            case EXACT: {
                field = "fqn";
                break;
            }
            case PREFIX: 
            case CAMEL_CASE: 
            case REGEXP: {
                field = "class";
                break;
            }
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_CAMEL_CASE: 
            case CASE_INSENSITIVE_REGEXP: {
                field = "class-ig";
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        this.search(field, name, kind, result);
        HashSet<IndexedClass> classes = new HashSet<IndexedClass>();
        for (IndexResult map : result) {
            String simpleName = map.getValue("class");
            if (simpleName == null || kind == QuerySupport.Kind.PREFIX && !simpleName.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !simpleName.regionMatches(true, 0, name, 0, name.length())) continue;
            if (classFqn != null) {
                String in = map.getValue("in");
                if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP ? !classFqn.equalsIgnoreCase(map.getValue("in")) : kind == QuerySupport.Kind.CAMEL_CASE && !GroovyIndex.matchCamelCase(classFqn, in, false) || kind == QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE && !GroovyIndex.matchCamelCase(classFqn, in, true) || !classFqn.equals(map.getValue("in"))) continue;
            }
            String attrs = map.getValue("attrs");
            boolean isClass = true;
            if (attrs != null) {
                int flags = IndexedElement.stringToFlag(attrs, 0);
                isClass = (flags & 0x40) == 0;
            }
            String fqn = map.getValue("fqn");
            classes.add(this.createClass(fqn, simpleName, map));
        }
        return classes;
    }

    public Set<IndexedMethod> getConstructors(String className) {
        HashSet<IndexResult> indexResult = new HashSet<IndexResult>();
        HashSet<IndexedMethod> result = new HashSet<IndexedMethod>();
        this.search("ctor", className, QuerySupport.Kind.PREFIX, indexResult);
        for (IndexResult map : indexResult) {
            String[] constructors;
            for (String constructor : constructors = map.getValues("ctor")) {
                String[] parts = constructor.split(";");
                if (parts.length < 4) continue;
                String paramList = parts[1];
                String[] params = paramList.split(",");
                ArrayList<MethodElement.MethodParameter> methodParams = new ArrayList<MethodElement.MethodParameter>();
                for (String param : params) {
                    if ("".equals(param.trim())) continue;
                    methodParams.add(new MethodElement.MethodParameter(param, GroovyUtils.stripPackage(param)));
                }
                int flags = 0;
                if (!parts[2].isEmpty()) {
                    flags = IndexedElement.stringToFlag(parts[2], 0);
                }
                IndexedMethod c = new IndexedMethod(map, className, className, "void", methodParams, "", flags);
                OffsetRange range = GroovyIndex.createOffsetRange(parts[3]);
                if (range != null) {
                    c.setOffsetRange(range);
                }
                result.add(c);
            }
        }
        return result;
    }

    public Set<IndexedMethod> getMethods(String name, String clz, QuerySupport.Kind kind) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "method";
        QuerySupport.Kind originalKind = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        this.search(field, name, kind, result);
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        for (IndexResult map : result) {
            String[] signatures;
            String fqn;
            if (clz != null && !clz.equals(fqn = map.getValue("fqn")) || (signatures = map.getValues("method")) == null) continue;
            for (String signature : signatures) {
                block9: {
                    if ((name == null || name.length() == 0) && !Character.isLowerCase(signature.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !signature.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !signature.regionMatches(true, 0, name, 0, name.length()) || kind == QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE && !GroovyIndex.matchCamelCase(name, signature, true) || kind == QuerySupport.Kind.CAMEL_CASE && !GroovyIndex.matchCamelCase(name, signature, false)) continue;
                    if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                        int len = signature.length();
                        int end = signature.indexOf(40);
                        if (end == -1 && (end = signature.indexOf(59)) == -1) {
                            end = len;
                        }
                        String n = end != len ? signature.substring(0, end) : signature;
                        try {
                            if (!n.matches(name)) {
                                continue;
                            }
                            break block9;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            break block9;
                        }
                    }
                    if (originalKind == QuerySupport.Kind.EXACT && signature.length() > name.length() && signature.charAt(name.length()) != '(' && signature.charAt(name.length()) != ';') continue;
                }
                assert (map != null);
                IndexedMethod method = this.createMethod(signature, map);
                if (method == null) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean matchCamelCase(String prefix, String where, boolean insensitive) {
        if (where == null || where.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        Class<GroovyIndex> clazz = GroovyIndex.class;
        synchronized (GroovyIndex.class) {
            if (!prefix.equals(cachedPrefix) || cachedInsensitive != insensitive) {
                int index;
                StringBuilder sb = new StringBuilder();
                int lastIndex = 0;
                do {
                    String token = prefix.substring(lastIndex, (index = GroovyIndex.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                cachedPrefix = prefix;
                cachedInsensitive = insensitive;
                cachedCamelCasePattern = insensitive ? Pattern.compile(sb.toString(), 2) : Pattern.compile(sb.toString());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cachedCamelCasePattern.matcher(where).matches();
        }
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public Set<IndexedField> getAllFields(String fqName) {
        return this.getFields(".*", fqName, QuerySupport.Kind.REGEXP);
    }

    public Set<IndexedField> getStaticFields(String fqName) {
        Set<IndexedField> fields = this.getFields(".*", fqName, QuerySupport.Kind.REGEXP);
        HashSet<IndexedField> staticFields = new HashSet<IndexedField>();
        for (IndexedField field : fields) {
            if (!field.getModifiers().contains(Modifier.STATIC)) continue;
            staticFields.add(field);
        }
        return staticFields;
    }

    public Set<IndexedField> getFields(String name, String clz, QuerySupport.Kind kind) {
        boolean inherited = clz == null;
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "field";
        QuerySupport.Kind originalKind = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        this.search(field, name, kind, result);
        HashSet<IndexedField> fields = new HashSet<IndexedField>();
        for (IndexResult map : result) {
            String[] signatures;
            String fqn;
            if (clz != null && !clz.equals(fqn = map.getValue("fqn")) || (signatures = map.getValues("field")) == null) continue;
            for (String signature : signatures) {
                block9: {
                    String fieldName;
                    if ((name == null || name.length() == 0) && !Character.isLowerCase(signature.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !signature.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !signature.regionMatches(true, 0, name, 0, name.length())) continue;
                    int len = signature.length();
                    int end = signature.indexOf(59);
                    if (end == -1) {
                        end = len;
                    }
                    String string = fieldName = end != len ? signature.substring(0, end) : signature;
                    if (originalKind == QuerySupport.Kind.EXACT && !name.equals(fieldName)) continue;
                    if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                        try {
                            if (!fieldName.matches(name)) {
                                continue;
                            }
                            break block9;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            break block9;
                        }
                    }
                    if (kind == QuerySupport.Kind.CAMEL_CASE && !GroovyIndex.matchCamelCase(name, fieldName, false) || kind == QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE && !GroovyIndex.matchCamelCase(name, fieldName, true)) continue;
                }
                assert (map != null);
                IndexedField createdField = this.createField(signature, map, inherited);
                if (createdField == null) continue;
                fields.add(createdField);
            }
        }
        return fields;
    }

    public Set<IndexedMethod> getInheritedMethods(String classFqn, String prefix, QuerySupport.Kind kind) {
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        HashSet<String> scannedClasses = new HashSet<String>();
        HashSet<String> seenSignatures = new HashSet<String>();
        if (prefix == null) {
            prefix = "";
        }
        this.addMethodsFromClass(prefix, kind, classFqn, methods, seenSignatures, scannedClasses);
        return methods;
    }

    private boolean addMethodsFromClass(String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods, Set<String> seenSignatures, Set<String> scannedClasses) {
        boolean foundIt;
        if (scannedClasses.contains(classFqn)) {
            return false;
        }
        scannedClasses.add(classFqn);
        String searchField = "fqn";
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        this.search(searchField, classFqn, QuerySupport.Kind.EXACT, result);
        boolean bl = foundIt = result.size() > 0;
        if (!foundIt) {
            return foundIt;
        }
        for (IndexResult map : result) {
            assert (map != null);
            String[] signatures = map.getValues("method");
            if (signatures == null) continue;
            for (String signature : signatures) {
                if (prefix.length() == 0 && !Character.isLowerCase(signature.charAt(0)) || seenSignatures.contains(signature) || !signature.startsWith(prefix)) continue;
                if (kind == QuerySupport.Kind.EXACT) {
                    if (signature.length() > prefix.length() && signature.charAt(prefix.length()) != '(' && signature.charAt(prefix.length()) != ';') {
                        continue;
                    }
                } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                seenSignatures.add(signature);
                IndexedMethod method = this.createMethod(signature, map);
                if (method == null) continue;
                methods.add(method);
            }
        }
        this.addMethodsFromClass(prefix, kind, "java.lang.Object", methods, seenSignatures, scannedClasses);
        return foundIt;
    }

    private IndexedClass createClass(String fqn, String simpleName, IndexResult map) {
        OffsetRange range;
        if (simpleName == null) {
            simpleName = map.getValue("class");
        }
        String attrs = map.getValue("attrs");
        int flags = 0;
        if (attrs != null) {
            flags = IndexedElement.stringToFlag(attrs, 0);
        }
        IndexedClass c = IndexedClass.create(simpleName, fqn, map, attrs, flags);
        String offset = map.getValue("class-range");
        if (offset != null && (range = GroovyIndex.createOffsetRange(offset)) != null) {
            c.setOffsetRange(range);
        }
        return c;
    }

    private IndexedMethod createMethod(String signature, IndexResult map) {
        String clz = map.getValue("class");
        String module = map.getValue("in");
        if (clz == null) {
            clz = module;
        } else if (module != null && module.length() > 0) {
            clz = module + "." + clz;
        }
        String[] parts = signature.split(";");
        if (parts.length < 4) {
            return null;
        }
        String methodSignature = parts[0];
        String type = parts[1].isEmpty() ? "void" : parts[1];
        int flags = parts[2].isEmpty() ? 0 : IndexedElement.stringToFlag(parts[2], 0);
        OffsetRange range = GroovyIndex.createOffsetRange(parts[3]);
        String attributes = parts[2];
        IndexedMethod m = new IndexedMethod(map, clz, this.getMethodName(methodSignature), type, this.getMethodParameter(methodSignature), attributes, flags);
        if (range != null) {
            m.setOffsetRange(range);
        }
        return m;
    }

    private String getMethodName(String methodSignature) {
        int parenIndex = methodSignature.indexOf(40);
        if (parenIndex == -1) {
            return methodSignature;
        }
        return methodSignature.substring(0, parenIndex);
    }

    private List<MethodElement.MethodParameter> getMethodParameter(String methodSignature) {
        int parenIndex = methodSignature.indexOf(40);
        if (parenIndex == -1) {
            return Collections.emptyList();
        }
        String argsPortion = methodSignature.substring(parenIndex + 1, methodSignature.length() - 1);
        String[] args = argsPortion.split(",");
        if (args == null || args.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<MethodElement.MethodParameter> parameters = new ArrayList<MethodElement.MethodParameter>();
        for (String paramType : args) {
            parameters.add(new MethodElement.MethodParameter(paramType, GroovyUtils.stripPackage(paramType)));
        }
        return parameters;
    }

    private IndexedField createField(String signature, IndexResult map, boolean inherited) {
        String clz = map.getValue("class");
        String module = map.getValue("in");
        if (clz == null) {
            clz = module;
        } else if (module != null && module.length() > 0) {
            clz = module + "." + clz;
        }
        String[] parts = signature.split(";");
        if (parts.length < 5) {
            return null;
        }
        String name = parts[0];
        String type = parts[1].isEmpty() ? "java.lang.Object" : parts[1];
        int flags = parts[2].isEmpty() ? 0 : IndexedElement.stringToFlag(parts[2], 0);
        String isProperty = parts[3];
        String attributes = flags + ";" + isProperty;
        OffsetRange range = GroovyIndex.createOffsetRange(parts[4]);
        IndexedField m = IndexedField.create(type, name, clz, map, attributes, flags);
        m.setInherited(inherited);
        if (range != null) {
            m.setOffsetRange(range);
        }
        return m;
    }

    private static OffsetRange createOffsetRange(String text) {
        OffsetRange result = null;
        int offsetStartIndex = text.indexOf(91);
        int commaIndex = text.indexOf(44, offsetStartIndex + 1);
        int offsetLastIndex = text.indexOf(93, commaIndex + 1);
        if (offsetStartIndex != -1 && commaIndex != -1 && offsetLastIndex != -1) {
            int startOffset = Integer.parseInt(text.substring(offsetStartIndex + 1, commaIndex));
            int endOffset = Integer.parseInt(text.substring(commaIndex + 1, offsetLastIndex));
            result = new OffsetRange(startOffset, endOffset);
        }
        return result;
    }

    private boolean search(String key, String name, QuerySupport.Kind kind, Set<IndexResult> result) {
        try {
            result.addAll(this.querySupport.query(key, name, kind, new String[0]));
            return true;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return false;
        }
    }

    public static void setClusterUrl(String url) {
        clusterUrl = url;
    }

    static String getPreindexUrl(String url) {
        String s = GroovyIndex.getClusterUrl();
        if (url.startsWith(s)) {
            return CLUSTER_URL + url.substring(s.length());
        }
        return url;
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File f = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-groovy-editor.jar", null, false);
            if (f == null) {
                throw new RuntimeException("Can't find cluster");
            }
            f = new File(f.getParentFile().getParentFile().getAbsolutePath());
            try {
                f = f.getCanonicalFile();
                clusterUrl = f.toURI().toURL().toExternalForm();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return clusterUrl;
    }
}

