/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandException;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.glassfish.tooling.admin.RunnerRestClass;
import org.netbeans.modules.glassfish.tooling.admin.ServerAdmin;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;

@RunnerHttpClass
@RunnerRestClass
public class CommandVersion
extends Command {
    private static final Logger LOGGER = new Logger(CommandVersion.class);
    private static final String COMMAND = "version";

    public static ResultString getVersion(GlassFishServer server) throws GlassFishIdeException {
        String METHOD = "getVersion";
        Future future = ServerAdmin.exec(server, new CommandVersion());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new CommandException(LOGGER.excMsg("getVersion", "exception"), ee.getLocalizedMessage());
        }
    }

    public static GlassFishVersion getGlassFishVersion(GlassFishServer server) {
        String value;
        ResultString result;
        try {
            result = CommandVersion.getVersion(server);
        }
        catch (CommandException ce) {
            return null;
        }
        String string = value = result != null ? ServerUtils.getVersionString(result.getValue()) : null;
        if (value != null) {
            return GlassFishVersion.toValue(value);
        }
        return null;
    }

    public static boolean verifyResult(ResultString result, GlassFishServer server) {
        boolean verifyResult = false;
        String value = ServerUtils.getVersionString(result.getValue());
        if (value != null) {
            GlassFishVersion valueVersion = GlassFishVersion.toValue(value);
            GlassFishVersion serverVersion = server.getVersion();
            if (valueVersion != null && serverVersion != null) {
                verifyResult = serverVersion.equals(valueVersion);
            }
        }
        return verifyResult;
    }

    public CommandVersion() {
        super(COMMAND);
    }
}

