/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.EmptyStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;

public final class InvocationContextResolver {
    private static final Logger LOGGER = Logger.getLogger(InvocationContextResolver.class.getName());
    private List<ASTNode> nodes = new LinkedList<ASTNode>();
    private final JTextComponent component;

    public static InvocationContextResolver create(JTextComponent component) {
        InvocationContextResolver invocationContextResolver = new InvocationContextResolver(component);
        invocationContextResolver.resolveNodesUnderCarret();
        return invocationContextResolver;
    }

    private InvocationContextResolver(JTextComponent component) {
        this.component = component;
    }

    private void resolveNodesUnderCarret() {
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.component.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult info = (ParserResult)resultIterator.getParserResult();
                    if (info != null) {
                        int caretOffset = InvocationContextResolver.this.component.getCaretPosition();
                        InvocationContextResolver.this.nodes = NavUtils.underCaret(info, caretOffset);
                    }
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, "Error during resolving nodes under carret (codegens): {0}", ex.getMessage());
        }
    }

    public boolean isExactlyIn(InvocationContext context) {
        boolean result = false;
        if (!this.nodes.isEmpty()) {
            ASTNode lastNode = this.nodes.get(this.nodes.size() - 1);
            if (lastNode instanceof Block) {
                lastNode = this.nodes.get(this.nodes.size() - 2);
            }
            result = context.isExactlyIn(lastNode);
        }
        return result;
    }

    public static enum InvocationContext {
        CLASS{

            @Override
            boolean isExactlyIn(ASTNode lastNode) {
                return lastNode instanceof ClassDeclaration || lastNode instanceof TraitDeclaration || lastNode instanceof InterfaceDeclaration || lastNode instanceof EnumDeclaration || lastNode instanceof ClassInstanceCreation && ((ClassInstanceCreation)lastNode).isAnonymous();
            }
        }
        ,
        METHOD{

            @Override
            boolean isExactlyIn(ASTNode lastNode) {
                return lastNode instanceof MethodDeclaration;
            }
        }
        ,
        FUNCTION{

            @Override
            boolean isExactlyIn(ASTNode lastNode) {
                return lastNode instanceof FunctionDeclaration;
            }
        }
        ,
        NAMESPACE{

            @Override
            boolean isExactlyIn(ASTNode lastNode) {
                return lastNode instanceof NamespaceDeclaration;
            }
        }
        ,
        PROGRAM{

            @Override
            boolean isExactlyIn(ASTNode lastNode) {
                return lastNode instanceof Program;
            }
        }
        ,
        EMPTY_STATEMENT{

            @Override
            boolean isExactlyIn(ASTNode lastNode) {
                return lastNode instanceof EmptyStatement;
            }
        };


        abstract boolean isExactlyIn(ASTNode var1);
    }
}

