/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.spi.editor.bracesmatching.BraceContext;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public final class PHPBracesMatcher
implements BracesMatcher,
BracesMatcher.ContextLocator {
    private static final Logger LOGGER = Logger.getLogger(PHPBracesMatcher.class.getName());
    private final MatcherContext context;
    private boolean findBackward;
    private int originOffset;
    private int matchingOffset;
    private String matchingText;

    public PHPBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
            if (ts != null) {
                if (this.searchForward(ts, offset) && --offset < 0) {
                    int[] nArray = null;
                    return nArray;
                }
                ts.move(offset);
                if (!ts.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                Token token = ts.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId id = token.id();
                this.originOffset = ts.offset();
                if (LexUtilities.textEquals(token.text(), '(')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ')')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == PHPTokenId.PHP_CURLY_OPEN) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == PHPTokenId.PHP_CURLY_CLOSE) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '[')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ']')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '$', '{')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '#', '[')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ':')) {
                    do {
                        ts.movePrevious();
                    } while ((id = (token = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_CASE, PHPTokenId.PHP_TOKEN))).id()) == PHPTokenId.PHP_TOKEN && !TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":"));
                    if (id == PHPTokenId.PHP_IF || id == PHPTokenId.PHP_ELSE || id == PHPTokenId.PHP_ELSEIF || id == PHPTokenId.PHP_FOR || id == PHPTokenId.PHP_FOREACH || id == PHPTokenId.PHP_WHILE || id == PHPTokenId.PHP_SWITCH) {
                        ts.move(offset);
                        ts.moveNext();
                        token = ts.token();
                        int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                        return nArray;
                    }
                } else {
                    if (id == PHPTokenId.PHP_ENDFOR || id == PHPTokenId.PHP_ENDFOREACH || id == PHPTokenId.PHP_ENDIF || id == PHPTokenId.PHP_ENDSWITCH || id == PHPTokenId.PHP_ENDWHILE) {
                        int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                        return nArray;
                    }
                    if (id == PHPTokenId.PHP_ELSEIF || id == PHPTokenId.PHP_ELSE) {
                        while (token.id() != PHPTokenId.PHP_CURLY_OPEN && !":".equals(token.text().toString()) && ts.moveNext()) {
                            token = LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_CURLY_OPEN));
                        }
                        if (token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":") && ts.moveNext()) {
                            ts.move(offset);
                            ts.moveNext();
                            token = ts.token();
                            int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                            return nArray;
                        }
                    } else {
                        this.originOffset = -1;
                    }
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
            if (ts != null) {
                OffsetRange r;
                block40: {
                    TokenId id;
                    Token token;
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        int[] nArray;
                                                        if (this.searchForward(ts, offset) && --offset < 0) {
                                                            int[] nArray2 = null;
                                                            return nArray2;
                                                        }
                                                        ts.move(offset);
                                                        if (!ts.moveNext()) {
                                                            int[] nArray3 = null;
                                                            return nArray3;
                                                        }
                                                        token = ts.token();
                                                        if (token == null) {
                                                            int[] nArray4 = null;
                                                            return nArray4;
                                                        }
                                                        id = token.id();
                                                        r = null;
                                                        this.matchingText = "";
                                                        this.findBackward = false;
                                                        try {
                                                            if (!LexUtilities.textEquals(token.text(), '(')) break block31;
                                                            this.matchingText = ")";
                                                            r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_TOKEN, '(', PHPTokenId.PHP_TOKEN, ')');
                                                            nArray = new int[]{r.getStart(), r.getEnd()};
                                                            this.matchingOffset = r != null ? r.getStart() : -1;
                                                        }
                                                        catch (Throwable throwable) {
                                                            this.matchingOffset = r != null ? r.getStart() : -1;
                                                            throw throwable;
                                                        }
                                                        return nArray;
                                                    }
                                                    if (!LexUtilities.textEquals(token.text(), ')')) break block32;
                                                    this.findBackward = true;
                                                    this.matchingText = "(";
                                                    r = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_TOKEN, '(', PHPTokenId.PHP_TOKEN, ')');
                                                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                                                    this.matchingOffset = r != null ? r.getStart() : -1;
                                                    return nArray;
                                                }
                                                if (id != PHPTokenId.PHP_CURLY_OPEN) break block33;
                                                this.matchingText = "}";
                                                r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_CURLY_OPEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}');
                                                int[] nArray = new int[]{r.getStart(), r.getEnd()};
                                                this.matchingOffset = r != null ? r.getStart() : -1;
                                                return nArray;
                                            }
                                            if (id != PHPTokenId.PHP_CURLY_CLOSE) break block34;
                                            this.findBackward = true;
                                            r = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_CURLY_OPEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}');
                                            this.matchingText = r.getLength() == 1 ? "{" : "${";
                                            int[] nArray = new int[]{r.getStart(), r.getEnd()};
                                            this.matchingOffset = r != null ? r.getStart() : -1;
                                            return nArray;
                                        }
                                        if (!LexUtilities.textEquals(token.text(), '[')) break block35;
                                        this.matchingText = "]";
                                        r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_TOKEN, '[', PHPTokenId.PHP_TOKEN, ']');
                                        int[] nArray = new int[]{r.getStart(), r.getEnd()};
                                        this.matchingOffset = r != null ? r.getStart() : -1;
                                        return nArray;
                                    }
                                    if (!LexUtilities.textEquals(token.text(), ']')) break block36;
                                    this.findBackward = true;
                                    r = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_TOKEN, '[', PHPTokenId.PHP_TOKEN, ']');
                                    this.matchingText = r.getLength() == 1 ? "[" : "#[";
                                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                                    this.matchingOffset = r != null ? r.getStart() : -1;
                                    return nArray;
                                }
                                if (!LexUtilities.textEquals(token.text(), '$', '{')) break block37;
                                this.matchingText = "}";
                                r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_TOKEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}');
                                int[] nArray = new int[]{r.getStart(), r.getEnd()};
                                this.matchingOffset = r != null ? r.getStart() : -1;
                                return nArray;
                            }
                            if (!LexUtilities.textEquals(token.text(), '#', '[')) break block38;
                            this.matchingText = "]";
                            r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_TOKEN, '[', PHPTokenId.PHP_TOKEN, ']');
                            int[] nArray = new int[]{r.getStart(), r.getEnd()};
                            this.matchingOffset = r != null ? r.getStart() : -1;
                            return nArray;
                        }
                        if (!LexUtilities.textEquals(token.text(), ':')) break block39;
                        r = LexUtilities.findFwdAlternativeSyntax(doc, ts, (Token<? extends PHPTokenId>)token);
                        Token t = ts.token();
                        this.matchingText = t == null ? "" : t.text().toString();
                        int[] nArray = new int[]{r.getStart(), r.getEnd()};
                        this.matchingOffset = r != null ? r.getStart() : -1;
                        return nArray;
                    }
                    if (id != PHPTokenId.PHP_ENDFOR && id != PHPTokenId.PHP_ENDFOREACH && id != PHPTokenId.PHP_ENDIF && id != PHPTokenId.PHP_ENDSWITCH && id != PHPTokenId.PHP_ENDWHILE && id != PHPTokenId.PHP_ELSEIF && id != PHPTokenId.PHP_ELSE) break block40;
                    this.findBackward = true;
                    r = LexUtilities.findBwdAlternativeSyntax(doc, ts, (Token<? extends PHPTokenId>)token);
                    this.matchingText = ":";
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    this.matchingOffset = r != null ? r.getStart() : -1;
                    return nArray;
                }
                this.matchingOffset = r != null ? r.getStart() : -1;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean searchForward(TokenSequence<? extends PHPTokenId> ts, int offset) {
        if (this.context.isSearchingBackward()) {
            Token previousToken;
            ts.move(offset);
            if (ts.movePrevious() && (previousToken = ts.token()) != null && PHPBracesMatcher.isBraceToken((Token<? extends PHPTokenId>)previousToken)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isBraceToken(Token<? extends PHPTokenId> token) {
        PHPTokenId id = (PHPTokenId)token.id();
        return LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), ')') || id == PHPTokenId.PHP_CURLY_OPEN || id == PHPTokenId.PHP_CURLY_CLOSE || LexUtilities.textEquals(token.text(), '[') || LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), '$', '{') || LexUtilities.textEquals(token.text(), '#', '[') || LexUtilities.textEquals(token.text(), ':') || id == PHPTokenId.PHP_ENDFOR || id == PHPTokenId.PHP_ENDFOREACH || id == PHPTokenId.PHP_ENDIF || id == PHPTokenId.PHP_ENDSWITCH || id == PHPTokenId.PHP_ENDWHILE || id == PHPTokenId.PHP_ELSEIF || id == PHPTokenId.PHP_ELSE;
    }

    public BraceContext findContext(int originOrMatchPosition) {
        if (this.findBackward && (this.matchingText.equals("{") || this.matchingText.equals(":"))) {
            if (this.originOffset != originOrMatchPosition) {
                return null;
            }
            try {
                return this.findContextBackwards();
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "incorrect offset: " + ex.offsetRequested(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BraceContext findContextBackwards() throws BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, this.matchingOffset);
            if (ts == null) {
                BraceContext braceContext = null;
                return braceContext;
            }
            ts.move(this.matchingOffset);
            if (!ts.moveNext()) {
                BraceContext braceContext = null;
                return braceContext;
            }
            List<PHPTokenId> lookfor = Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_CLASS, PHPTokenId.PHP_INTERFACE, PHPTokenId.PHP_TRAIT, PHPTokenId.PHP_FUNCTION, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_DO, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_TRY, PHPTokenId.PHP_CATCH, PHPTokenId.PHP_FINALLY, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_USE, PHPTokenId.PHP_MATCH, PHPTokenId.PHP_ENUM);
            Token<? extends PHPTokenId> previousToken = LexUtilities.findPreviousToken(ts, lookfor);
            if (previousToken == null || previousToken.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                BraceContext braceContext = null;
                return braceContext;
            }
            PHPTokenId id = (PHPTokenId)previousToken.id();
            switch (id) {
                case PHP_ELSE: {
                    BraceContext braceContext = this.getBraceContextForIfStatement(ts);
                    return braceContext;
                }
            }
            BraceContext braceContext = this.getBraceContext(ts.offset());
            return braceContext;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private BraceContext getBraceContextForIfStatement(TokenSequence<? extends PHPTokenId> ts) throws BadLocationException {
        int elseStart = ts.offset();
        if (elseStart < 0 || this.matchingOffset < elseStart) {
            return null;
        }
        int balance = 0;
        int ifStart = -1;
        int ifEnd = -1;
        String lastBrace = null;
        boolean found = false;
        boolean isAlternative = ":".equals(this.matchingText);
        while (ts.movePrevious()) {
            Token token = ts.token();
            PHPTokenId id = (PHPTokenId)token.id();
            switch (id) {
                case PHP_ENDIF: {
                    if (!isAlternative) break;
                    ++balance;
                    break;
                }
                case PHP_ELSEIF: 
                case PHP_IF: {
                    if (!this.matchingText.equals(lastBrace)) break;
                    if (balance == 0) {
                        ifStart = ts.offset();
                        found = true;
                    }
                    if (!isAlternative || id != PHPTokenId.PHP_IF) break;
                    --balance;
                    break;
                }
                case PHP_CURLY_CLOSE: {
                    if (isAlternative) break;
                    ++balance;
                    break;
                }
                case PHP_CURLY_OPEN: {
                    if (!isAlternative) {
                        --balance;
                        ifEnd = ts.offset();
                    }
                    lastBrace = token.text().toString();
                    break;
                }
                case PHP_TOKEN: {
                    if (PHPBracesMatcher.isColon((Token<? extends PHPTokenId>)token)) {
                        if (isAlternative) {
                            ifEnd = ts.offset();
                        }
                        lastBrace = token.text().toString();
                    }
                    if (!PHPBracesMatcher.isComplexSyntaxOpen((Token<? extends PHPTokenId>)token)) break;
                    if (!isAlternative) {
                        --balance;
                    }
                    lastBrace = token.text().toString();
                    break;
                }
            }
            if (!found) continue;
            break;
        }
        if (!found || ifStart == -1 || ifEnd == -1) {
            return this.getBraceContext(elseStart);
        }
        BraceContext braceContext = BraceContext.create((Position)this.context.getDocument().createPosition(ifStart), (Position)this.context.getDocument().createPosition(ifEnd + 1));
        return braceContext.createRelated(this.context.getDocument().createPosition(elseStart), this.context.getDocument().createPosition(this.matchingOffset + 1));
    }

    private BraceContext getBraceContext(int start) throws BadLocationException {
        return BraceContext.create((Position)this.context.getDocument().createPosition(start), (Position)this.context.getDocument().createPosition(this.matchingOffset + 1));
    }

    private static boolean isColon(Token<? extends PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":");
    }

    private static boolean isComplexSyntaxOpen(Token<? extends PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"${");
    }
}

