/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;

public final class DDType {
    private static final String NAME_SUNAPPCLIENT = "sun-application-client.xml";
    private static final String NAME_SUNAPPLICATION = "sun-application.xml";
    private static final String NAME_SUNCMPMAPPING = "sun-cmp-mappings.xml";
    private static final String NAME_SUNEJBJAR = "sun-ejb-jar.xml";
    private static final String NAME_SUNWEBAPP = "sun-web.xml";
    private static final String NAME_SUNRESOURCE = "sun-resources.xml";
    private static final String NAME_GFAPPCLIENT = "glassfish-application-client.xml";
    private static final String NAME_GFAPPLICATION = "glassfish-application.xml";
    private static final String NAME_GFEJBJAR = "glassfish-ejb-jar.xml";
    private static final String NAME_GFWEBAPP = "glassfish-web.xml";
    private static final String NAME_GFRESOURCE = "glassfish-resources.xml";
    public static final DDType DD_SUN_WEB_APP = new DDType("sun-web.xml", J2eeModule.Type.WAR);
    public static final DDType DD_SUN_EJB_JAR = new DDType("sun-ejb-jar.xml", J2eeModule.Type.EJB);
    public static final DDType DD_SUN_APP_CLIENT = new DDType("sun-application-client.xml", J2eeModule.Type.CAR);
    public static final DDType DD_SUN_APPLICATION = new DDType("sun-application.xml", J2eeModule.Type.EAR);
    public static final DDType DD_SUN_CMP_MAPPINGS = new DDType("sun-cmp-mappings.xml", J2eeModule.Type.EJB);
    public static final DDType DD_SUN_RESOURCE = new DDType("sun-resources.xml", null);
    public static final DDType DD_GF_WEB_APP = new DDType("glassfish-web.xml", J2eeModule.Type.WAR);
    public static final DDType DD_GF_EJB_JAR = new DDType("glassfish-ejb-jar.xml", J2eeModule.Type.EJB);
    public static final DDType DD_GF_APP_CLIENT = new DDType("glassfish-application-client.xml", J2eeModule.Type.CAR);
    public static final DDType DD_GF_APPLICATION = new DDType("glassfish-application.xml", J2eeModule.Type.EAR);
    public static final DDType DD_GF_RESOURCE = new DDType("glassfish-resources.xml", null);
    private static final Map<String, DDType> fileToTypeMap = new HashMap<String, DDType>(11);
    public static final String WEB_MIME_TYPE = "text/x-dd-sun-web+xml";
    public static final String EJB_MIME_TYPE = "text/x-dd-sun-ejb-jar+xml";
    public static final String APP_MIME_TYPE = "text/x-dd-sun-application+xml";
    public static final String APP_CLI_MIME_TYPE = "text/x-dd-sun-app-client+xml";
    public static final String RSRC_MIME_TYPE = "text/x-sun-resource+xml";
    public static final String CMP_MIME_TYPE = "text/x-sun-cmp-mapping+xml";
    static final String WEB_MIME_TYPE_SUFFIX = "-web+xml";
    static final String EJB_MIME_TYPE_SUFFIX = "-ejb-jar+xml";
    static final String APP_MIME_TYPE_SUFFIX = "-application+xml";
    static final String APP_CLI_MIME_TYPE_SUFFIX = "-app-client+xml";
    static final String RSRC_MIME_TYPE_SUFFIX = "-resource+xml";
    static final String CMP_MIME_TYPE_SUFFIX = "-cmp-mapping+xml";
    private static final Map<String, String> fileToMimeSuffixMap;
    static final String IPLANET_MIME_TYPE_PREFIX = "text/x-dd-iplanet";
    static final String SUN_MIME_TYPE_PREFIX = "text/x-dd-sun";
    static final String GLASSFISH_MIME_TYPE_PREFIX = "text/x-dd-glassfish";
    private final String descriptorName;
    private final J2eeModule.Type moduleType;

    public static DDType getDDType(String fileName) {
        return fileToTypeMap.get(fileName);
    }

    private DDType(String ddName, J2eeModule.Type type) {
        this.descriptorName = ddName;
        this.moduleType = type;
    }

    public String getDescriptorFileName() {
        return this.descriptorName;
    }

    public J2eeModule.Type getEditorModuleType() {
        return this.moduleType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DDType other = (DDType)obj;
        if (!this.moduleType.equals(other.moduleType)) {
            return false;
        }
        return this.descriptorName.equals(other.descriptorName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.descriptorName != null ? this.descriptorName.hashCode() : 0);
        return hash;
    }

    String getDescriptorMimeTypeSuffix() {
        return fileToMimeSuffixMap.get(this.descriptorName);
    }

    static {
        fileToTypeMap.put(NAME_SUNWEBAPP, DD_SUN_WEB_APP);
        fileToTypeMap.put(NAME_SUNEJBJAR, DD_SUN_EJB_JAR);
        fileToTypeMap.put(NAME_SUNAPPLICATION, DD_SUN_APPLICATION);
        fileToTypeMap.put(NAME_SUNAPPCLIENT, DD_SUN_APP_CLIENT);
        fileToTypeMap.put(NAME_SUNCMPMAPPING, DD_SUN_CMP_MAPPINGS);
        fileToTypeMap.put(NAME_SUNRESOURCE, DD_SUN_RESOURCE);
        fileToTypeMap.put(NAME_GFWEBAPP, DD_GF_WEB_APP);
        fileToTypeMap.put(NAME_GFEJBJAR, DD_GF_EJB_JAR);
        fileToTypeMap.put(NAME_GFAPPLICATION, DD_GF_APPLICATION);
        fileToTypeMap.put(NAME_GFAPPCLIENT, DD_GF_APP_CLIENT);
        fileToTypeMap.put(NAME_GFRESOURCE, DD_GF_RESOURCE);
        fileToMimeSuffixMap = new HashMap<String, String>(8);
        fileToMimeSuffixMap.put(NAME_SUNWEBAPP, WEB_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_SUNEJBJAR, EJB_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_SUNAPPLICATION, APP_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_SUNAPPCLIENT, APP_CLI_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_SUNCMPMAPPING, CMP_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_SUNRESOURCE, RSRC_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_GFWEBAPP, WEB_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_GFEJBJAR, EJB_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_GFAPPLICATION, APP_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_GFAPPCLIENT, APP_CLI_MIME_TYPE_SUFFIX);
        fileToMimeSuffixMap.put(NAME_GFRESOURCE, RSRC_MIME_TYPE_SUFFIX);
    }
}

