/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.core.WsWsdlCookie;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxWsExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedServiceNode = null;
    private JLabel jLblTreeView;

    public JaxWsExplorerPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"ACSD_WebServicesTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"ACSD_WebServicesTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        Children.Array rootChildren = new Children.Array();
        AbstractNode explorerClientRoot = new AbstractNode((Children)rootChildren);
        ArrayList<ProjectNode> projectNodeList = new ArrayList<ProjectNode>();
        block0: for (Project prj : projects) {
            Node[] projectSubnodes;
            Node rootNode;
            Children projectChildren;
            WebServiceData wsData = WebServiceData.getWebServiceData((Project)prj);
            if (wsData != null) {
                List webServices = wsData.getServiceProviders();
                if (webServices.size() <= 0) continue;
                Children.Array children = new Children.Array();
                ArrayList<ServiceNode> serviceNodes = new ArrayList<ServiceNode>();
                boolean i = false;
                for (WebService service : webServices) {
                    Node n = service.createNode();
                    if (n == null) continue;
                    serviceNodes.add(new ServiceNode(n));
                }
                LogicalViewProvider logicalProvider = (LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class);
                if (logicalProvider == null) continue;
                children.add(serviceNodes.toArray(new Node[0]));
                Node rootNode2 = logicalProvider.createLogicalView();
                projectNodeList.add(new ProjectNode((Children)children, rootNode2));
                continue;
            }
            LogicalViewProvider logicalProvider = (LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class);
            if (logicalProvider == null || (projectChildren = (rootNode = logicalProvider.createLogicalView()).getChildren()).getNodesCount() <= 0) continue;
            for (Node n : projectSubnodes = projectChildren.getNodes()) {
                if (n.getValue("is_web_service_root") == null) continue;
                Children.Array children = new Children.Array();
                Children originalServiceChildren = n.getChildren();
                if (originalServiceChildren.getNodesCount() <= 0) continue block0;
                Node[] otherServiceNodes = originalServiceChildren.getNodes();
                Node[] serviceNodes = new Node[otherServiceNodes.length];
                for (int j = 0; j < otherServiceNodes.length; ++j) {
                    serviceNodes[j] = new ServiceNode(otherServiceNodes[j]);
                }
                children.add(serviceNodes);
                projectNodeList.add(new ProjectNode((Children)children, rootNode));
                continue block0;
            }
        }
        Node[] projectNodes = new Node[projectNodeList.size()];
        projectNodeList.toArray(projectNodes);
        rootChildren.add(projectNodes);
        this.manager.setRootContext((Node)explorerClientRoot);
        this.descriptor.setValid(false);
    }

    @Override
    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Node getSelectedService() {
        return this.selectedServiceNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Node[] nodes;
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()) != null && nodes.length > 0) {
            Node node = nodes[0];
            if (node.getCookie(WsWsdlCookie.class) != null) {
                this.selectedServiceNode = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedServiceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private static class ServiceNode
    extends FilterNode
    implements WsWsdlCookie {
        private Node serviceNode;

        ServiceNode(Node serviceNode) {
            super(serviceNode);
            this.serviceNode = serviceNode;
        }

        @Override
        public String getWsdlURL() {
            WsWsdlCookie cookie = (WsWsdlCookie)this.serviceNode.getLookup().lookup(WsWsdlCookie.class);
            if (cookie != null) {
                return cookie.getWsdlURL();
            }
            String wsdlUrl = (String)this.serviceNode.getValue("wsdl-url");
            if (wsdlUrl != null) {
                return wsdlUrl;
            }
            return null;
        }
    }

    private static class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node rootNode) {
            super(children);
            this.rootNode = rootNode;
            this.setName(rootNode.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.rootNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.rootNode.getOpenedIcon(type);
        }
    }
}

