/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.JLabel;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.jakarta.web.beans.api.model.CdiException;
import org.netbeans.modules.jakarta.web.beans.api.model.Result;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.BindingsPanel;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.jakarta.web.beans.navigation.ObserversPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class InterceptorsPanel
extends BindingsPanel {
    private static final long serialVersionUID = -3849331046190789438L;

    public InterceptorsPanel(Object[] subject, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, JavaHierarchyModel treeModel, Result result) {
        super(subject, metaModel, model, treeModel, result);
        this.initLabels();
    }

    @Override
    protected void setContextElement(Element context, CompilationController controller) {
        if (context instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)context;
            this.getShortElementName().append(context.getSimpleName().toString());
            this.appendMethodParams(this.getShortElementName(), method);
            TypeElement enclosingType = controller.getElementUtilities().enclosingTypeElement(context);
            String typeFqn = enclosingType.getQualifiedName().toString();
            this.getFqnElementName().append(typeFqn);
            this.getFqnElementName().append('.');
            this.getFqnElementName().append(context.getSimpleName().toString());
            this.appendMethodParams(this.getFqnElementName(), method);
        } else if (context instanceof TypeElement) {
            TypeElement type = (TypeElement)context;
            this.getShortElementName().append(type.getSimpleName().toString());
            this.getFqnElementName().append(type.getQualifiedName().toString());
        }
    }

    @Override
    protected void initBindings(WebBeansModel model, Element element) {
        Collection<AnnotationMirror> interceptorBindings = model.getInterceptorBindings(element);
        StringBuilder fqnBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        for (AnnotationMirror annotationMirror : interceptorBindings) {
            this.appendAnnotationMirror(annotationMirror, fqnBuilder, true);
            this.appendAnnotationMirror(annotationMirror, builder, false);
        }
        if (fqnBuilder.length() > 0) {
            this.setFqnBindings(fqnBuilder.substring(0, fqnBuilder.length() - 2));
            this.setShortBindings(builder.substring(0, builder.length() - 2));
        } else {
            this.setFqnBindings("");
            this.setShortBindings("");
        }
        if (this.showFqns()) {
            this.getInitialBindingsComponent().setText(this.getFqnBindings());
        } else {
            this.getInitialBindingsComponent().setText(this.getShortBindings());
        }
    }

    @Override
    protected void doShowSelectedCDI(ElementHandle<?> elementHandle, WebBeansModel model) throws CdiException {
        Element element = elementHandle.resolve((CompilationInfo)model.getCompilationController());
        if (element == null) {
            this.getSelectedBindingsComponent().setText("");
        } else {
            element = this.getSelectedQualifiedElement(element, model);
            Collection<AnnotationMirror> interceptorBindings = model.getInterceptorBindings(element);
            StringBuilder builder = new StringBuilder();
            for (AnnotationMirror annotationMirror : interceptorBindings) {
                this.appendAnnotationMirror(annotationMirror, builder, this.showFqns());
            }
            String bindingsString = "";
            if (builder.length() > 0) {
                bindingsString = builder.substring(0, builder.length() - 2);
            }
            this.getSelectedBindingsComponent().setText(bindingsString);
            this.setStereotypes(model, element);
        }
    }

    private void appendMethodParams(StringBuilder builder, ExecutableElement method) {
        builder.append('(');
        List<? extends VariableElement> parameters = method.getParameters();
        int i = 0;
        for (VariableElement variableElement : parameters) {
            String param = variableElement.getSimpleName().toString();
            builder.append(param);
            if (i < parameters.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append(')');
    }

    private void initLabels() {
        JLabel elementLabel = this.getSubjectElementLabel();
        Mnemonics.setLocalizedText((JLabel)elementLabel, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_InterceptedElement"));
        elementLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_InterceptedElement"));
        elementLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_InterceptedElement"));
        JLabel iBindingsLabel = this.getSubjectBindingsLabel();
        Mnemonics.setLocalizedText((JLabel)iBindingsLabel, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_InterceptorBindings"));
        iBindingsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_InterceptorBindings"));
        iBindingsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_InterceptorBindings"));
        JLabel selectedIBindgings = this.getSelectedBindingsLabel();
        Mnemonics.setLocalizedText((JLabel)selectedIBindgings, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_SelectedInterceptorBindings"));
        selectedIBindgings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_SelectedInterceptorBindings"));
        selectedIBindgings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_SelectedInterceptorBindings"));
        JLabel selectedStereotypes = this.getStereotypesLabel();
        Mnemonics.setLocalizedText((JLabel)selectedStereotypes, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_IStereotypes"));
        selectedStereotypes.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_IStereotypes"));
        selectedStereotypes.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_IStereotypes"));
    }
}

