"""Generated client library for datacatalog version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.datacatalog.v1 import datacatalog_v1_messages as messages


class DatacatalogV1(base_api.BaseApiClient):
  """Generated client library for service datacatalog version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://datacatalog.googleapis.com/'
  MTLS_BASE_URL = 'https://datacatalog.mtls.googleapis.com/'

  _PACKAGE = 'datacatalog'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'DatacatalogV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new datacatalog handle."""
    url = url or self.BASE_URL
    super(DatacatalogV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.catalog = self.CatalogService(self)
    self.entries = self.EntriesService(self)
    self.projects_locations_entryGroups_entries_tags = self.ProjectsLocationsEntryGroupsEntriesTagsService(self)
    self.projects_locations_entryGroups_entries = self.ProjectsLocationsEntryGroupsEntriesService(self)
    self.projects_locations_entryGroups_tags = self.ProjectsLocationsEntryGroupsTagsService(self)
    self.projects_locations_entryGroups = self.ProjectsLocationsEntryGroupsService(self)
    self.projects_locations_tagTemplates_fields_enumValues = self.ProjectsLocationsTagTemplatesFieldsEnumValuesService(self)
    self.projects_locations_tagTemplates_fields = self.ProjectsLocationsTagTemplatesFieldsService(self)
    self.projects_locations_tagTemplates = self.ProjectsLocationsTagTemplatesService(self)
    self.projects_locations_taxonomies_policyTags = self.ProjectsLocationsTaxonomiesPolicyTagsService(self)
    self.projects_locations_taxonomies = self.ProjectsLocationsTaxonomiesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class CatalogService(base_api.BaseApiService):
    """Service class for the catalog resource."""

    _NAME = 'catalog'

    def __init__(self, client):
      super(DatacatalogV1.CatalogService, self).__init__(client)
      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      r"""Searches Data Catalog for multiple resources like entries and tags that match a query. This is a [Custom Method] (https://cloud.google.com/apis/design/custom_methods) that doesn't return all information on a resource, only its ID and high level fields. To get more information, you can subsequently call specific get methods. Note: Data Catalog search queries don't guarantee full recall. Results that match your query might not be returned, even in subsequent result pages. Additionally, returned (and not returned) results can vary if you repeat search queries. For more information, see [Data Catalog search syntax] (https://cloud.google.com/data-catalog/docs/how-to/search-reference).

      Args:
        request: (GoogleCloudDatacatalogV1SearchCatalogRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1SearchCatalogResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='datacatalog.catalog.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/catalog:search',
        request_field='<request>',
        request_type_name='GoogleCloudDatacatalogV1SearchCatalogRequest',
        response_type_name='GoogleCloudDatacatalogV1SearchCatalogResponse',
        supports_download=False,
    )

  class EntriesService(base_api.BaseApiService):
    """Service class for the entries resource."""

    _NAME = 'entries'

    def __init__(self, client):
      super(DatacatalogV1.EntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Lookup(self, request, global_params=None):
      r"""Gets an entry by its target resource name. The resource name comes from the source Google Cloud Platform service.

      Args:
        request: (DatacatalogEntriesLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='datacatalog.entries.lookup',
        ordered_params=[],
        path_params=[],
        query_params=['fullyQualifiedName', 'linkedResource', 'sqlResource'],
        relative_path='v1/entries:lookup',
        request_field='',
        request_type_name='DatacatalogEntriesLookupRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsEntriesTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_entries_tags resource."""

    _NAME = 'projects_locations_entryGroups_entries_tags'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsEntriesTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag and assigns it to: * An Entry if the method name is `projects.locations.entryGroups.entries.tags.create`. * Or EntryGroupif the method name is `projects.locations.entryGroups.tags.create`. Note: The project identified by the `parent` parameter for the [tag] (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters) and the [tag template] (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters) used to create the tag must be in the same organization.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/tags',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags/{tagsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists tags assigned to an Entry. The columns in the response are lowercased.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/tags',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags/{tagsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsEntriesService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_entries resource."""

    _NAME = 'projects_locations_entryGroups_entries'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsEntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an entry. You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM', or custom types. Data Catalog automatically creates entries with other types during metadata ingestion from integrated systems. You must enable the Data Catalog API in the project identified by the `parent` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project). An entry group can have a maximum of 100,000 entries.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['entryId'],
        relative_path='v1/{+parent}/entries',
        request_field='googleCloudDatacatalogV1Entry',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing entry. You can delete only the entries created by the CreateEntry method. You must enable the Data Catalog API in the project identified by the `name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.entries.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.entries.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May return: * A`NOT_FOUND` error if the resource doesn't exist or you don't have the permission to view it. * An empty policy if the resource exists but doesn't have a set policy. Supported resources are: - Tag templates - Entry groups Note: This method doesn't get policies from Google Cloud Platform resources ingested into Data Catalog. To call this method, you must have the following Google IAM permissions: - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates. - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists entries. Note: Currently, this method can list only custom entries. To get a list of both custom and automatically created entries, use SearchCatalog.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.entries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'readMask'],
        relative_path='v1/{+parent}/entries',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListEntriesResponse',
        supports_download=False,
    )

    def ModifyEntryContacts(self, request, global_params=None):
      r"""Modifies contacts, part of the business context of an Entry. To call this method, you must have the `datacatalog.entries.updateContacts` IAM permission on the corresponding project.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryContactsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Contacts) The response message.
      """
      config = self.GetMethodConfig('ModifyEntryContacts')
      return self._RunMethod(
          config, request, global_params=global_params)

    ModifyEntryContacts.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:modifyEntryContacts',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.modifyEntryContacts',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:modifyEntryContacts',
        request_field='googleCloudDatacatalogV1ModifyEntryContactsRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryContactsRequest',
        response_type_name='GoogleCloudDatacatalogV1Contacts',
        supports_download=False,
    )

    def ModifyEntryOverview(self, request, global_params=None):
      r"""Modifies entry overview, part of the business context of an Entry. To call this method, you must have the `datacatalog.entries.updateOverview` IAM permission on the corresponding project.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryOverviewRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryOverview) The response message.
      """
      config = self.GetMethodConfig('ModifyEntryOverview')
      return self._RunMethod(
          config, request, global_params=global_params)

    ModifyEntryOverview.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:modifyEntryOverview',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.modifyEntryOverview',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:modifyEntryOverview',
        request_field='googleCloudDatacatalogV1ModifyEntryOverviewRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryOverviewRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryOverview',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing entry. You must enable the Data Catalog API in the project identified by the `entry.name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.entries.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Entry',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

    def Star(self, request, global_params=None):
      r"""Marks an Entry as starred by the current user. Starring information is private to each user.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesStarRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1StarEntryResponse) The response message.
      """
      config = self.GetMethodConfig('Star')
      return self._RunMethod(
          config, request, global_params=global_params)

    Star.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:star',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.star',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:star',
        request_field='googleCloudDatacatalogV1StarEntryRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesStarRequest',
        response_type_name='GoogleCloudDatacatalogV1StarEntryResponse',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Gets your permissions on a resource. Returns an empty set of permissions if the resource doesn't exist. Supported resources are: - Tag templates - Entry groups Note: This method gets policies only within Data Catalog and can't be used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any external Google Cloud Platform resources ingested into Data Catalog. No Google IAM permissions are required to call this method.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Unstar(self, request, global_params=None):
      r"""Marks an Entry as NOT starred by the current user. Starring information is private to each user.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesUnstarRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1UnstarEntryResponse) The response message.
      """
      config = self.GetMethodConfig('Unstar')
      return self._RunMethod(
          config, request, global_params=global_params)

    Unstar.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:unstar',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.unstar',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:unstar',
        request_field='googleCloudDatacatalogV1UnstarEntryRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesUnstarRequest',
        response_type_name='GoogleCloudDatacatalogV1UnstarEntryResponse',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_tags resource."""

    _NAME = 'projects_locations_entryGroups_tags'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag and assigns it to: * An Entry if the method name is `projects.locations.entryGroups.entries.tags.create`. * Or EntryGroupif the method name is `projects.locations.entryGroups.tags.create`. Note: The project identified by the `parent` parameter for the [tag] (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters) and the [tag template] (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters) used to create the tag must be in the same organization.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.tags.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/tags',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags/{tagsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.tags.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists tags assigned to an Entry. The columns in the response are lowercased.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.tags.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/tags',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags/{tagsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.tags.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups resource."""

    _NAME = 'projects_locations_entryGroups'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an entry group. An entry group contains logically related entries together with [Cloud Identity and Access Management](/data-catalog/docs/concepts/iam) policies. These policies specify users who can create, edit, and view entries within entry groups. Data Catalog automatically creates entry groups with names that start with the `@` symbol for the following resources: * BigQuery entries (`@bigquery`) * Pub/Sub topics (`@pubsub`) * Dataproc Metastore services (`@dataproc_metastore_{SERVICE_NAME_HASH}`) You can create your own entry groups for Cloud Storage fileset entries and custom entries together with the corresponding IAM policies. User-created entry groups can't contain the `@` symbol, it is reserved for automatically created groups. Entry groups, like entries, can be searched. A maximum of 10,000 entry groups may be created per organization across all locations. You must enable the Data Catalog API in the project identified by the `parent` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['entryGroupId'],
        relative_path='v1/{+parent}/entryGroups',
        request_field='googleCloudDatacatalogV1EntryGroup',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryGroup',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an entry group. You must enable the Data Catalog API in the project identified by the `name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an entry group.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['readMask'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsGetRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May return: * A`NOT_FOUND` error if the resource doesn't exist or you don't have the permission to view it. * An empty policy if the resource exists but doesn't have a set policy. Supported resources are: - Tag templates - Entry groups Note: This method doesn't get policies from Google Cloud Platform resources ingested into Data Catalog. To call this method, you must have the following Google IAM permissions: - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates. - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListEntryGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/entryGroups',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListEntryGroupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an entry group. You must enable the Data Catalog API in the project identified by the `entry_group.name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1EntryGroup',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryGroup',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets an access control policy for a resource. Replaces any existing policy. Supported resources are: - Tag templates - Entry groups Note: This method sets policies only within Data Catalog and can't be used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any external Google Cloud Platform resources synced with the Data Catalog. To call this method, you must have the following Google IAM permissions: - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag templates. - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:setIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Gets your permissions on a resource. Returns an empty set of permissions if the resource doesn't exist. Supported resources are: - Tag templates - Entry groups Note: This method gets policies only within Data Catalog and can't be used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any external Google Cloud Platform resources ingested into Data Catalog. No Google IAM permissions are required to call this method.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesFieldsEnumValuesService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates_fields_enumValues resource."""

    _NAME = 'projects_locations_tagTemplates_fields_enumValues'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTagTemplatesFieldsEnumValuesService, self).__init__(client)
      self._upload_configs = {
          }

    def Rename(self, request, global_params=None):
      r"""Renames an enum value in a tag template. Within a single enum field, enum values must be unique.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}/enumValues/{enumValuesId}:rename',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.fields.enumValues.rename',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:rename',
        request_field='googleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesFieldsService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates_fields resource."""

    _NAME = 'projects_locations_tagTemplates_fields'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTagTemplatesFieldsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a field in a tag template. You must enable the Data Catalog API in the project identified by the `parent` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.fields.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['tagTemplateFieldId'],
        relative_path='v1/{+parent}/fields',
        request_field='googleCloudDatacatalogV1TagTemplateField',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a field in a tag template and all uses of this field from the tags based on this template. You must enable the Data Catalog API in the project identified by the `name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.tagTemplates.fields.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a field in a tag template. You can't update the field type with this method. You must enable the Data Catalog API in the project identified by the `name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.tagTemplates.fields.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1TagTemplateField',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

    def Rename(self, request, global_params=None):
      r"""Renames a field in a tag template. You must enable the Data Catalog API in the project identified by the `name` parameter. For more information, see [Data Catalog resource project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}:rename',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.fields.rename',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:rename',
        request_field='googleCloudDatacatalogV1RenameTagTemplateFieldRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates resource."""

    _NAME = 'projects_locations_tagTemplates'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTagTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag template. You must enable the Data Catalog API in the project identified by the `parent` parameter. For more information, see [Data Catalog resource project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['tagTemplateId'],
        relative_path='v1/{+parent}/tagTemplates',
        request_field='googleCloudDatacatalogV1TagTemplate',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag template and all tags that use it. You must enable the Data Catalog API in the project identified by the `name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.tagTemplates.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a tag template.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.tagTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesGetRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May return: * A`NOT_FOUND` error if the resource doesn't exist or you don't have the permission to view it. * An empty policy if the resource exists but doesn't have a set policy. Supported resources are: - Tag templates - Entry groups Note: This method doesn't get policies from Google Cloud Platform resources ingested into Data Catalog. To call this method, you must have the following Google IAM permissions: - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates. - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a tag template. You can't update template fields with this method. These fields are separate resources with their own create, update, and delete methods. You must enable the Data Catalog API in the project identified by the `tag_template.name` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.tagTemplates.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1TagTemplate',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplate',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets an access control policy for a resource. Replaces any existing policy. Supported resources are: - Tag templates - Entry groups Note: This method sets policies only within Data Catalog and can't be used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any external Google Cloud Platform resources synced with the Data Catalog. To call this method, you must have the following Google IAM permissions: - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag templates. - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:setIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Gets your permissions on a resource. Returns an empty set of permissions if the resource doesn't exist. Supported resources are: - Tag templates - Entry groups Note: This method gets policies only within Data Catalog and can't be used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any external Google Cloud Platform resources ingested into Data Catalog. No Google IAM permissions are required to call this method.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTaxonomiesPolicyTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_taxonomies_policyTags resource."""

    _NAME = 'projects_locations_taxonomies_policyTags'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTaxonomiesPolicyTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy tag in a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1PolicyTag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/policyTags',
        request_field='googleCloudDatacatalogV1PolicyTag',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1PolicyTag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy tag together with the following: * All of its descendant policy tags, if any * Policies associated with the policy tag and its descendants * References from BigQuery table schema of the policy tag and its descendants.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1PolicyTag) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest',
        response_type_name='GoogleCloudDatacatalogV1PolicyTag',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for a policy tag or a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all policy tags in a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListPolicyTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags',
        http_method='GET',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/policyTags',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListPolicyTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy tag, including its display name, description, and parent policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1PolicyTag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1PolicyTag',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1PolicyTag',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for a policy tag or a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}:setIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns your permissions on a specified policy tag or taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.policyTags.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTaxonomiesService(base_api.BaseApiService):
    """Service class for the projects_locations_taxonomies resource."""

    _NAME = 'projects_locations_taxonomies'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a taxonomy in a specified project. The taxonomy is initially empty, that is, it doesn't contain policy tags.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/taxonomies',
        request_field='googleCloudDatacatalogV1Taxonomy',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Taxonomy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a taxonomy, including all policy tags in this taxonomy, their associated policies, and the policy tags references from BigQuery columns.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.taxonomies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports taxonomies in the requested type and returns them, including their policy tags. The requested taxonomies must belong to the same project. This method generates `SerializedTaxonomy` protocol buffers with nested policy tags that can be used as input for `ImportTaxonomies` calls.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ExportTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies:export',
        http_method='GET',
        method_id='datacatalog.projects.locations.taxonomies.export',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['serializedTaxonomies', 'taxonomies'],
        relative_path='v1/{+parent}/taxonomies:export',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesExportRequest',
        response_type_name='GoogleCloudDatacatalogV1ExportTaxonomiesResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.taxonomies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesGetRequest',
        response_type_name='GoogleCloudDatacatalogV1Taxonomy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for a policy tag or a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Creates new taxonomies (including their policy tags) in a given project by importing from inlined or cross-regional sources. For a cross-regional source, new taxonomies are created by copying from a source in another region. For an inlined source, taxonomies and policy tags are created in bulk using nested protocol buffer structures.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ImportTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies:import',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.import',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/taxonomies:import',
        request_field='googleCloudDatacatalogV1ImportTaxonomiesRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesImportRequest',
        response_type_name='GoogleCloudDatacatalogV1ImportTaxonomiesResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all taxonomies in a project in a particular location that you have a permission to view.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies',
        http_method='GET',
        method_id='datacatalog.projects.locations.taxonomies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/taxonomies',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListTaxonomiesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a taxonomy, including its display name, description, and activated policy types.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.taxonomies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Taxonomy',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Taxonomy',
        supports_download=False,
    )

    def Replace(self, request, global_params=None):
      r"""Replaces (updates) a taxonomy and all its policy tags. The taxonomy and its entire hierarchy of policy tags must be represented literally by `SerializedTaxonomy` and the nested `SerializedPolicyTag` messages. This operation automatically does the following: - Deletes the existing policy tags that are missing from the `SerializedPolicyTag`. - Creates policy tags that don't have resource names. They are considered new. - Updates policy tags with valid resources names accordingly.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesReplaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Replace')
      return self._RunMethod(
          config, request, global_params=global_params)

    Replace.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:replace',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.replace',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:replace',
        request_field='googleCloudDatacatalogV1ReplaceTaxonomyRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesReplaceRequest',
        response_type_name='GoogleCloudDatacatalogV1Taxonomy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for a policy tag or a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:setIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns your permissions on a specified policy tag or taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.taxonomies.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def ExportMetadata(self, request, global_params=None):
      r"""Exports all tags and their respective entries under a given project and location to an existing Cloud Storage bucket. You must have permission to publish in Pub/Sub to a given topic. See ExportMetadataRequest.

      Args:
        request: (DatacatalogProjectsLocationsExportMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ExportMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExportMetadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}:exportMetadata',
        http_method='POST',
        method_id='datacatalog.projects.locations.exportMetadata',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:exportMetadata',
        request_field='googleCloudDatacatalogV1ExportMetadataRequest',
        request_type_name='DatacatalogProjectsLocationsExportMetadataRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
