/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.TextLayout;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaPainter;

public class CompositionTextPainter {
    private TextLayout composedTextLayout;
    private int composedBeginCaretPosition = 0;
    private JEditTextArea textArea;

    public CompositionTextPainter(JEditTextArea textArea) {
        this.textArea = textArea;
        this.composedTextLayout = null;
    }

    public boolean hasComposedTextLayout() {
        return this.composedTextLayout != null;
    }

    public void setComposedTextLayout(TextLayout composedTextLayout, int composedStartCaretPosition) {
        this.composedTextLayout = composedTextLayout;
        this.composedBeginCaretPosition = composedStartCaretPosition;
    }

    public void invalidateComposedTextLayout(int composedEndCaretPosition) {
        this.composedTextLayout = null;
        this.composedBeginCaretPosition = composedEndCaretPosition;
    }

    public void draw(Graphics gfx, Color fillBackGroundColor) {
        assert (this.composedTextLayout != null);
        Point composedLoc = this.getCaretLocation();
        this.refillComposedArea(fillBackGroundColor, composedLoc.x, composedLoc.y);
        this.composedTextLayout.draw((Graphics2D)gfx, composedLoc.x, composedLoc.y);
    }

    private void refillComposedArea(Color fillColor, int x, int y) {
        Graphics gfx = this.textArea.getPainter().getGraphics();
        gfx.setColor(fillColor);
        FontMetrics fm = this.textArea.getPainter().getFontMetrics();
        int newY = y - (fm.getHeight() - 5);
        int paintHeight = fm.getHeight();
        int paintWidth = (int)this.composedTextLayout.getBounds().getWidth();
        gfx.fillRect(x, newY, paintWidth, paintHeight);
    }

    private Point getCaretLocation() {
        Point loc = new Point();
        TextAreaPainter painter = this.textArea.getPainter();
        FontMetrics fm = painter.getFontMetrics();
        int offsetY = fm.getHeight() - 5;
        int lineIndex = this.textArea.getCaretLine();
        loc.y = lineIndex * fm.getHeight() + offsetY;
        int offsetX = this.composedBeginCaretPosition - this.textArea.getLineStartOffset(lineIndex);
        loc.x = this.textArea.offsetToX(lineIndex, offsetX);
        return loc;
    }
}

