/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.utilities;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.StandardComparator;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.utilities.Predicate;
import com.google.firebase.database.snapshot.ChildKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ImmutableTree<T>
implements Iterable<Map.Entry<Path, T>> {
    private static final ImmutableSortedMap EMPTY_CHILDREN = ImmutableSortedMap.Builder.emptyMap(StandardComparator.getComparator(ChildKey.class));
    private static final ImmutableTree EMPTY = new ImmutableTree<Object>(null, EMPTY_CHILDREN);
    private final T value;
    private final ImmutableSortedMap<ChildKey, ImmutableTree<T>> children;

    public ImmutableTree(T value, ImmutableSortedMap<ChildKey, ImmutableTree<T>> children) {
        this.value = value;
        this.children = children;
    }

    public ImmutableTree(T value) {
        this(value, EMPTY_CHILDREN);
    }

    public static <V> ImmutableTree<V> emptyInstance() {
        return EMPTY;
    }

    public T getValue() {
        return this.value;
    }

    public ImmutableSortedMap<ChildKey, ImmutableTree<T>> getChildren() {
        return this.children;
    }

    public boolean isEmpty() {
        return this.value == null && this.children.isEmpty();
    }

    public Path findRootMostMatchingPath(Path relativePath, Predicate<? super T> predicate) {
        if (this.value != null && predicate.evaluate(this.value)) {
            return Path.getEmptyPath();
        }
        if (relativePath.isEmpty()) {
            return null;
        }
        ChildKey front = relativePath.getFront();
        ImmutableTree<T> child = this.children.get(front);
        if (child != null) {
            Path path = child.findRootMostMatchingPath(relativePath.popFront(), predicate);
            if (path != null) {
                return new Path(front).child(path);
            }
            return null;
        }
        return null;
    }

    public Path findRootMostPathWithValue(Path relativePath) {
        return this.findRootMostMatchingPath(relativePath, Predicate.TRUE);
    }

    public T rootMostValue(Path relativePath) {
        return (T)this.rootMostValueMatching(relativePath, Predicate.TRUE);
    }

    public T rootMostValueMatching(Path relativePath, Predicate<? super T> predicate) {
        if (this.value != null && predicate.evaluate(this.value)) {
            return this.value;
        }
        ImmutableTree<T> currentTree = this;
        for (ChildKey key : relativePath) {
            currentTree = currentTree.children.get(key);
            if (currentTree == null) {
                return null;
            }
            if (currentTree.value == null || !predicate.evaluate(currentTree.value)) continue;
            return currentTree.value;
        }
        return null;
    }

    public T leafMostValue(Path relativePath) {
        return (T)this.leafMostValueMatching(relativePath, Predicate.TRUE);
    }

    public T leafMostValueMatching(Path path, Predicate<? super T> predicate) {
        T currentValue = this.value != null && predicate.evaluate(this.value) ? (T)this.value : null;
        ImmutableTree<T> currentTree = this;
        for (ChildKey key : path) {
            currentTree = currentTree.children.get(key);
            if (currentTree == null) {
                return currentValue;
            }
            if (currentTree.value == null || !predicate.evaluate(currentTree.value)) continue;
            currentValue = currentTree.value;
        }
        return currentValue;
    }

    public boolean containsMatchingValue(Predicate<? super T> predicate) {
        if (this.value != null && predicate.evaluate(this.value)) {
            return true;
        }
        for (Map.Entry<ChildKey, ImmutableTree<T>> entry : this.children) {
            if (!entry.getValue().containsMatchingValue(predicate)) continue;
            return true;
        }
        return false;
    }

    public ImmutableTree<T> getChild(ChildKey child) {
        ImmutableTree<T> childTree = this.children.get(child);
        if (childTree != null) {
            return childTree;
        }
        return ImmutableTree.emptyInstance();
    }

    public ImmutableTree<T> subtree(Path relativePath) {
        if (relativePath.isEmpty()) {
            return this;
        }
        ChildKey front = relativePath.getFront();
        ImmutableTree<T> childTree = this.children.get(front);
        if (childTree != null) {
            return childTree.subtree(relativePath.popFront());
        }
        return ImmutableTree.emptyInstance();
    }

    public ImmutableTree<T> set(Path relativePath, T value) {
        if (relativePath.isEmpty()) {
            return new ImmutableTree<T>(value, this.children);
        }
        ChildKey front = relativePath.getFront();
        ImmutableTree<Object> child = this.children.get(front);
        if (child == null) {
            child = ImmutableTree.emptyInstance();
        }
        ImmutableTree<T> newChild = child.set(relativePath.popFront(), value);
        ImmutableSortedMap<ChildKey, ImmutableTree<T>> newChildren = this.children.insert(front, newChild);
        return new ImmutableTree<T>(this.value, newChildren);
    }

    public ImmutableTree<T> remove(Path relativePath) {
        if (relativePath.isEmpty()) {
            if (this.children.isEmpty()) {
                return ImmutableTree.emptyInstance();
            }
            return new ImmutableTree<Object>(null, this.children);
        }
        ChildKey front = relativePath.getFront();
        ImmutableTree<T> child = this.children.get(front);
        if (child != null) {
            ImmutableTree<T> newChild = child.remove(relativePath.popFront());
            ImmutableSortedMap<ChildKey, ImmutableTree<T>> newChildren = newChild.isEmpty() ? this.children.remove(front) : this.children.insert(front, newChild);
            if (this.value == null && newChildren.isEmpty()) {
                return ImmutableTree.emptyInstance();
            }
            return new ImmutableTree<T>(this.value, newChildren);
        }
        return this;
    }

    public T get(Path relativePath) {
        if (relativePath.isEmpty()) {
            return this.value;
        }
        ChildKey front = relativePath.getFront();
        ImmutableTree<T> child = this.children.get(front);
        if (child != null) {
            return child.get(relativePath.popFront());
        }
        return null;
    }

    public ImmutableTree<T> setTree(Path relativePath, ImmutableTree<T> newTree) {
        ImmutableTree<T> newChild;
        if (relativePath.isEmpty()) {
            return newTree;
        }
        ChildKey front = relativePath.getFront();
        ImmutableTree<Object> child = this.children.get(front);
        if (child == null) {
            child = ImmutableTree.emptyInstance();
        }
        ImmutableSortedMap<ChildKey, ImmutableTree<T>> newChildren = (newChild = child.setTree(relativePath.popFront(), newTree)).isEmpty() ? this.children.remove(front) : this.children.insert(front, newChild);
        return new ImmutableTree<T>(this.value, newChildren);
    }

    public void foreach(TreeVisitor<T, Void> visitor) {
        this.fold(Path.getEmptyPath(), visitor, null);
    }

    public <R> R fold(R accum, TreeVisitor<? super T, R> visitor) {
        return this.fold(Path.getEmptyPath(), visitor, accum);
    }

    private <R> R fold(Path relativePath, TreeVisitor<? super T, R> visitor, R accum) {
        for (Map.Entry<ChildKey, ImmutableTree<T>> entry : this.children) {
            accum = super.fold(relativePath.child(entry.getKey()), visitor, accum);
        }
        if (this.value != null) {
            accum = visitor.onNodeValue(relativePath, this.value, accum);
        }
        return accum;
    }

    public Collection<T> values() {
        final ArrayList list = new ArrayList();
        this.foreach(new TreeVisitor<T, Void>(){

            @Override
            public Void onNodeValue(Path relativePath, T value, Void accum) {
                list.add(value);
                return null;
            }
        });
        return list;
    }

    @Override
    public Iterator<Map.Entry<Path, T>> iterator() {
        final ArrayList list = new ArrayList();
        this.foreach(new TreeVisitor<T, Void>(){

            @Override
            public Void onNodeValue(Path relativePath, T value, Void accum) {
                list.add(new AbstractMap.SimpleImmutableEntry(relativePath, value));
                return null;
            }
        });
        return list.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImmutableTree { value=");
        builder.append(this.getValue());
        builder.append(", children={");
        for (Map.Entry<ChildKey, ImmutableTree<T>> entry : this.children) {
            builder.append(entry.getKey().asString());
            builder.append("=");
            builder.append(entry.getValue());
        }
        builder.append("} }");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTree that = (ImmutableTree)o;
        if (this.children != null ? !this.children.equals(that.children) : that.children != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public static interface TreeVisitor<T, R> {
        public R onNodeValue(Path var1, T var2, R var3);
    }
}

