/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastService;
import org.traccar.config.Config;
import org.traccar.model.Attribute;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.Maintenance;
import org.traccar.model.Notification;
import org.traccar.model.Position;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.session.cache.CacheKey;
import org.traccar.session.cache.CacheValue;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class CacheManager
implements BroadcastInterface {
    private static final int GROUP_DEPTH_LIMIT = 3;
    private static final Collection<Class<? extends BaseModel>> CLASSES = Arrays.asList(Attribute.class, Driver.class, Geofence.class, Maintenance.class, Notification.class);
    private final Config config;
    private final Storage storage;
    private final BroadcastService broadcastService;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<CacheKey, CacheValue> deviceCache = new HashMap<CacheKey, CacheValue>();
    private final Map<Long, Integer> deviceReferences = new HashMap<Long, Integer>();
    private final Map<Long, Map<Class<? extends BaseModel>, Set<Long>>> deviceLinks = new HashMap<Long, Map<Class<? extends BaseModel>, Set<Long>>>();
    private final Map<Long, Position> devicePositions = new HashMap<Long, Position>();
    private Server server;
    private final Map<Long, List<User>> notificationUsers = new HashMap<Long, List<User>>();

    @Inject
    public CacheManager(Config config, Storage storage, BroadcastService broadcastService) throws StorageException {
        this.config = config;
        this.storage = storage;
        this.broadcastService = broadcastService;
        this.invalidateServer();
        this.invalidateUsers();
        broadcastService.registerListener(this);
    }

    public Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> T getObject(Class<T> clazz, long id) {
        try {
            this.lock.readLock().lock();
            CacheValue cacheValue = this.deviceCache.get(new CacheKey(clazz, id));
            T t = cacheValue != null ? (T)cacheValue.getValue() : null;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> List<T> getDeviceObjects(long deviceId, Class<T> clazz) {
        try {
            this.lock.readLock().lock();
            List list = this.deviceLinks.get(deviceId).get(clazz).stream().map(id -> this.deviceCache.get(new CacheKey(clazz, (long)id)).getValue()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position getPosition(long deviceId) {
        try {
            this.lock.readLock().lock();
            Position position = this.devicePositions.get(deviceId);
            return position;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Server getServer() {
        try {
            this.lock.readLock().lock();
            Server server = this.server;
            return server;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getNotificationUsers(long notificationId, long deviceId) {
        try {
            this.lock.readLock().lock();
            Set users = this.deviceLinks.get(deviceId).get(User.class).stream().collect(Collectors.toUnmodifiableSet());
            List<User> list = this.notificationUsers.get(notificationId).stream().filter(user -> users.contains(user.getId())).collect(Collectors.toUnmodifiableList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Driver findDriverByUniqueId(long deviceId, String driverUniqueId) {
        return this.getDeviceObjects(deviceId, Driver.class).stream().filter(driver -> driver.getUniqueId().equals(driverUniqueId)).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(long deviceId) throws StorageException {
        try {
            this.lock.writeLock().lock();
            Integer references = this.deviceReferences.get(deviceId);
            if (references != null) {
                references = references + 1;
            } else {
                this.unsafeAddDevice(deviceId);
                references = 1;
            }
            this.deviceReferences.put(deviceId, references);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDevice(long deviceId) {
        try {
            this.lock.writeLock().lock();
            Integer references = this.deviceReferences.get(deviceId);
            if (references != null) {
                if ((references = Integer.valueOf(references - 1)) <= 0) {
                    this.unsafeRemoveDevice(deviceId);
                    this.deviceReferences.remove(deviceId);
                } else {
                    this.deviceReferences.put(deviceId, references);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updatePosition(Position position) {
        try {
            this.lock.writeLock().lock();
            if (this.deviceLinks.containsKey(position.getDeviceId())) {
                this.devicePositions.put(position.getDeviceId(), position);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void invalidateObject(boolean local, Class<? extends BaseModel> clazz, long id) {
        try {
            BaseModel object = this.storage.getObject(clazz, new Request(new Columns.All(), new Condition.Equals("id", "id", id)));
            if (object != null) {
                this.updateOrInvalidate(local, object);
            } else {
                this.invalidate(clazz, id);
            }
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> void updateOrInvalidate(boolean local, T object) throws StorageException {
        if (local) {
            this.broadcastService.invalidateObject(true, object.getClass(), object.getId());
        }
        boolean invalidate = false;
        Object before = this.getObject(object.getClass(), object.getId());
        if (before == null) {
            return;
        }
        if (object instanceof GroupedModel && ((GroupedModel)before).getGroupId() != ((GroupedModel)object).getGroupId()) {
            invalidate = true;
        }
        if (invalidate) {
            this.invalidate(object.getClass(), object.getId());
        } else {
            try {
                this.lock.writeLock().lock();
                this.deviceCache.get(new CacheKey(object.getClass(), object.getId())).setValue(object);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public <T extends BaseModel> void invalidate(Class<T> clazz, long id) throws StorageException {
        this.invalidate(new CacheKey(clazz, id));
    }

    @Override
    public void invalidatePermission(boolean local, Class<? extends BaseModel> clazz1, long id1, Class<? extends BaseModel> clazz2, long id2) {
        if (local) {
            this.broadcastService.invalidatePermission(true, clazz1, id1, clazz2, id2);
        }
        try {
            this.invalidate(new CacheKey(clazz1, id1), new CacheKey(clazz2, id2));
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    private void invalidateServer() throws StorageException {
        this.server = this.storage.getObject(Server.class, new Request(new Columns.All()));
    }

    private void invalidateUsers() throws StorageException {
        this.notificationUsers.clear();
        HashMap users = new HashMap();
        this.storage.getObjects(User.class, new Request(new Columns.All())).forEach(user -> users.put(user.getId(), user));
        this.storage.getPermissions(User.class, Notification.class).forEach(permission -> {
            long notificationId = permission.getPropertyId();
            User user = (User)users.get(permission.getOwnerId());
            this.notificationUsers.computeIfAbsent(notificationId, k -> new LinkedList()).add(user);
        });
    }

    private void addObject(long deviceId, BaseModel object) {
        this.deviceCache.computeIfAbsent(new CacheKey(object), k -> new CacheValue(object)).retain(deviceId);
    }

    private void unsafeAddDevice(long deviceId) throws StorageException {
        HashMap links = new HashMap();
        Device device = this.storage.getObject(Device.class, new Request(new Columns.All(), new Condition.Equals("id", "id", deviceId)));
        if (device != null) {
            this.addObject(deviceId, device);
            long groupId = device.getGroupId();
            for (int groupDepth = 0; groupDepth < 3 && groupId > 0L; ++groupDepth) {
                Group group = this.storage.getObject(Group.class, new Request(new Columns.All(), new Condition.Equals("id", "id", groupId)));
                links.computeIfAbsent(Group.class, k -> new LinkedHashSet()).add(group.getId());
                this.addObject(deviceId, group);
                groupId = group.getGroupId();
            }
            for (Class<? extends BaseModel> clazz : CLASSES) {
                List<? extends BaseModel> objects = this.storage.getObjects(clazz, new Request(new Columns.All(), new Condition.Permission(Device.class, deviceId, clazz)));
                links.put(clazz, objects.stream().map(BaseModel::getId).collect(Collectors.toSet()));
                objects.forEach(object -> this.addObject(deviceId, (BaseModel)object));
            }
            List<User> users = this.storage.getObjects(User.class, new Request(new Columns.All(), new Condition.Permission(User.class, Device.class, deviceId)));
            links.put(User.class, users.stream().map(BaseModel::getId).collect(Collectors.toSet()));
            for (User user : users) {
                this.addObject(deviceId, user);
                List<Notification> notifications = this.storage.getObjects(Notification.class, new Request(new Columns.All(), new Condition.Permission(User.class, user.getId(), Notification.class)));
                notifications.stream().filter(Notification::getAlways).forEach(object -> {
                    links.computeIfAbsent(Notification.class, k -> new LinkedHashSet()).add(object.getId());
                    this.addObject(deviceId, (BaseModel)object);
                });
            }
            this.deviceLinks.put(deviceId, links);
            if (device.getPositionId() > 0L) {
                this.devicePositions.put(deviceId, this.storage.getObject(Position.class, new Request(new Columns.All(), new Condition.Equals("id", "id", device.getPositionId()))));
            }
        }
    }

    private void unsafeRemoveDevice(long deviceId) {
        this.deviceCache.remove(new CacheKey(Device.class, deviceId));
        this.deviceLinks.remove(deviceId).forEach((clazz, ids) -> ids.forEach(id -> {
            CacheKey key = new CacheKey((Class<? extends BaseModel>)clazz, (long)id);
            this.deviceCache.computeIfPresent(key, (k, value) -> {
                value.release(deviceId);
                return value.getReferences().size() > 0 ? value : null;
            });
        }));
        this.devicePositions.remove(deviceId);
    }

    private void invalidate(CacheKey ... keys) throws StorageException {
        try {
            this.lock.writeLock().lock();
            this.unsafeInvalidate(keys);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void unsafeInvalidate(CacheKey[] keys) throws StorageException {
        boolean invalidateServer = false;
        boolean invalidateUsers = false;
        HashSet linkedDevices = new HashSet();
        for (CacheKey key : keys) {
            if (key.classIs(Server.class)) {
                invalidateServer = true;
                continue;
            }
            if (key.classIs(User.class) || key.classIs(Notification.class)) {
                invalidateUsers = true;
            }
            this.deviceCache.computeIfPresent(key, (k, value) -> {
                linkedDevices.addAll(value.getReferences());
                return value;
            });
        }
        Iterator iterator = linkedDevices.iterator();
        while (iterator.hasNext()) {
            long deviceId = (Long)iterator.next();
            this.unsafeRemoveDevice(deviceId);
            this.unsafeAddDevice(deviceId);
        }
        if (invalidateServer) {
            this.invalidateServer();
        }
        if (invalidateUsers) {
            this.invalidateUsers();
        }
    }
}

