/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.traccar.mail.MailManager;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

public class NotificatorMail
implements Notificator {
    private final MailManager mailManager;
    private final NotificationFormatter notificationFormatter;

    @Inject
    public NotificatorMail(MailManager mailManager, NotificationFormatter notificationFormatter) {
        this.mailManager = mailManager;
        this.notificationFormatter = notificationFormatter;
    }

    @Override
    public void send(User user, Event event, Position position) throws MessageException {
        try {
            NotificationMessage fullMessage = this.notificationFormatter.formatMessage(user, event, position, "full");
            this.mailManager.sendMessage(user, fullMessage.getSubject(), fullMessage.getBody());
        }
        catch (MessagingException e) {
            throw new MessageException(e);
        }
    }
}

