/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.name.Named;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.config.ConfigKey;
import org.traccar.helper.Log;

@Singleton
public class Config {
    private final Properties properties = new Properties();
    private boolean useEnvironmentVariables;

    public Config() {
    }

    @Inject
    public Config(@Named(value="configFile") String file) throws IOException {
        try {
            Properties mainProperties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(file);){
                mainProperties.loadFromXML(inputStream);
            }
            String defaultConfigFile = mainProperties.getProperty("config.default");
            if (defaultConfigFile != null) {
                try (FileInputStream inputStream = new FileInputStream(defaultConfigFile);){
                    this.properties.loadFromXML(inputStream);
                }
            }
            this.properties.putAll((Map<?, ?>)mainProperties);
            this.useEnvironmentVariables = Boolean.parseBoolean(System.getenv("CONFIG_USE_ENVIRONMENT_VARIABLES")) || Boolean.parseBoolean(this.properties.getProperty("config.useEnvironmentVariables"));
            Log.setupLogger(this);
        }
        catch (InvalidPropertiesFormatException e) {
            Log.setupDefaultLogger();
            throw new RuntimeException("Configuration file is not a valid XML document", e);
        }
        catch (Exception e) {
            Log.setupDefaultLogger();
            throw e;
        }
    }

    public boolean hasKey(ConfigKey<?> key) {
        return this.hasKey(key.getKey());
    }

    private boolean hasKey(String key) {
        return this.useEnvironmentVariables && System.getenv().containsKey(Config.getEnvironmentVariableName(key)) || this.properties.containsKey(key);
    }

    public String getString(ConfigKey<String> key) {
        return this.getString(key.getKey(), key.getDefaultValue());
    }

    @Deprecated
    public String getString(String key) {
        String value;
        if (this.useEnvironmentVariables && (value = System.getenv(Config.getEnvironmentVariableName(key))) != null && !value.isEmpty()) {
            return value;
        }
        return this.properties.getProperty(key);
    }

    public String getString(ConfigKey<String> key, String defaultValue) {
        return this.getString(key.getKey(), defaultValue);
    }

    @Deprecated
    public String getString(String key, String defaultValue) {
        return this.hasKey(key) ? this.getString(key) : defaultValue;
    }

    public boolean getBoolean(ConfigKey<Boolean> key) {
        return Boolean.parseBoolean(this.getString(key.getKey()));
    }

    public int getInteger(ConfigKey<Integer> key) {
        String value = this.getString(key.getKey());
        if (value != null) {
            return Integer.parseInt(value);
        }
        Integer defaultValue = key.getDefaultValue();
        return Objects.requireNonNullElse(defaultValue, 0);
    }

    public int getInteger(ConfigKey<Integer> key, int defaultValue) {
        return this.getInteger(key.getKey(), defaultValue);
    }

    @Deprecated
    public int getInteger(String key, int defaultValue) {
        return this.hasKey(key) ? Integer.parseInt(this.getString(key)) : defaultValue;
    }

    public long getLong(ConfigKey<Long> key) {
        String value = this.getString(key.getKey());
        if (value != null) {
            return Long.parseLong(value);
        }
        Long defaultValue = key.getDefaultValue();
        return Objects.requireNonNullElse(defaultValue, 0L);
    }

    public double getDouble(ConfigKey<Double> key) {
        String value = this.getString(key.getKey());
        if (value != null) {
            return Double.parseDouble(value);
        }
        Double defaultValue = key.getDefaultValue();
        return Objects.requireNonNullElse(defaultValue, 0.0);
    }

    @VisibleForTesting
    public void setString(ConfigKey<?> key, String value) {
        this.properties.put(key.getKey(), value);
    }

    static String getEnvironmentVariableName(String key) {
        return key.replaceAll("\\.", "_").replaceAll("(\\p{Lu})", "_$1").toUpperCase();
    }
}

