/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemBufferedChExtensionsAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElements(value={@XmlElement(type=ExtensionType.class, name="type")})
    private List<ExtensionType> removeExtensions = new ArrayList<ExtensionType>();

    public RemBufferedChExtensionsAction() {
    }

    public RemBufferedChExtensionsAction(String alias) {
        this.connectionAlias = alias;
    }

    public RemBufferedChExtensionsAction(List<ExtensionType> removeExtensions) {
        this.removeExtensions = removeExtensions;
    }

    public RemBufferedChExtensionsAction(ExtensionType ... removeExtensions) {
        this(new ArrayList<ExtensionType>(Arrays.asList(removeExtensions)));
    }

    public RemBufferedChExtensionsAction(String alias, List<ExtensionType> removeExtensions) {
        super(alias);
        this.removeExtensions = removeExtensions;
    }

    public RemBufferedChExtensionsAction(String alias, ExtensionType ... removeExtensions) {
        super(alias);
        this.removeExtensions = new ArrayList<ExtensionType>(Arrays.asList(removeExtensions));
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext ctx = state.getTlsContext(this.connectionAlias);
        ClientHelloMessage ch = (ClientHelloMessage)ctx.getMessageBuffer().getFirst();
        this.removeExtensions(ctx, ch);
        this.setExecuted(true);
    }

    private void removeExtensions(TlsContext ctx, ClientHelloMessage ch) {
        if (ch.getExtensions() == null) {
            return;
        }
        List<ExtensionMessage> extensions = ch.getExtensions();
        ArrayList<ExtensionMessage> markedForRemoval = new ArrayList<ExtensionMessage>();
        ByteArrayOutputStream newExtensionBytes = new ByteArrayOutputStream();
        String msg_name = ch.toCompactString();
        int msgLength = (Integer)ch.getLength().getValue();
        int origExtLength = ((byte[])ch.getExtensionBytes().getValue()).length;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Original extensions in " + msg_name + ":\n" + this.summarizeExtensions(ch));
        }
        for (ExtensionMessage ext : extensions) {
            try {
                ExtensionType type = ext.getExtensionTypeConstant();
                if (this.removeExtensions.contains((Object)type)) {
                    LOGGER.debug("Removing " + (Object)((Object)type) + " extensions from " + msg_name);
                    markedForRemoval.add(ext);
                    continue;
                }
                newExtensionBytes.write((byte[])ext.getExtensionBytes().getValue());
            }
            catch (IOException ex) {
                throw new WorkflowExecutionException("Could not write ExtensionBytes to byte[]", ex);
            }
        }
        ch.setExtensionBytes(newExtensionBytes.toByteArray());
        extensions.removeAll(markedForRemoval);
        int newExtLength = ((byte[])ch.getExtensionBytes().getValue()).length;
        int diffExtLength = origExtLength - newExtLength;
        ch.setLength(msgLength - diffExtLength);
        ch.setExtensionsLength(newExtLength);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Modified extensions in " + msg_name + ":\n" + this.summarizeExtensions(ch));
        }
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    public List<ExtensionType> getRemoveExtensions() {
        return this.removeExtensions;
    }

    public void setRemoveExtensions(List<ExtensionType> removeExtensions) {
        this.removeExtensions = removeExtensions;
    }

    public void setRemoveExtensions(ExtensionType ... removeExtensions) {
        this.removeExtensions = new ArrayList<ExtensionType>(Arrays.asList(removeExtensions));
    }

    public String summarizeExtensions(ClientHelloMessage ch) {
        StringBuilder sb = new StringBuilder();
        sb.append("message length: ").append(ch.getLength().getValue());
        sb.append("\nextension bytes length: ").append(((byte[])ch.getExtensionBytes().getValue()).length);
        sb.append("\nextension bytes:");
        sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])ch.getExtensionBytes().getValue())));
        sb.append("\nreadable extension list:\n");
        for (ExtensionMessage ext : ch.getExtensions()) {
            sb.append((Object)ext.getExtensionTypeConstant());
            sb.append(" (").append(ext.getExtensionBytes().toString()).append(")\n");
        }
        return sb.toString();
    }

    @Override
    public void normalize() {
        super.normalize();
        this.initEmptyLists();
    }

    @Override
    public void normalize(TlsAction defaultAction) {
        super.normalize(defaultAction);
        this.initEmptyLists();
    }

    @Override
    public void filter() {
        super.filter();
        this.stripEmptyLists();
    }

    @Override
    public void filter(TlsAction defaultAction) {
        super.filter(defaultAction);
        this.stripEmptyLists();
    }

    private void stripEmptyLists() {
        if (this.removeExtensions == null || this.removeExtensions.isEmpty()) {
            this.removeExtensions = null;
        }
    }

    private void initEmptyLists() {
        if (this.removeExtensions == null) {
            this.removeExtensions = new ArrayList<ExtensionType>();
        }
        if (this.removeExtensions == null) {
            this.removeExtensions = new ArrayList<ExtensionType>();
        }
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 19 * hash + Objects.hashCode(this.removeExtensions);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemBufferedChExtensionsAction other = (RemBufferedChExtensionsAction)obj;
        if (!Objects.equals(this.removeExtensions, other.removeExtensions)) {
            return false;
        }
        return super.equals(obj);
    }
}

