/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Parser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private int pointer;
    private final byte[] array;
    private final int startPoint;

    public Parser(int startposition, byte[] array) {
        this.startPoint = startposition;
        this.pointer = startposition;
        this.array = array;
        if (startposition > array.length) {
            throw new ParserException("Cannot creater parser beyond pointer. Pointer:" + this.pointer + " ArrayLength:" + array.length);
        }
    }

    protected byte[] parseByteArrayField(int length) {
        if (length == 0) {
            return new byte[0];
        }
        if (length < 0) {
            throw new ParserException("Cannot parse field of size " + length);
        }
        int nextPointer = this.pointer + length;
        if (!this.enoughBytesLeft(length)) {
            throw new ParserException("Parsing over the end of the array. Current Pointer:" + this.pointer + " ToParse Length:" + length + " ArrayLength:" + this.array.length);
        }
        byte[] result = Arrays.copyOfRange(this.array, this.pointer, nextPointer);
        this.pointer = nextPointer;
        return result;
    }

    protected int parseIntField(int length) {
        if (length == 0) {
            throw new ParserException("Cannot parse int of size 0");
        }
        return ArrayConverter.bytesToInt((byte[])this.parseByteArrayField(length));
    }

    protected BigInteger parseBigIntField(int length) {
        if (length == 0) {
            throw new ParserException("Cannot parse BigInt of size 0");
        }
        return new BigInteger(1, this.parseByteArrayField(length));
    }

    protected byte parseByteField(int length) {
        if (length == 0) {
            throw new ParserException("Cannot parse byte of size 0");
        }
        if (length > 1) {
            LOGGER.warn("Parsing byte[] field into a byte of size >1");
        }
        return (byte)ArrayConverter.bytesToInt((byte[])this.parseByteArrayField(length));
    }

    protected String parseStringTill(byte endSequence) {
        byte b;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        do {
            b = this.parseByteField(1);
            stream.write(b);
        } while (b != endSequence);
        return new String(stream.toByteArray());
    }

    protected byte peek() {
        if (this.pointer < this.array.length) {
            return this.array[this.pointer];
        }
        throw new ParserException("Cannot peek, would peek over the end ot the array");
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        this.pointer = pointer;
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    protected byte[] getAlreadyParsed() {
        return Arrays.copyOfRange(this.array, this.startPoint, this.pointer);
    }

    protected boolean enoughBytesLeft(int count) {
        return this.getBytesLeft() >= count;
    }

    protected byte[] parseArrayOrTillEnd(int n) {
        if (n >= 0 && n < this.getBytesLeft()) {
            return this.parseByteArrayField(n);
        }
        return this.parseByteArrayField(this.getBytesLeft());
    }

    protected int getBytesLeft() {
        return this.array.length - this.pointer;
    }

    public abstract T parse();
}

