/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.Licensing;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.builders.StartDirBuilder;
import org.eclipse.jetty.start.builders.StartIniBuilder;
import org.eclipse.jetty.start.fileinits.BaseHomeFileInitializer;
import org.eclipse.jetty.start.fileinits.LocalFileInitializer;
import org.eclipse.jetty.start.fileinits.MavenLocalRepoFileInitializer;
import org.eclipse.jetty.start.fileinits.TestFileInitializer;
import org.eclipse.jetty.start.fileinits.UriFileInitializer;

public class BaseBuilder {
    private static final String EXITING_LICENSE_NOT_ACKNOWLEDGED = "Exiting: license not acknowledged!";
    private final BaseHome baseHome;
    private final List<FileInitializer> fileInitializers;
    private final StartArgs startArgs;

    public BaseBuilder(BaseHome baseHome, StartArgs args) {
        this.baseHome = baseHome;
        this.startArgs = args;
        this.fileInitializers = new ArrayList<FileInitializer>();
        if (args.isTestingModeEnabled()) {
            this.fileInitializers.add(new BaseHomeFileInitializer(baseHome));
            this.fileInitializers.add(new LocalFileInitializer(baseHome));
            this.fileInitializers.add(new TestFileInitializer(baseHome));
        } else if (args.isCreateFiles()) {
            this.fileInitializers.add(new LocalFileInitializer(baseHome));
            Path localRepoDir = args.findMavenLocalRepoDir();
            if (localRepoDir != null) {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome, localRepoDir, args.getMavenLocalRepoDir() == null, this.startArgs.getMavenBaseUri()));
            } else {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome));
            }
            this.fileInitializers.add(new BaseHomeFileInitializer(baseHome));
            this.fileInitializers.add(new UriFileInitializer(baseHome));
        }
    }

    public boolean build() throws IOException {
        Modules modules = this.startArgs.getAllModules();
        HashSet<String> newlyAdded = new HashSet<String>();
        if (!this.startArgs.getStartModules().isEmpty()) {
            for (String string : this.startArgs.getStartModules()) {
                newlyAdded.addAll(modules.enable(string, "--add-to-start"));
                if (newlyAdded.contains(string)) continue;
                Set<String> sources = modules.get(string).getEnableSources();
                sources.remove("--add-to-start");
                StartLog.info("%s already enabled by %s", string, sources);
            }
        }
        if (StartLog.isDebugEnabled()) {
            StartLog.debug("added=%s", newlyAdded);
        }
        if (this.startArgs.isLicenseCheckRequired()) {
            Licensing licensing = new Licensing();
            for (String name : newlyAdded) {
                licensing.addModule(modules.get(name));
            }
            if (licensing.hasLicenses()) {
                if (this.startArgs.isApproveAllLicenses()) {
                    StartLog.info("All Licenses Approved via Command Line Option", new Object[0]);
                } else if (!licensing.acknowledgeLicenses()) {
                    StartLog.warn(EXITING_LICENSE_NOT_ACKNOWLEDGED, new Object[0]);
                    System.exit(1);
                }
            }
        }
        ArrayList<FileArg> files = new ArrayList<FileArg>();
        AtomicReference<StartDirBuilder> atomicReference = new AtomicReference<StartDirBuilder>();
        AtomicBoolean modified = new AtomicBoolean();
        Path startd = this.getBaseHome().getBasePath("start.d");
        Path startini = this.getBaseHome().getBasePath("start.ini");
        if (this.startArgs.isCreateStartd() && !Files.exists(startd, new LinkOption[0])) {
            if (FS.ensureDirectoryExists(startd)) {
                StartLog.log("MKDIR", this.baseHome.toShortForm(startd));
                modified.set(true);
            }
            if (Files.exists(startini, new LinkOption[0])) {
                int ini = 0;
                Path startdStartini = startd.resolve("start.ini");
                while (Files.exists(startdStartini, new LinkOption[0])) {
                    startdStartini = startd.resolve("start" + ++ini + ".ini");
                }
                Files.move(startini, startdStartini, new CopyOption[0]);
                modified.set(true);
            }
        }
        if (!newlyAdded.isEmpty()) {
            boolean useStartD;
            if (Files.exists(startini, new LinkOption[0]) && Files.exists(startd, new LinkOption[0])) {
                StartLog.warn("Use both %s and %s is deprecated", this.getBaseHome().toShortForm(startd), this.getBaseHome().toShortForm(startini));
            }
            atomicReference.set((StartDirBuilder)((useStartD = Files.exists(startd, new LinkOption[0])) ? new StartDirBuilder(this) : new StartIniBuilder(this)));
            newlyAdded.stream().map(n -> modules.get((String)n)).forEach(module -> {
                String ini = null;
                try {
                    if (module.isSkipFilesValidation()) {
                        StartLog.debug("Skipping [files] validation on %s", module.getName());
                    } else {
                        if (this.startArgs.getStartModules().contains(module.getName()) && (ini = ((Config)builder.get()).addModule((Module)module, this.startArgs.getProperties())) != null) {
                            modified.set(true);
                        }
                        for (String file : module.getFiles()) {
                            files.add(new FileArg((Module)module, this.startArgs.getProperties().expand(file)));
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (module.isDynamic()) {
                    for (String s : module.getEnableSources()) {
                        StartLog.info("%-15s %s", module.getName(), s);
                    }
                } else if (module.isTransitive()) {
                    if (module.hasIniTemplate()) {
                        StartLog.info("%-15s transitively enabled, ini template available with --add-to-start=%s", module.getName(), module.getName());
                    } else {
                        StartLog.info("%-15s transitively enabled", module.getName());
                    }
                } else {
                    StartLog.info("%-15s initialized in %s", module.getName(), ini);
                }
            });
        }
        files.addAll(this.startArgs.getFiles());
        if (!files.isEmpty() && this.processFileResources(files)) {
            modified.set(true);
        }
        return modified.get();
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    public StartArgs getStartArgs() {
        return this.startArgs;
    }

    private boolean processFileResource(FileArg arg) throws IOException {
        URI uri;
        URI uRI = uri = arg.uri == null ? null : URI.create(arg.uri);
        if (this.startArgs.isCreateFiles()) {
            for (FileInitializer finit : this.fileInitializers) {
                if (!finit.isApplicable(uri)) continue;
                return finit.create(uri, arg.location);
            }
            throw new IOException(String.format("Unable to create %s", arg));
        }
        for (FileInitializer finit : this.fileInitializers) {
            if (!finit.isApplicable(uri) || finit.check(uri, arg.location)) continue;
            this.startArgs.setRun(false);
        }
        return false;
    }

    private boolean processFileResources(List<FileArg> files) throws IOException {
        if (files == null || files.isEmpty()) {
            return false;
        }
        boolean dirty = false;
        ArrayList<String> failures = new ArrayList<String>();
        for (FileArg arg : files) {
            try {
                boolean processed = this.processFileResource(arg);
                dirty |= processed;
            }
            catch (Throwable t) {
                StartLog.warn(t);
                failures.add(String.format("[%s] %s - %s", t.getClass().getSimpleName(), t.getMessage(), arg.location));
            }
        }
        if (!failures.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("Failed to process all file resources.");
            for (String failure : failures) {
                err.append(System.lineSeparator()).append(" - ").append(failure);
            }
            StartLog.warn(err.toString(), new Object[0]);
            throw new RuntimeException(err.toString());
        }
        return dirty;
    }

    public static interface Config {
        public String addModule(Module var1, Props var2) throws IOException;
    }
}

