/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public final class ByteStreams {
    private static final OutputStream NULL_OUTPUT_STREAM = new ByteStreams$1();

    static byte[] createBuffer() {
        return new byte[8192];
    }

    @CanIgnoreReturnValue
    public static long copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = ByteStreams.createBuffer();
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    private static byte[] toByteArrayInternal(InputStream inputStream, Deque deque, int n) {
        int n2 = 8192;
        while (n < 0x7FFFFFF7) {
            byte[] byArray = new byte[Math.min(n2, 0x7FFFFFF7 - n)];
            deque.add(byArray);
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = inputStream.read(byArray, n3, byArray.length - n3);
                if (n4 == -1) {
                    return ByteStreams.combineBuffers(deque, n);
                }
                n3 += n4;
                n += n4;
            }
            n2 = IntMath.saturatedMultiply(n2, 2);
        }
        if (inputStream.read() == -1) {
            return ByteStreams.combineBuffers(deque, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Deque deque, int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = n; i > 0; i -= n2) {
            byte[] byArray2 = (byte[])deque.removeFirst();
            n2 = Math.min(i, byArray2.length);
            int n3 = n - i;
            System.arraycopy(byArray2, 0, byArray, n3, n2);
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        Preconditions.checkNotNull(inputStream);
        return ByteStreams.toByteArrayInternal(inputStream, new ArrayDeque(20), 0);
    }

    static byte[] toByteArray(InputStream inputStream, long l) {
        int n;
        int n2;
        Preconditions.checkArgument(l >= 0L, "expectedSize (%s) must be non-negative", l);
        if (l > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(l + " bytes is too large to fit in a byte array");
        }
        byte[] byArray = new byte[(int)l];
        for (int i = (int)l; i > 0; i -= n2) {
            n = (int)l - i;
            n2 = inputStream.read(byArray, n, i);
            if (n2 != -1) continue;
            return Arrays.copyOf(byArray, n);
        }
        n = inputStream.read();
        if (n == -1) {
            return byArray;
        }
        ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>(22);
        arrayDeque.add(byArray);
        arrayDeque.add(new byte[]{(byte)n});
        return ByteStreams.toByteArrayInternal(inputStream, arrayDeque, byArray.length + 1);
    }
}

