/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdPrimitive;
import org.rrd4j.core.RrdUpdater;

class RrdDoubleMatrix<U extends RrdUpdater<U>>
extends RrdPrimitive<U> {
    private static final String LENGTH = ", length=";
    private final int rows;
    private final int columns;

    RrdDoubleMatrix(RrdUpdater<U> updater, int row, int column, boolean shouldInitialize) throws IOException {
        super(updater, 2, row * column, false);
        this.rows = row;
        this.columns = column;
        if (shouldInitialize) {
            this.writeDouble(0, Double.NaN, this.rows * this.columns);
        }
    }

    void set(int column, int index, double value) throws IOException {
        this.writeDouble(this.columns * index + column, value);
    }

    void set(int column, int index, double value, int count) throws IOException {
        assert (index + count <= this.rows) : "Invalid robin index supplied: index=" + index + ", count=" + count + ", length=" + this.rows;
        int i = this.columns * index + column;
        for (int c = 0; c < count; ++c) {
            this.writeDouble(i, value);
            i += this.columns;
        }
    }

    public void set(int column, int index, double[] newValues) throws IOException {
        int count = newValues.length;
        assert (index + count <= this.rows) : "Invalid robin index supplied: index=" + index + ", count=" + count + ", length=" + this.rows;
        int i = this.columns * index + column;
        for (int c = 0; c < count; ++c) {
            this.writeDouble(i, newValues[c]);
            i += this.columns;
        }
    }

    double get(int column, int index) throws IOException {
        assert (index < this.rows) : "Invalid index supplied: " + index + ", length=" + this.rows;
        return this.readDouble(this.columns * index + column);
    }

    double[] get(int column, int index, int count) throws IOException {
        assert (index + count <= this.rows) : "Invalid index/count supplied: " + index + "/" + count + " (length=" + this.rows + ")";
        double[] values = new double[count];
        int i = this.columns * index + column;
        for (int c = 0; c < count; ++c) {
            values[c] = this.readDouble(i);
            i += this.columns;
        }
        return values;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }
}

