/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.SetOnce;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.StepListener;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.StopWatch;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.common.util.concurrent.ListenableFuture;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLease;
import org.opensearch.index.seqno.RetentionLeaseNotFoundException;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.seqno.SequenceNumbers;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.RunUnderPrimaryPermit;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.MultiChunkTransfer;
import org.opensearch.indices.recovery.RecoverFilesRecoveryException;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;
import org.opensearch.indices.replication.SegmentFileTransferHandler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transports;

public class RecoverySourceHandler {
    protected final Logger logger;
    private final IndexShard shard;
    private final int shardId;
    private final StartRecoveryRequest request;
    private final int chunkSizeInBytes;
    private final RecoveryTargetHandler recoveryTarget;
    private final int maxConcurrentOperations;
    private final ThreadPool threadPool;
    private final CancellableThreads cancellableThreads = new CancellableThreads();
    private final List<Closeable> resources = new CopyOnWriteArrayList<Closeable>();
    private final ListenableFuture<RecoveryResponse> future = new ListenableFuture();
    public static final String PEER_RECOVERY_NAME = "peer-recovery";
    private final SegmentFileTransferHandler transferHandler;

    public RecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, ThreadPool threadPool, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations) {
        this.logger = Loggers.getLogger(RecoverySourceHandler.class, request.shardId(), "recover to " + request.targetNode().getName());
        this.transferHandler = new SegmentFileTransferHandler(shard, request.targetNode(), recoveryTarget, this.logger, threadPool, this.cancellableThreads, fileChunkSizeInBytes, maxConcurrentFileChunks);
        this.shard = shard;
        this.threadPool = threadPool;
        this.request = request;
        this.recoveryTarget = recoveryTarget;
        this.shardId = this.request.shardId().id();
        this.chunkSizeInBytes = fileChunkSizeInBytes;
        this.maxConcurrentOperations = maxConcurrentOperations;
    }

    public StartRecoveryRequest getRequest() {
        return this.request;
    }

    public void addListener(ActionListener<RecoveryResponse> listener) {
        this.future.addListener(listener, OpenSearchExecutors.newDirectExecutorService());
    }

    public void recoverToTarget(ActionListener<RecoveryResponse> listener) {
        this.addListener(listener);
        Closeable releaseResources = () -> IOUtils.close(this.resources);
        try {
            long startingSeqNo;
            boolean isSequenceNumberBasedRecovery;
            this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
                OpenSearchException e = this.shard.state() == IndexShardState.CLOSED ? new IndexShardClosedException(this.shard.shardId(), "shard is closed and recovery was canceled reason [" + reason + "]") : new CancellableThreads.ExecutionCancelledException("recovery was canceled reason [" + reason + "]");
                if (beforeCancelEx != null) {
                    e.addSuppressed(beforeCancelEx);
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releaseResources, () -> this.future.onFailure(e)});
                throw e;
            });
            Consumer<Exception> onFailure = e -> {
                assert (Transports.assertNotTransportThread(this + "[onFailure]"));
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releaseResources, () -> this.future.onFailure((Exception)e)});
            };
            SetOnce retentionLeaseRef = new SetOnce();
            RunUnderPrimaryPermit.run(() -> {
                IndexShardRoutingTable routingTable = this.shard.getReplicationGroup().getRoutingTable();
                ShardRouting targetShardRouting = routingTable.getByAllocationId(this.request.targetAllocationId());
                if (targetShardRouting == null) {
                    this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", (Object)this.request.shardId(), (Object)this.request.targetNode());
                    throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
                }
                assert (targetShardRouting.initializing()) : "expected recovery target to be initializing but was " + targetShardRouting;
                retentionLeaseRef.set((Object)this.shard.getRetentionLeases().get(ReplicationTracker.getPeerRecoveryRetentionLeaseId(targetShardRouting)));
            }, this.shardId + " validating recovery target [" + this.request.targetAllocationId() + "] registered ", this.shard, this.cancellableThreads, this.logger);
            Closeable retentionLock = this.shard.acquireHistoryRetentionLock();
            this.resources.add(retentionLock);
            boolean bl = isSequenceNumberBasedRecovery = this.request.startingSeqNo() != -2L && this.isTargetSameHistory() && this.shard.hasCompleteHistoryOperations(PEER_RECOVERY_NAME, this.request.startingSeqNo()) && (retentionLeaseRef.get() == null && !this.shard.useRetentionLeasesInPeerRecovery() || retentionLeaseRef.get() != null && ((RetentionLease)retentionLeaseRef.get()).retainingSequenceNumber() <= this.request.startingSeqNo());
            if (isSequenceNumberBasedRecovery && retentionLeaseRef.get() != null) {
                retentionLock.close();
                this.logger.trace("history is retained by {}", retentionLeaseRef.get());
            } else {
                this.logger.trace("history is retained by retention lock");
            }
            StepListener<SendFileResult> sendFileStep = new StepListener<SendFileResult>();
            StepListener prepareEngineStep = new StepListener();
            StepListener sendSnapshotStep = new StepListener();
            StepListener finalizeStep = new StepListener();
            if (isSequenceNumberBasedRecovery) {
                this.logger.trace("performing sequence numbers based recovery. starting at [{}]", (Object)this.request.startingSeqNo());
                startingSeqNo = this.request.startingSeqNo();
                if (retentionLeaseRef.get() == null) {
                    this.createRetentionLease(startingSeqNo, ActionListener.map(sendFileStep, ignored -> SendFileResult.EMPTY));
                } else {
                    sendFileStep.onResponse(SendFileResult.EMPTY);
                }
            } else {
                GatedCloseable<IndexCommit> wrappedSafeCommit;
                try {
                    wrappedSafeCommit = this.acquireSafeCommit(this.shard);
                    this.resources.add(wrappedSafeCommit);
                }
                catch (Exception e2) {
                    throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e2);
                }
                startingSeqNo = Long.parseLong((String)wrappedSafeCommit.get().getUserData().get("local_checkpoint")) + 1L;
                this.logger.trace("performing file-based recovery followed by history replay starting at [{}]", (Object)startingSeqNo);
                try {
                    int estimateNumOps = this.countNumberOfHistoryOperations(startingSeqNo);
                    Releasable releaseStore = this.acquireStore(this.shard.store());
                    this.resources.add(releaseStore);
                    sendFileStep.whenComplete(r -> IOUtils.close((Closeable[])new Closeable[]{wrappedSafeCommit, releaseStore}), e -> {
                        try {
                            IOUtils.close((Closeable[])new Closeable[]{wrappedSafeCommit, releaseStore});
                        }
                        catch (IOException ex) {
                            this.logger.warn("releasing snapshot caused exception", (Throwable)ex);
                        }
                    });
                    StepListener deleteRetentionLeaseStep = new StepListener();
                    RunUnderPrimaryPermit.run(() -> {
                        try {
                            this.shard.removePeerRecoveryRetentionLease(this.request.targetNode().getId(), new ThreadedActionListener<ReplicationResponse>(this.logger, this.shard.getThreadPool(), "generic", deleteRetentionLeaseStep, false));
                        }
                        catch (RetentionLeaseNotFoundException e) {
                            this.logger.debug("no peer-recovery retention lease for " + this.request.targetAllocationId());
                            deleteRetentionLeaseStep.onResponse(null);
                        }
                    }, this.shardId + " removing retention lease for [" + this.request.targetAllocationId() + "]", this.shard, this.cancellableThreads, this.logger);
                    deleteRetentionLeaseStep.whenComplete(ignored -> {
                        assert (Transports.assertNotTransportThread(this + "[phase1]"));
                        this.phase1((IndexCommit)wrappedSafeCommit.get(), startingSeqNo, () -> estimateNumOps, sendFileStep);
                    }, onFailure);
                }
                catch (Exception e3) {
                    throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e3);
                }
            }
            assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
            sendFileStep.whenComplete(r -> {
                assert (Transports.assertNotTransportThread(this + "[prepareTargetForTranslog]"));
                this.prepareTargetForTranslog(this.countNumberOfHistoryOperations(startingSeqNo), prepareEngineStep);
            }, onFailure);
            prepareEngineStep.whenComplete(prepareEngineTime -> {
                assert (Transports.assertNotTransportThread(this + "[phase2]"));
                RunUnderPrimaryPermit.run(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shardId + " initiating tracking of " + this.request.targetAllocationId(), this.shard, this.cancellableThreads, this.logger);
                long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("snapshot translog for recovery; current size is [{}]", (Object)this.countNumberOfHistoryOperations(startingSeqNo));
                }
                Translog.Snapshot phase2Snapshot = this.shard.newChangesSnapshot(PEER_RECOVERY_NAME, startingSeqNo, Long.MAX_VALUE, false, true);
                this.resources.add(phase2Snapshot);
                retentionLock.close();
                long maxSeenAutoIdTimestamp = this.shard.getMaxSeenAutoIdTimestamp();
                long maxSeqNoOfUpdatesOrDeletes = this.shard.getMaxSeqNoOfUpdatesOrDeletes();
                RetentionLeases retentionLeases = this.shard.getRetentionLeases();
                long mappingVersionOnPrimary = this.shard.indexSettings().getIndexMetadata().getMappingVersion();
                this.phase2(startingSeqNo, endingSeqNo, phase2Snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, sendSnapshotStep);
            }, onFailure);
            long trimAboveSeqNo = startingSeqNo - 1L;
            sendSnapshotStep.whenComplete(r -> this.finalizeRecovery(r.targetLocalCheckpoint, trimAboveSeqNo, finalizeStep), onFailure);
            finalizeStep.whenComplete(r -> {
                long phase1ThrottlingWaitTime = 0L;
                SendSnapshotResult sendSnapshotResult = (SendSnapshotResult)sendSnapshotStep.result();
                SendFileResult sendFileResult = (SendFileResult)sendFileStep.result();
                RecoveryResponse response = new RecoveryResponse(sendFileResult.phase1FileNames, sendFileResult.phase1FileSizes, sendFileResult.phase1ExistingFileNames, sendFileResult.phase1ExistingFileSizes, sendFileResult.totalSize, sendFileResult.existingTotalSize, sendFileResult.took.millis(), 0L, ((TimeValue)prepareEngineStep.result()).millis(), sendSnapshotResult.sentOperations, sendSnapshotResult.tookTime.millis());
                try {
                    this.future.onResponse(response);
                }
                finally {
                    IOUtils.close(this.resources);
                }
            }, onFailure);
        }
        catch (Exception e4) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releaseResources, () -> this.future.onFailure(e4)});
        }
    }

    private boolean isTargetSameHistory() {
        String targetHistoryUUID = this.request.metadataSnapshot().getHistoryUUID();
        assert (targetHistoryUUID != null) : "incoming target history missing";
        return targetHistoryUUID.equals(this.shard.getHistoryUUID());
    }

    private int countNumberOfHistoryOperations(long startingSeqNo) throws IOException {
        return this.shard.countNumberOfHistoryOperations(PEER_RECOVERY_NAME, startingSeqNo, Long.MAX_VALUE);
    }

    private Releasable acquireStore(Store store) {
        store.incRef();
        return Releasables.releaseOnce(() -> this.runWithGenericThreadPool((CheckedRunnable<Exception>)((CheckedRunnable)store::decRef)));
    }

    private GatedCloseable<IndexCommit> acquireSafeCommit(IndexShard shard) {
        GatedCloseable<IndexCommit> wrappedSafeCommit = shard.acquireSafeIndexCommit();
        AtomicBoolean closed = new AtomicBoolean(false);
        return new GatedCloseable<IndexCommit>(wrappedSafeCommit.get(), (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
            if (closed.compareAndSet(false, true)) {
                this.runWithGenericThreadPool((CheckedRunnable<Exception>)((CheckedRunnable)wrappedSafeCommit::close));
            }
        }));
    }

    private void runWithGenericThreadPool(CheckedRunnable<Exception> task) {
        PlainActionFuture future = new PlainActionFuture();
        assert (!this.threadPool.generic().isShutdown());
        this.threadPool.generic().execute(ActionRunnable.run(future, task));
        FutureUtils.get(future);
    }

    void phase1(IndexCommit snapshot, long startingSeqNo, IntSupplier translogOps, ActionListener<SendFileResult> listener) {
        this.cancellableThreads.checkForCancel();
        Store store = this.shard.store();
        try {
            Store.MetadataSnapshot recoverySourceMetadata;
            StopWatch stopWatch = new StopWatch().start();
            try {
                recoverySourceMetadata = store.getMetadata(snapshot);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                this.shard.failShard("recovery", (Exception)ex);
                throw ex;
            }
            for (String name : snapshot.getFileNames()) {
                StoreFileMetadata md = recoverySourceMetadata.get(name);
                if (md != null) continue;
                this.logger.info("Snapshot differs from actual index for file: {} meta: {}", (Object)name, recoverySourceMetadata.asMap());
                throw new CorruptIndexException("Snapshot differs from actual index - maybe index was removed metadata has " + recoverySourceMetadata.asMap().size() + " files", name);
            }
            if (!this.canSkipPhase1(recoverySourceMetadata, this.request.metadataSnapshot())) {
                ArrayList<String> phase1FileNames = new ArrayList<String>();
                ArrayList<Long> phase1FileSizes = new ArrayList<Long>();
                ArrayList<String> phase1ExistingFileNames = new ArrayList<String>();
                ArrayList<Long> phase1ExistingFileSizes = new ArrayList<Long>();
                long totalSizeInBytes = 0L;
                long existingTotalSizeInBytes = 0L;
                Store.RecoveryDiff diff = recoverySourceMetadata.recoveryDiff(this.request.metadataSnapshot());
                for (StoreFileMetadata storeFileMetadata : diff.identical) {
                    phase1ExistingFileNames.add(storeFileMetadata.name());
                    phase1ExistingFileSizes.add(storeFileMetadata.length());
                    existingTotalSizeInBytes += storeFileMetadata.length();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("recovery [phase1]: not recovering [{}], exist in local store and has checksum [{}], size [{}]", (Object)storeFileMetadata.name(), (Object)storeFileMetadata.checksum(), (Object)storeFileMetadata.length());
                    }
                    totalSizeInBytes += storeFileMetadata.length();
                }
                ArrayList<StoreFileMetadata> phase1Files = new ArrayList<StoreFileMetadata>(diff.different.size() + diff.missing.size());
                phase1Files.addAll(diff.different);
                phase1Files.addAll(diff.missing);
                for (StoreFileMetadata md : phase1Files) {
                    if (this.request.metadataSnapshot().asMap().containsKey(md.name())) {
                        this.logger.trace("recovery [phase1]: recovering [{}], exists in local store, but is different: remote [{}], local [{}]", (Object)md.name(), (Object)this.request.metadataSnapshot().asMap().get(md.name()), (Object)md);
                    } else {
                        this.logger.trace("recovery [phase1]: recovering [{}], does not exist in remote", (Object)md.name());
                    }
                    phase1FileNames.add(md.name());
                    phase1FileSizes.add(md.length());
                    totalSizeInBytes += md.length();
                }
                this.logger.trace("recovery [phase1]: recovering_files [{}] with total_size [{}], reusing_files [{}] with total_size [{}]", (Object)phase1FileNames.size(), (Object)new ByteSizeValue(totalSizeInBytes), (Object)phase1ExistingFileNames.size(), (Object)new ByteSizeValue(existingTotalSizeInBytes));
                StepListener<Void> stepListener = new StepListener<Void>();
                StepListener sendFilesStep = new StepListener();
                StepListener createRetentionLeaseStep = new StepListener();
                StepListener cleanFilesStep = new StepListener();
                this.cancellableThreads.checkForCancel();
                this.recoveryTarget.receiveFileInfo(phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, translogOps.getAsInt(), stepListener);
                stepListener.whenComplete((CheckedConsumer<Void, Exception>)((CheckedConsumer)r -> this.sendFiles(store, phase1Files.toArray(new StoreFileMetadata[0]), translogOps, sendFilesStep)), listener::onFailure);
                sendFilesStep.whenComplete(r -> this.createRetentionLease(startingSeqNo, createRetentionLeaseStep), listener::onFailure);
                createRetentionLeaseStep.whenComplete(retentionLease -> {
                    long lastKnownGlobalCheckpoint = this.shard.getLastKnownGlobalCheckpoint();
                    assert (retentionLease == null || retentionLease.retainingSequenceNumber() - 1L <= lastKnownGlobalCheckpoint) : retentionLease + " vs " + lastKnownGlobalCheckpoint;
                    this.cleanFiles(store, recoverySourceMetadata, translogOps, lastKnownGlobalCheckpoint, cleanFilesStep);
                }, listener::onFailure);
                long totalSize = totalSizeInBytes;
                long existingTotalSize = existingTotalSizeInBytes;
                cleanFilesStep.whenComplete(r -> {
                    TimeValue took = stopWatch.totalTime();
                    this.logger.trace("recovery [phase1]: took [{}]", (Object)took);
                    listener.onResponse(new SendFileResult(phase1FileNames, phase1FileSizes, totalSize, phase1ExistingFileNames, phase1ExistingFileSizes, existingTotalSize, took));
                }, listener::onFailure);
            } else {
                this.logger.trace("skipping [phase1] since source and target have identical sync id [{}]", (Object)recoverySourceMetadata.getSyncId());
                StepListener<RetentionLease> createRetentionLeaseStep = new StepListener<RetentionLease>();
                this.createRetentionLease(startingSeqNo, createRetentionLeaseStep);
                createRetentionLeaseStep.whenComplete((CheckedConsumer<RetentionLease, Exception>)((CheckedConsumer)retentionLease -> {
                    TimeValue took = stopWatch.totalTime();
                    this.logger.trace("recovery [phase1]: took [{}]", (Object)took);
                    listener.onResponse(new SendFileResult(Collections.emptyList(), Collections.emptyList(), 0L, Collections.emptyList(), Collections.emptyList(), 0L, took));
                }), listener::onFailure);
            }
        }
        catch (Exception e) {
            throw new RecoverFilesRecoveryException(this.request.shardId(), 0, new ByteSizeValue(0L), e);
        }
    }

    void sendFiles(Store store, StoreFileMetadata[] files, IntSupplier translogOps, ActionListener<Void> listener) {
        MultiChunkTransfer<StoreFileMetadata, SegmentFileTransferHandler.FileChunk> transfer = this.transferHandler.createTransfer(store, files, translogOps, listener);
        this.resources.add(transfer);
        transfer.start();
    }

    void createRetentionLease(long startingSeqNo, ActionListener<RetentionLease> listener) {
        RunUnderPrimaryPermit.run(() -> {
            this.logger.trace("cloning primary's retention lease");
            try {
                StepListener cloneRetentionLeaseStep = new StepListener();
                RetentionLease clonedLease = this.shard.cloneLocalPeerRecoveryRetentionLease(this.request.targetNode().getId(), new ThreadedActionListener<ReplicationResponse>(this.logger, this.shard.getThreadPool(), "generic", cloneRetentionLeaseStep, false));
                this.logger.trace("cloned primary's retention lease as [{}]", (Object)clonedLease);
                cloneRetentionLeaseStep.whenComplete(rr -> listener.onResponse(clonedLease), listener::onFailure);
            }
            catch (RetentionLeaseNotFoundException e) {
                assert (this.shard.indexSettings().getIndexVersionCreated().before(LegacyESVersion.V_7_4_0) || !this.shard.indexSettings().isSoftDeleteEnabled());
                StepListener addRetentionLeaseStep = new StepListener();
                long estimatedGlobalCheckpoint = startingSeqNo - 1L;
                RetentionLease newLease = this.shard.addPeerRecoveryRetentionLease(this.request.targetNode().getId(), estimatedGlobalCheckpoint, new ThreadedActionListener<ReplicationResponse>(this.logger, this.shard.getThreadPool(), "generic", addRetentionLeaseStep, false));
                addRetentionLeaseStep.whenComplete(rr -> listener.onResponse(newLease), listener::onFailure);
                this.logger.trace("created retention lease with estimated checkpoint of [{}]", (Object)estimatedGlobalCheckpoint);
            }
        }, this.shardId + " establishing retention lease for [" + this.request.targetAllocationId() + "]", this.shard, this.cancellableThreads, this.logger);
    }

    boolean canSkipPhase1(Store.MetadataSnapshot source, Store.MetadataSnapshot target) {
        if (source.getSyncId() == null || !source.getSyncId().equals(target.getSyncId())) {
            return false;
        }
        if (source.getNumDocs() != target.getNumDocs()) {
            throw new IllegalStateException("try to recover " + this.request.shardId() + " from primary shard with sync id but number of docs differ: " + source.getNumDocs() + " (" + this.request.sourceNode().getName() + ", primary) vs " + target.getNumDocs() + "(" + this.request.targetNode().getName() + ")");
        }
        SequenceNumbers.CommitInfo sourceSeqNos = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(source.getCommitUserData().entrySet());
        SequenceNumbers.CommitInfo targetSeqNos = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(target.getCommitUserData().entrySet());
        if (sourceSeqNos.localCheckpoint != targetSeqNos.localCheckpoint || targetSeqNos.maxSeqNo != sourceSeqNos.maxSeqNo) {
            String message = "try to recover " + this.request.shardId() + " with sync id but seq_no stats are mismatched: [" + source.getCommitUserData() + "] vs [" + target.getCommitUserData() + "]";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
        return true;
    }

    void prepareTargetForTranslog(int totalTranslogOps, ActionListener<TimeValue> listener) {
        StopWatch stopWatch = new StopWatch().start();
        ActionListener<Void> wrappedListener = ActionListener.wrap(nullVal -> {
            stopWatch.stop();
            TimeValue tookTime = stopWatch.totalTime();
            this.logger.trace("recovery [phase1]: remote engine start took [{}]", (Object)tookTime);
            listener.onResponse(tookTime);
        }, e -> listener.onFailure(new RecoveryEngineException(this.shard.shardId(), 1, "prepare target for translog failed", (Throwable)e)));
        this.logger.trace("recovery [phase1]: prepare remote engine for translog");
        this.cancellableThreads.checkForCancel();
        this.recoveryTarget.prepareForTranslogOperations(totalTranslogOps, wrappedListener);
    }

    void phase2(long startingSeqNo, long endingSeqNo, Translog.Snapshot snapshot, long maxSeenAutoIdTimestamp, long maxSeqNoOfUpdatesOrDeletes, RetentionLeases retentionLeases, long mappingVersion, ActionListener<SendSnapshotResult> listener) throws IOException {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.logger.trace("recovery [phase2]: sending transaction log operations (from [" + startingSeqNo + "] to [" + endingSeqNo + "]");
        StopWatch stopWatch = new StopWatch().start();
        StepListener<Void> sendListener = new StepListener<Void>();
        OperationBatchSender sender = new OperationBatchSender(startingSeqNo, endingSeqNo, snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersion, sendListener);
        sendListener.whenComplete((CheckedConsumer<Void, Exception>)((CheckedConsumer)ignored -> {
            long skippedOps = sender.skippedOps.get();
            int totalSentOps = sender.sentOps.get();
            long targetLocalCheckpoint = sender.targetLocalCheckpoint.get();
            assert ((long)snapshot.totalOperations() == (long)snapshot.skippedOperations() + skippedOps + (long)totalSentOps) : String.format(Locale.ROOT, "expected total [%d], overridden [%d], skipped [%d], total sent [%d]", snapshot.totalOperations(), snapshot.skippedOperations(), skippedOps, totalSentOps);
            stopWatch.stop();
            TimeValue tookTime = stopWatch.totalTime();
            this.logger.trace("recovery [phase2]: took [{}]", (Object)tookTime);
            listener.onResponse(new SendSnapshotResult(targetLocalCheckpoint, totalSentOps, tookTime));
        }), listener::onFailure);
        sender.start();
    }

    void finalizeRecovery(long targetLocalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) throws IOException {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.cancellableThreads.checkForCancel();
        StopWatch stopWatch = new StopWatch().start();
        this.logger.trace("finalizing recovery");
        RunUnderPrimaryPermit.run(() -> this.shard.markAllocationIdAsInSync(this.request.targetAllocationId(), targetLocalCheckpoint), this.shardId + " marking " + this.request.targetAllocationId() + " as in sync", this.shard, this.cancellableThreads, this.logger);
        long globalCheckpoint = this.shard.getLastKnownGlobalCheckpoint();
        StepListener<Void> finalizeListener = new StepListener<Void>();
        this.cancellableThreads.checkForCancel();
        this.recoveryTarget.finalizeRecovery(globalCheckpoint, trimAboveSeqNo, finalizeListener);
        finalizeListener.whenComplete((CheckedConsumer<Void, Exception>)((CheckedConsumer)r -> {
            RunUnderPrimaryPermit.run(() -> this.shard.updateGlobalCheckpointForShard(this.request.targetAllocationId(), globalCheckpoint), this.shardId + " updating " + this.request.targetAllocationId() + "'s global checkpoint", this.shard, this.cancellableThreads, this.logger);
            if (this.request.isPrimaryRelocation()) {
                this.logger.trace("performing relocation hand-off");
                this.cancellableThreads.execute(() -> this.shard.relocated(this.request.targetAllocationId(), this.recoveryTarget::handoffPrimaryContext));
            }
            stopWatch.stop();
            this.logger.trace("finalizing recovery took [{}]", (Object)stopWatch.totalTime());
            listener.onResponse(null);
        }), listener::onFailure);
    }

    public void cancel(String reason) {
        this.cancellableThreads.cancel(reason);
        this.recoveryTarget.cancel();
    }

    public String toString() {
        return "ShardRecoveryHandler{shardId=" + this.request.shardId() + ", sourceNode=" + this.request.sourceNode() + ", targetNode=" + this.request.targetNode() + "}";
    }

    private void cleanFiles(Store store, Store.MetadataSnapshot sourceMetadata, IntSupplier translogOps, long globalCheckpoint, ActionListener<Void> listener) {
        this.cancellableThreads.checkForCancel();
        this.recoveryTarget.cleanFiles(translogOps.getAsInt(), globalCheckpoint, sourceMetadata, ActionListener.delegateResponse(listener, (l, e) -> ActionListener.completeWith(l, () -> {
            Object[] mds = (StoreFileMetadata[])StreamSupport.stream(sourceMetadata.spliterator(), false).toArray(StoreFileMetadata[]::new);
            ArrayUtil.timSort((Object[])mds, Comparator.comparingLong(StoreFileMetadata::length));
            this.transferHandler.handleErrorOnSendFiles(store, (Exception)e, (StoreFileMetadata[])mds);
            throw e;
        })));
    }

    static final class SendFileResult {
        final List<String> phase1FileNames;
        final List<Long> phase1FileSizes;
        final long totalSize;
        final List<String> phase1ExistingFileNames;
        final List<Long> phase1ExistingFileSizes;
        final long existingTotalSize;
        final TimeValue took;
        static final SendFileResult EMPTY = new SendFileResult(Collections.emptyList(), Collections.emptyList(), 0L, Collections.emptyList(), Collections.emptyList(), 0L, TimeValue.ZERO);

        SendFileResult(List<String> phase1FileNames, List<Long> phase1FileSizes, long totalSize, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, long existingTotalSize, TimeValue took) {
            this.phase1FileNames = phase1FileNames;
            this.phase1FileSizes = phase1FileSizes;
            this.totalSize = totalSize;
            this.phase1ExistingFileNames = phase1ExistingFileNames;
            this.phase1ExistingFileSizes = phase1ExistingFileSizes;
            this.existingTotalSize = existingTotalSize;
            this.took = took;
        }
    }

    private class OperationBatchSender
    extends MultiChunkTransfer<Translog.Snapshot, OperationChunkRequest> {
        private final long startingSeqNo;
        private final long endingSeqNo;
        private final Translog.Snapshot snapshot;
        private final long maxSeenAutoIdTimestamp;
        private final long maxSeqNoOfUpdatesOrDeletes;
        private final RetentionLeases retentionLeases;
        private final long mappingVersion;
        private int lastBatchCount;
        private final AtomicInteger skippedOps;
        private final AtomicInteger sentOps;
        private final AtomicLong targetLocalCheckpoint;

        OperationBatchSender(long startingSeqNo, long endingSeqNo, Translog.Snapshot snapshot, long maxSeenAutoIdTimestamp, long maxSeqNoOfUpdatesOrDeletes, RetentionLeases retentionLeases, long mappingVersion, ActionListener<Void> listener) {
            super(RecoverySourceHandler.this.logger, RecoverySourceHandler.this.threadPool.getThreadContext(), listener, RecoverySourceHandler.this.maxConcurrentOperations, Collections.singletonList(snapshot));
            this.lastBatchCount = 0;
            this.skippedOps = new AtomicInteger();
            this.sentOps = new AtomicInteger();
            this.targetLocalCheckpoint = new AtomicLong(-1L);
            this.startingSeqNo = startingSeqNo;
            this.endingSeqNo = endingSeqNo;
            this.snapshot = snapshot;
            this.maxSeenAutoIdTimestamp = maxSeenAutoIdTimestamp;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
            this.retentionLeases = retentionLeases;
            this.mappingVersion = mappingVersion;
        }

        @Override
        protected synchronized OperationChunkRequest nextChunkRequest(Translog.Snapshot snapshot) throws IOException {
            Translog.Operation operation;
            assert (Transports.assertNotTransportThread("[phase2]"));
            RecoverySourceHandler.this.cancellableThreads.checkForCancel();
            ArrayList<Translog.Operation> ops = this.lastBatchCount > 0 ? new ArrayList<Translog.Operation>(this.lastBatchCount) : new ArrayList();
            long batchSizeInBytes = 0L;
            while ((operation = snapshot.next()) != null) {
                if (RecoverySourceHandler.this.shard.state() == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(RecoverySourceHandler.this.request.shardId());
                }
                long seqNo = operation.seqNo();
                if (seqNo < this.startingSeqNo || seqNo > this.endingSeqNo) {
                    this.skippedOps.incrementAndGet();
                    continue;
                }
                ops.add(operation);
                this.sentOps.incrementAndGet();
                if ((batchSizeInBytes += operation.estimateSize()) < (long)RecoverySourceHandler.this.chunkSizeInBytes) continue;
                break;
            }
            this.lastBatchCount = ops.size();
            return new OperationChunkRequest(ops, operation == null);
        }

        @Override
        protected void executeChunkRequest(OperationChunkRequest request, ActionListener<Void> listener) {
            RecoverySourceHandler.this.cancellableThreads.checkForCancel();
            RecoverySourceHandler.this.recoveryTarget.indexTranslogOperations(request.operations, this.snapshot.totalOperations(), this.maxSeenAutoIdTimestamp, this.maxSeqNoOfUpdatesOrDeletes, this.retentionLeases, this.mappingVersion, ActionListener.delegateFailure(listener, (l, newCheckpoint) -> {
                this.targetLocalCheckpoint.updateAndGet(curr -> SequenceNumbers.max(curr, newCheckpoint));
                l.onResponse(null);
            }));
        }

        @Override
        protected void handleError(Translog.Snapshot snapshot, Exception e) {
            throw new RecoveryEngineException(RecoverySourceHandler.this.shard.shardId(), 2, "failed to send/replay operations", e);
        }

        @Override
        public void close() throws IOException {
            this.snapshot.close();
        }
    }

    static final class SendSnapshotResult {
        final long targetLocalCheckpoint;
        final int sentOperations;
        final TimeValue tookTime;

        SendSnapshotResult(long targetLocalCheckpoint, int sentOperations, TimeValue tookTime) {
            this.targetLocalCheckpoint = targetLocalCheckpoint;
            this.sentOperations = sentOperations;
            this.tookTime = tookTime;
        }
    }

    private static class OperationChunkRequest
    implements MultiChunkTransfer.ChunkRequest {
        final List<Translog.Operation> operations;
        final boolean lastChunk;

        OperationChunkRequest(List<Translog.Operation> operations, boolean lastChunk) {
            this.operations = operations;
            this.lastChunk = lastChunk;
        }

        @Override
        public boolean lastChunk() {
            return this.lastChunk;
        }
    }
}

