/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.stats.upload;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public final class UploadMetric
implements ToXContentFragment,
Writeable {
    private final long duration;
    private final long failedCount;
    private final String metricID;
    private final long successCount;
    private final long uploadCount;
    private final String type;

    private UploadMetric(UploadMetricBuilder builder) {
        this.metricID = builder.metricID;
        this.uploadCount = builder.uploadCount;
        this.successCount = builder.successCount;
        this.failedCount = builder.failedCount;
        this.duration = builder.duration;
        this.type = builder.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadMetric newMetric = (UploadMetric)o;
        return Objects.equals(this.metricID, newMetric.metricID);
    }

    public int hashCode() {
        return Objects.hash(this.metricID);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELDS.ID.toString(), this.metricID);
        builder.field(FIELDS.TYPE.toString(), this.type);
        builder.field(FIELDS.UPLOAD.toString(), this.uploadCount);
        builder.field(FIELDS.SUCCESS.toString(), this.successCount);
        builder.field(FIELDS.FAILED.toString(), this.failedCount);
        builder.field(FIELDS.DURATION.toString(), this.duration);
        return builder;
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.metricID);
        output.writeString(this.type);
        output.writeVLong(this.uploadCount);
        output.writeVLong(this.successCount);
        output.writeVLong(this.failedCount);
        output.writeVLong(this.duration);
    }

    public long getDuration() {
        return this.duration;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    public String getMetricID() {
        return this.metricID;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getUploadCount() {
        return this.uploadCount;
    }

    public String getType() {
        return this.type;
    }

    public static final class UploadMetricBuilder {
        private long duration;
        private long failedCount;
        private final String metricID;
        private final String type;
        private long successCount;
        private long uploadCount;

        public UploadMetricBuilder(String metricID, String type) {
            if (!Strings.hasText((String)metricID)) {
                throw new IllegalArgumentException("metric ID cannot be empty");
            }
            if (!Strings.hasText((String)type)) {
                throw new IllegalArgumentException("type cannot be empty");
            }
            this.metricID = metricID;
            this.type = type;
        }

        public UploadMetricBuilder uploadCount(long uploadCount) {
            this.uploadCount = uploadCount;
            return this;
        }

        public UploadMetricBuilder successCount(long successCount) {
            this.successCount = successCount;
            return this;
        }

        public UploadMetricBuilder failedCount(long failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public UploadMetricBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public UploadMetric build() {
            return new UploadMetric(this);
        }

        public static UploadMetric fromStreamInput(StreamInput input) throws IOException {
            String metricId = input.readString();
            String type = input.readString();
            UploadMetricBuilder builder = new UploadMetricBuilder(metricId, type).uploadCount(input.readVLong()).successCount(input.readVLong()).failedCount(input.readVLong()).duration(input.readVLong());
            return builder.build();
        }
    }

    public static enum FIELDS {
        UPLOAD,
        DURATION,
        FAILED,
        ID,
        SUCCESS,
        TYPE;


        public String toString() {
            return this.name().toLowerCase(Locale.getDefault());
        }
    }
}

