/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.cluster.service.MasterService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class MasterThrottlingMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(MasterThrottlingMetricsCollector.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(MasterThrottlingMetricsCollector.class);
    private static final int KEYS_PATH_LENGTH = 0;
    private static final String MASTER_THROTTLING_RETRY_LISTENER_PATH = "org.opensearch.action.support.master.MasterThrottlingRetryListener";
    private static final String THROTTLED_PENDING_TASK_COUNT_METHOD_NAME = "numberOfThrottledPendingTasks";
    private static final String RETRYING_TASK_COUNT_METHOD_NAME = "getRetryingTasksCount";
    private final StringBuilder value = new StringBuilder();
    private final PerformanceAnalyzerController controller;
    private final ConfigOverridesWrapper configOverridesWrapper;

    public MasterThrottlingMetricsCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "MasterThrottlingMetricsCollector");
        this.controller = controller;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (!this.controller.isCollectorEnabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        try {
            long mCurrT = System.currentTimeMillis();
            if (OpenSearchResources.INSTANCE.getClusterService() == null || OpenSearchResources.INSTANCE.getClusterService().getMasterService() == null) {
                return;
            }
            if (!this.isMasterThrottlingFeatureAvailable()) {
                LOG.debug("Master Throttling Feature is not available for this domain");
                PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.MASTER_THROTTLING_COLLECTOR_NOT_AVAILABLE, "", (Number)1);
                return;
            }
            this.value.setLength(0);
            this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            this.value.append(new MasterThrottlingMetrics(this.getRetryingPendingTaskCount(), this.getTotalMasterThrottledTaskCount()).serialize());
            this.saveMetricValues(this.value.toString(), startTime, new String[0]);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.MASTER_THROTTLING_COLLECTOR_EXECUTION_TIME, "", (Number)(System.currentTimeMillis() - mCurrT));
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.MASTER_THROTTLING_COLLECTOR_ERROR, "", (Number)1);
            LOG.debug("Exception in Collecting Master Throttling Metrics: {} for startTime {}", new Supplier[]{() -> ex.toString(), () -> startTime});
        }
    }

    private boolean isMasterThrottlingFeatureAvailable() {
        try {
            Class.forName(MASTER_THROTTLING_RETRY_LISTENER_PATH);
            MasterService.class.getMethod(THROTTLED_PENDING_TASK_COUNT_METHOD_NAME, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private long getTotalMasterThrottledTaskCount() throws Exception {
        Method method = MasterService.class.getMethod(THROTTLED_PENDING_TASK_COUNT_METHOD_NAME, new Class[0]);
        return (Long)method.invoke((Object)OpenSearchResources.INSTANCE.getClusterService().getMasterService(), new Object[0]);
    }

    private long getRetryingPendingTaskCount() throws Exception {
        Method method = Class.forName(MASTER_THROTTLING_RETRY_LISTENER_PATH).getMethod(RETRYING_TASK_COUNT_METHOD_NAME, new Class[0]);
        return (Long)method.invoke(null, new Object[0]);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"master_throttling_metrics"});
    }

    public static class MasterThrottlingMetrics
    extends MetricStatus {
        private final long retryingTaskCount;
        private final long throttledPendingTasksCount;

        public MasterThrottlingMetrics(long retryingTaskCount, long throttledPendingTasksCount) {
            this.retryingTaskCount = retryingTaskCount;
            this.throttledPendingTasksCount = throttledPendingTasksCount;
        }

        @JsonProperty(value="Data_RetryingPendingTasksCount")
        public long getRetryingTaskCount() {
            return this.retryingTaskCount;
        }

        @JsonProperty(value="Master_ThrottledPendingTasksCount")
        public long getThrottledPendingTasksCount() {
            return this.throttledPendingTasksCount;
        }
    }
}

