/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex.remote;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Request;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;

final class RemoteRequestBuilders {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RemoteRequestBuilders.class);
    static final String DEPRECATED_URL_ENCODED_INDEX_WARNING = "Specifying index name using URL escaped index names for reindex from remote is deprecated. Instead specify index name without URL escaping.";

    private RemoteRequestBuilders() {
    }

    static Request initialSearch(SearchRequest searchRequest, BytesReference query, Version remoteVersion) {
        StringBuilder path = new StringBuilder("/");
        RemoteRequestBuilders.addIndices(path, searchRequest.indices());
        path.append("_search");
        Request request = new Request("POST", path.toString());
        if (searchRequest.scroll() != null) {
            TimeValue keepAlive = searchRequest.scroll().keepAlive();
            if (remoteVersion.before(Version.fromId((int)5000099))) {
                keepAlive = TimeValue.timeValueMillis((long)((long)Math.ceil(keepAlive.millisFrac())));
            }
            request.addParameter("scroll", keepAlive.getStringRep());
        }
        request.addParameter("size", Integer.toString(searchRequest.source().size()));
        if (searchRequest.source().version() == null || !searchRequest.source().version().booleanValue()) {
            request.addParameter("version", Boolean.FALSE.toString());
        } else {
            request.addParameter("version", Boolean.TRUE.toString());
        }
        if (searchRequest.source().sorts() != null) {
            boolean useScan = false;
            if (remoteVersion.before(Version.fromId((int)2010099))) {
                for (SortBuilder sort : searchRequest.source().sorts()) {
                    FieldSortBuilder f;
                    if (!(sort instanceof FieldSortBuilder) || !(f = (FieldSortBuilder)sort).getFieldName().equals("_doc")) continue;
                    useScan = true;
                    break;
                }
            }
            if (useScan) {
                request.addParameter("search_type", "scan");
            } else {
                StringBuilder sorts = new StringBuilder(RemoteRequestBuilders.sortToUri((SortBuilder)searchRequest.source().sorts().get(0)));
                for (int i = 1; i < searchRequest.source().sorts().size(); ++i) {
                    sorts.append(',').append(RemoteRequestBuilders.sortToUri((SortBuilder)searchRequest.source().sorts().get(i)));
                }
                request.addParameter("sort", sorts.toString());
            }
        }
        if (remoteVersion.before(Version.fromId((int)2000099))) {
            searchRequest.source().storedField("_parent").storedField("_routing").storedField("_ttl");
            if (remoteVersion.before(Version.fromId((int)1000099)) && !searchRequest.source().storedFields().fieldNames().contains("_source")) {
                searchRequest.source().storedField("_source");
            }
        }
        if (searchRequest.source().storedFields() != null && !searchRequest.source().storedFields().fieldNames().isEmpty()) {
            StringBuilder fields = new StringBuilder((String)searchRequest.source().storedFields().fieldNames().get(0));
            for (int i = 1; i < searchRequest.source().storedFields().fieldNames().size(); ++i) {
                fields.append(',').append((String)searchRequest.source().storedFields().fieldNames().get(i));
            }
            String storedFieldsParamName = remoteVersion.before(Version.fromId((int)5000099)) ? "fields" : "stored_fields";
            request.addParameter(storedFieldsParamName, fields.toString());
        }
        if (remoteVersion.onOrAfter(Version.fromId((int)6030099))) {
            request.addParameter("allow_partial_search_results", "false");
        }
        try (XContentBuilder entity = JsonXContent.contentBuilder();
             XContentParser queryParser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)query);){
            entity.startObject();
            entity.field("query");
            entity.copyCurrentStructure(queryParser);
            XContentParser.Token shouldBeEof = queryParser.nextToken();
            if (shouldBeEof != null) {
                throw new OpenSearchException("query was more than a single object. This first token after the object is [" + shouldBeEof + "]", new Object[0]);
            }
            if (searchRequest.source().fetchSource() != null) {
                entity.field("_source", (ToXContent)searchRequest.source().fetchSource());
            } else if (remoteVersion.onOrAfter(Version.fromId((int)1000099))) {
                entity.field("_source", true);
            }
            entity.endObject();
            request.setJsonEntity(Strings.toString((XContentBuilder)entity));
        }
        catch (IOException e) {
            throw new OpenSearchException("unexpected error building entity", (Throwable)e, new Object[0]);
        }
        return request;
    }

    private static void addIndices(StringBuilder path, String[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        path.append(Arrays.stream(indices).map(RemoteRequestBuilders::encodeIndex).collect(Collectors.joining(","))).append('/');
    }

    private static String encodeIndex(String s) {
        if (s.contains("%")) {
            RemoteRequestBuilders.checkIndexOrType("Index", s);
            DEPRECATION_LOGGER.deprecate("reindex_url_encoded_index", DEPRECATED_URL_ENCODED_INDEX_WARNING, new Object[0]);
            return s;
        }
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkIndexOrType(String name, String indexOrType) {
        if (indexOrType.indexOf(44) >= 0) {
            throw new IllegalArgumentException(name + " containing [,] not supported but got [" + indexOrType + "]");
        }
        if (indexOrType.indexOf(47) >= 0) {
            throw new IllegalArgumentException(name + " containing [/] not supported but got [" + indexOrType + "]");
        }
    }

    private static String sortToUri(SortBuilder<?> sort) {
        if (sort instanceof FieldSortBuilder) {
            FieldSortBuilder f = (FieldSortBuilder)sort;
            return f.getFieldName() + ":" + f.order();
        }
        throw new IllegalArgumentException("Unsupported sort [" + sort + "]");
    }

    static Request scroll(String scroll, TimeValue keepAlive, Version remoteVersion) {
        Request request = new Request("POST", "/_search/scroll");
        if (remoteVersion.before(Version.fromId((int)5000099))) {
            keepAlive = TimeValue.timeValueMillis((long)((long)Math.ceil(keepAlive.millisFrac())));
        }
        request.addParameter("scroll", keepAlive.getStringRep());
        if (remoteVersion.before(Version.fromId((int)2000099))) {
            request.setEntity((HttpEntity)new NStringEntity(scroll, ContentType.TEXT_PLAIN));
            return request;
        }
        try (XContentBuilder entity = JsonXContent.contentBuilder();){
            entity.startObject().field("scroll_id", scroll).endObject();
            request.setJsonEntity(Strings.toString((XContentBuilder)entity));
        }
        catch (IOException e) {
            throw new OpenSearchException("failed to build scroll entity", (Throwable)e, new Object[0]);
        }
        return request;
    }

    static Request clearScroll(String scroll, Version remoteVersion) {
        Request request = new Request("DELETE", "/_search/scroll");
        if (remoteVersion.before(Version.fromId((int)2000099))) {
            request.setEntity((HttpEntity)new NStringEntity(scroll, ContentType.TEXT_PLAIN));
            return request;
        }
        try (XContentBuilder entity = JsonXContent.contentBuilder();){
            entity.startObject().array("scroll_id", new String[]{scroll}).endObject();
            request.setJsonEntity(Strings.toString((XContentBuilder)entity));
        }
        catch (IOException e) {
            throw new OpenSearchException("failed to build clear scroll entity", (Throwable)e, new Object[0]);
        }
        return request;
    }
}

