/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionFuture;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.ReindexRequestBuilder;
import org.opensearch.observability.action.GetObservabilityObjectRequest;
import org.opensearch.observability.index.ObservabilityIndex;
import org.opensearch.observability.index.ObservabilityQueryHelper;
import org.opensearch.observability.model.ObservabilityObjectDoc;
import org.opensearch.observability.model.ObservabilityObjectDocInfo;
import org.opensearch.observability.model.ObservabilityObjectSearchResult;
import org.opensearch.observability.model.SearchResults;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.observability.util.HelpersKt;
import org.opensearch.observability.util.SecureIndexClient;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0016\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0004J \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#J$\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001d\u001a\u00020\u0004J\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020,0(2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#J\u0016\u0010.\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0004H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010,2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0019H\u0002J\b\u00105\u001a\u00020\u0019H\u0002J\u0016\u00106\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u00067"}, d2={"Lorg/opensearch/observability/index/ObservabilityIndex;", "", "()V", "INDEX_NAME", "", "MAPPING_TYPE", "NOTEBOOKS_INDEX_NAME", "OBSERVABILITY_MAPPING_FILE_NAME", "OBSERVABILITY_SETTINGS_FILE_NAME", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "mappingsUpdated", "", "searchHitParser", "org/opensearch/observability/index/ObservabilityIndex$searchHitParser$1", "Lorg/opensearch/observability/index/ObservabilityIndex$searchHitParser$1;", "createIndex", "", "createObservabilityObject", "observabilityObjectDoc", "Lorg/opensearch/observability/model/ObservabilityObjectDoc;", "id", "deleteObservabilityObject", "deleteObservabilityObjects", "", "Lorg/opensearch/rest/RestStatus;", "ids", "", "getAllObservabilityObjects", "Lorg/opensearch/observability/model/ObservabilityObjectSearchResult;", "tenant", "access", "", "request", "Lorg/opensearch/observability/action/GetObservabilityObjectRequest;", "getObservabilityObject", "Lorg/opensearch/observability/model/ObservabilityObjectDocInfo;", "getObservabilityObjects", "initialize", "isIndexExists", "index", "parseObservabilityObjectDoc", "response", "Lorg/opensearch/action/get/GetResponse;", "reindexNotebooks", "updateMappings", "updateObservabilityObject", "opensearch-observability"})
public final class ObservabilityIndex {
    @NotNull
    public static final ObservabilityIndex INSTANCE = new ObservabilityIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ObservabilityIndex.class);
    @NotNull
    private static final String INDEX_NAME = ".opensearch-observability";
    @NotNull
    private static final String NOTEBOOKS_INDEX_NAME = ".opensearch-notebooks";
    @NotNull
    private static final String OBSERVABILITY_MAPPING_FILE_NAME = "observability-mapping.yml";
    @NotNull
    private static final String OBSERVABILITY_SETTINGS_FILE_NAME = "observability-settings.yml";
    @NotNull
    private static final String MAPPING_TYPE = "_doc";
    private static boolean mappingsUpdated;
    private static Client client;
    private static ClusterService clusterService;
    @NotNull
    private static final searchHitParser.1 searchHitParser;

    private ObservabilityIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ObservabilityIndex.client = new SecureIndexClient(client);
        ObservabilityIndex.clusterService = clusterService;
        mappingsUpdated = false;
    }

    private final void createIndex() {
        if (!this.isIndexExists(INDEX_NAME)) {
            block11: {
                String string;
                Object object;
                Object object2;
                String string2;
                ClassLoader classLoader = ObservabilityIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(OBSERVABILITY_MAPPING_FILE_NAME);
                if (uRL == null) {
                    string2 = null;
                } else {
                    URL uRL2 = uRL;
                    object2 = Charsets.UTF_8;
                    object = TextStreamsKt.readBytes((URL)uRL2);
                    string2 = new String((byte[])object, (Charset)object2);
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(OBSERVABILITY_SETTINGS_FILE_NAME);
                if (uRL3 == null) {
                    string = null;
                } else {
                    object2 = uRL3;
                    object = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object2);
                    string = new String(byArray, (Charset)object);
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(INDEX_NAME).mapping(indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    ActionFuture actionFuture;
                    CreateIndexResponse response;
                    Client client = ObservabilityIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (CreateIndexResponse)(actionFuture = client.admin().indices().create(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        throw new IllegalStateException("observability:Index .opensearch-observability creation not Acknowledged");
                    }
                    this.getLog().info("observability:Index .opensearch-observability creation Acknowledged");
                    this.reindexNotebooks();
                }
                catch (Exception exception) {
                    if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) break block11;
                    throw exception;
                }
            }
            mappingsUpdated = true;
        } else if (!mappingsUpdated) {
            this.updateMappings();
        }
    }

    private final void updateMappings() {
        String[] stringArray;
        String string;
        ClassLoader classLoader = ObservabilityIndex.class.getClassLoader();
        String[] stringArray2 = classLoader.getResource(OBSERVABILITY_MAPPING_FILE_NAME);
        if (stringArray2 == null) {
            string = null;
        } else {
            stringArray = stringArray2;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
            string = new String(byArray, charset);
        }
        Intrinsics.checkNotNull(string);
        String indexMappingSource = string;
        stringArray = new String[]{INDEX_NAME};
        PutMappingRequest request = new PutMappingRequest(stringArray).source(indexMappingSource, XContentType.YAML);
        try {
            ActionFuture actionFuture;
            AcknowledgedResponse response;
            Client client = ObservabilityIndex.client;
            if (client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                client = null;
            }
            if (!(response = (AcknowledgedResponse)(actionFuture = client.admin().indices().putMapping(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                throw new IllegalStateException("observability:Index .opensearch-observability update mapping not Acknowledged");
            }
            this.getLog().info("observability:Index .opensearch-observability update mapping Acknowledged");
            mappingsUpdated = true;
        }
        catch (IndexNotFoundException exception) {
            this.getLog().error("observability:IndexNotFoundException:", (Throwable)exception);
        }
    }

    private final void reindexNotebooks() {
        block8: {
            if (this.isIndexExists(NOTEBOOKS_INDEX_NAME)) {
                try {
                    Object object;
                    BulkByScrollResponse reindexResponse;
                    this.getLog().info("observability:Index - reindex .opensearch-notebooks to .opensearch-observability");
                    Client client = ObservabilityIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if ((reindexResponse = (BulkByScrollResponse)((ReindexRequestBuilder)((ReindexRequestBuilder)((ReindexRequestBuilder)new ReindexRequestBuilder((OpenSearchClient)client, (ActionType)ReindexAction.INSTANCE).source(object = new String[]{NOTEBOOKS_INDEX_NAME})).destination(INDEX_NAME).abortOnVersionConflict(false)).refresh(true)).get()).isTimedOut()) {
                        throw new IllegalStateException("observability:Index - reindex .opensearch-notebooks timed out");
                    }
                    object = reindexResponse.getSearchFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reindexResponse.searchFailures");
                    if (!((Collection)object).isEmpty()) {
                        throw new IllegalStateException("observability:Index - reindex .opensearch-notebooks failed with searchFailures");
                    }
                    object = reindexResponse.getBulkFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reindexResponse.bulkFailures");
                    if (!((Collection)object).isEmpty()) {
                        throw new IllegalStateException("observability:Index - reindex .opensearch-notebooks failed with bulkFailures");
                    }
                    if (reindexResponse.getTotal() != reindexResponse.getCreated() + reindexResponse.getUpdated()) {
                        throw new IllegalStateException("observability:Index - reindex number of docs created:" + reindexResponse.getCreated() + " + updated:" + reindexResponse.getUpdated() + " does not equal requested:" + reindexResponse.getTotal());
                    }
                    this.getLog().info("observability:Index - reindex " + reindexResponse.getCreated() + " docs created and " + reindexResponse.getUpdated() + " docs updated in .opensearch-observability");
                }
                catch (Exception exception) {
                    if (exception instanceof ResourceNotFoundException || exception.getCause() instanceof ResourceNotFoundException) break block8;
                    throw exception;
                }
            }
        }
    }

    private final boolean isIndexExists(String index) {
        ClusterService clusterService = ObservabilityIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(index);
    }

    @Nullable
    public final String createObservabilityObject(@NotNull ObservabilityObjectDoc observabilityObjectDoc, @Nullable String id) {
        String string;
        ActionFuture actionFuture;
        IndexResponse response;
        Client client;
        Intrinsics.checkNotNullParameter((Object)observabilityObjectDoc, (String)"observabilityObjectDoc");
        this.createIndex();
        XContentBuilder xContent = ObservabilityObjectDoc.toXContent$default(observabilityObjectDoc, null, 1, null);
        IndexRequest indexRequest = new IndexRequest(INDEX_NAME).source(xContent).create(true);
        if (id != null) {
            indexRequest.id(id);
        }
        if ((client = ObservabilityIndex.client) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.CREATED) {
            this.getLog().warn("observability:createObservabilityObject - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    public static /* synthetic */ String createObservabilityObject$default(ObservabilityIndex observabilityIndex, ObservabilityObjectDoc observabilityObjectDoc, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return observabilityIndex.createObservabilityObject(observabilityObjectDoc, string);
    }

    @Nullable
    public final ObservabilityObjectDocInfo getObservabilityObject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(INDEX_NAME).id(id);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.get(getRequest);
        GetResponse response = (GetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return this.parseObservabilityObjectDoc(id, response);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ObservabilityObjectDocInfo> getObservabilityObjects(@NotNull Set<String> ids) {
        void $this$mapNotNullTo$iv$iv;
        Object[] it;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.createIndex();
        MultiGetRequest getRequest = new MultiGetRequest();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Object[])element$iv;
            boolean bl = false;
            getRequest.add(INDEX_NAME, (String)it);
        }
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.multiGet(getRequest);
        MultiGetResponse response = (MultiGetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        MultiGetItemResponse[] multiGetItemResponseArray = response.getResponses();
        Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"response.responses");
        Object[] $this$mapNotNull$iv = multiGetItemResponseArray;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            ObservabilityObjectDocInfo it$iv$iv;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            MultiGetItemResponse it2 = (MultiGetItemResponse)element$iv$iv;
            boolean bl2 = false;
            String string = it2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            String string2 = string;
            string = it2.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.response");
            if (INSTANCE.parseObservabilityObjectDoc(string2, (GetResponse)string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ObservabilityObjectDocInfo parseObservabilityObjectDoc(String id, GetResponse response) {
        ObservabilityObjectDocInfo observabilityObjectDocInfo;
        if (response.getSourceAsString() == null) {
            this.getLog().warn("observability:getObservabilityObject - " + id + " not found; response:" + response);
            observabilityObjectDocInfo = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            ObservabilityObjectDoc doc = ObservabilityObjectDoc.Companion.parse(parser, id);
            observabilityObjectDocInfo = new ObservabilityObjectDocInfo(id, response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), doc);
        }
        return observabilityObjectDocInfo;
    }

    @NotNull
    public final ObservabilityObjectSearchResult getAllObservabilityObjects(@NotNull String tenant, @NotNull List<String> access, @NotNull GetObservabilityObjectRequest request) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.createIndex();
        ObservabilityQueryHelper queryHelper = new ObservabilityQueryHelper(request.getTypes());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).size(request.getMaxItems()).from(request.getFromIndex());
        Intrinsics.checkNotNullExpressionValue((Object)sourceBuilder, (String)"sourceBuilder");
        queryHelper.addSortField(sourceBuilder, request.getSortField(), request.getSortOrder());
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        String[] stringArray = new String[]{tenant};
        query.filter((QueryBuilder)QueryBuilders.termsQuery((String)"tenant", (String[])stringArray));
        if (!((Collection)access).isEmpty()) {
            query.filter((QueryBuilder)QueryBuilders.termsQuery((String)"access", (Collection)access));
        }
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"query");
        queryHelper.addTypeFilters(query);
        queryHelper.addQueryFilters(query, request.getFilterParams());
        sourceBuilder.query((QueryBuilder)query);
        String[] stringArray2 = new String[]{INDEX_NAME};
        SearchRequest searchRequest = new SearchRequest().indices(stringArray2).source(sourceBuilder);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = request.getFromIndex();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        ObservabilityObjectSearchResult result = new ObservabilityObjectSearchResult(l, response, searchHitParser);
        this.getLog().info("observability:getAllObservabilityObjects types:" + request.getTypes() + " from:" + request.getFromIndex() + ", maxItems:" + request.getMaxItems() + ", sortField:" + request.getSortField() + ", sortOrder=" + request.getSortOrder() + ", filters=" + request.getFilterParams() + " retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateObservabilityObject(@NotNull String id, @NotNull ObservabilityObjectDoc observabilityObjectDoc) {
        ActionFuture actionFuture;
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)observabilityObjectDoc, (String)"observabilityObjectDoc");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(INDEX_NAME)).id(id).doc(ObservabilityObjectDoc.toXContent$default(observabilityObjectDoc, null, 1, null)).fetchSource(true);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (UpdateResponse)(actionFuture = client.update(updateRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("observability:updateObservabilityObject failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteObservabilityObject(@NotNull String id) {
        ActionFuture actionFuture;
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(id);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (DeleteResponse)(actionFuture = client.delete(deleteRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.DELETED) {
            this.getLog().warn("observability:deleteObservabilityObject failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }

    @NotNull
    public final Map<String, RestStatus> deleteObservabilityObjects(@NotNull Set<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.createIndex();
        BulkRequest bulkRequest = new BulkRequest();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(it);
            bulkRequest.add(deleteRequest);
        }
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.bulk(bulkRequest);
        BulkResponse response = (BulkResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Map mutableMap = new LinkedHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        Iterable $this$forEach$iv2 = (Iterable)response;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            BulkItemResponse it = (BulkItemResponse)element$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            RestStatus restStatus = it.status();
            Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"it.status()");
            mutableMap.put(string, restStatus);
            if (!it.isFailed()) continue;
            INSTANCE.getLog().warn("observability:deleteObservabilityObjects failed for " + it.getId() + "; response:" + it.getFailureMessage());
        }
        return mutableMap;
    }

    static {
        searchHitParser = new SearchResults.SearchHitParser<ObservabilityObjectDoc>(){

            @NotNull
            public ObservabilityObjectDoc parse(@NotNull SearchHit searchHit) {
                Intrinsics.checkNotNullParameter((Object)searchHit, (String)"searchHit");
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchHit.getSourceAsString());
                parser.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
                return ObservabilityObjectDoc.Companion.parse(parser, searchHit.getId());
            }
        };
    }
}

