/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.breaker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.breaker.BreakerName;
import org.opensearch.ml.common.breaker.CircuitBreaker;
import org.opensearch.ml.common.breaker.MemoryCircuitBreaker;
import org.opensearch.monitor.jvm.JvmService;

public class MLCircuitBreakerService {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCircuitBreakerService.class);
    private final ConcurrentMap<BreakerName, CircuitBreaker> breakers = new ConcurrentHashMap<BreakerName, CircuitBreaker>();
    private final JvmService jvmService;

    public MLCircuitBreakerService(JvmService jvmService) {
        this.jvmService = jvmService;
    }

    public void registerBreaker(BreakerName name, CircuitBreaker breaker) {
        this.breakers.putIfAbsent(name, breaker);
    }

    public void unregisterBreaker(BreakerName name) {
        if (name == null) {
            return;
        }
        this.breakers.remove((Object)name);
        log.info("Removed ML breakers " + name);
    }

    public void clearBreakers() {
        this.breakers.clear();
        log.info("Cleared ML breakers.");
    }

    public CircuitBreaker getBreaker(BreakerName name) {
        return (CircuitBreaker)this.breakers.get((Object)name);
    }

    public MLCircuitBreakerService init() {
        this.registerBreaker(BreakerName.MEMORY, new MemoryCircuitBreaker(this.jvmService));
        log.info("Registered ML memory breaker.");
        return this;
    }

    public Boolean isOpen() {
        for (CircuitBreaker breaker : this.breakers.values()) {
            if (!breaker.isOpen()) continue;
            return true;
        }
        return false;
    }
}

