/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class GCMetrics {
    private static GarbageCollectorMXBean fullGC = null;
    private static GarbageCollectorMXBean youngGC = null;
    private static long totYoungGCCollectionCount = 0L;
    private static long totYoungGCCollectionTime = 0L;
    private static long totFullGCCollectionCount = 0L;
    private static long totFullGCCollectionTime = 0L;
    private static long lastYoungGCCollectionCount = 0L;
    private static long lastYoungGCCollectionTime = 0L;
    private static long lastFullGCCollectionCount = 0L;
    private static long lastFullGCCollectionTime = 0L;
    private static final Logger LOGGER = LogManager.getLogger(GCMetrics.class);

    public static long getTotYoungGCCollectionCount() {
        return totYoungGCCollectionCount;
    }

    public static long getTotYoungGCCollectionTime() {
        return totYoungGCCollectionTime;
    }

    public static long getTotFullGCCollectionCount() {
        return totFullGCCollectionCount;
    }

    public static long getTotFullGCCollectionTime() {
        return totFullGCCollectionTime;
    }

    private static long getYoungGCCollectionCount() {
        if (youngGC == null) {
            return 0L;
        }
        return youngGC.getCollectionCount();
    }

    private static long getYoungGCCollectionTime() {
        if (youngGC == null) {
            return 0L;
        }
        return youngGC.getCollectionTime();
    }

    private static long getFullGCCollectionCount() {
        if (fullGC == null) {
            return 0L;
        }
        return fullGC.getCollectionCount();
    }

    private static long getFullGCCollectionTime() {
        if (fullGC == null) {
            return 0L;
        }
        return fullGC.getCollectionTime();
    }

    public static void runGCMetrics() {
        long YoungGCCollectionCount = GCMetrics.getYoungGCCollectionCount();
        long YoungGCCollectionTime = GCMetrics.getYoungGCCollectionTime();
        long FullGCCollectionCount = GCMetrics.getFullGCCollectionCount();
        long FullGCCollectionTime = GCMetrics.getFullGCCollectionTime();
        totYoungGCCollectionCount = YoungGCCollectionCount - lastYoungGCCollectionCount;
        totYoungGCCollectionTime = YoungGCCollectionTime - lastYoungGCCollectionTime;
        totFullGCCollectionCount = FullGCCollectionCount - lastFullGCCollectionCount;
        totFullGCCollectionTime = FullGCCollectionTime - lastFullGCCollectionTime;
        lastYoungGCCollectionCount = YoungGCCollectionCount;
        lastYoungGCCollectionTime = YoungGCCollectionTime;
        lastFullGCCollectionCount = FullGCCollectionCount;
        lastFullGCCollectionTime = FullGCCollectionTime;
    }

    static void printGCMetrics() {
        if (lastYoungGCCollectionCount >= 0L) {
            System.out.println("GC:: yC:" + GCMetrics.getTotYoungGCCollectionCount() + " yT:" + GCMetrics.getTotYoungGCCollectionTime() + " oC:" + GCMetrics.getTotFullGCCollectionCount() + " oT:" + GCMetrics.getTotFullGCCollectionTime());
        }
    }

    static {
        for (GarbageCollectorMXBean item : ManagementFactory.getGarbageCollectorMXBeans()) {
            if ("ConcurrentMarkSweep".equals(item.getName()) || "MarkSweepCompact".equals(item.getName()) || "PS MarkSweep".equals(item.getName()) || "G1 Old Generation".equals(item.getName()) || "Garbage collection optimized for short pausetimes Old Collector".equals(item.getName()) || "Garbage collection optimized for throughput Old Collector".equals(item.getName()) || "Garbage collection optimized for deterministic pausetimes Old Collector".equals(item.getName())) {
                fullGC = item;
                continue;
            }
            if ("ParNew".equals(item.getName()) || "Copy".equals(item.getName()) || "PS Scavenge".equals(item.getName()) || "G1 Young Generation".equals(item.getName()) || "Garbage collection optimized for short pausetimes Young Collector".equals(item.getName()) || "Garbage collection optimized for throughput Young Collector".equals(item.getName()) || "Garbage collection optimized for deterministic pausetimes Young Collector".equals(item.getName())) {
                youngGC = item;
                continue;
            }
            LOGGER.error("MX bean missing: {}", new Supplier[]{() -> item.getName()});
        }
    }
}

