/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.stats.IndicesStatsAction;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.Index;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.seqno.SeqNoStats;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.TransformSearchService;
import org.opensearch.indexmanagement.transform.exceptions.TransformSearchServiceException;
import org.opensearch.indexmanagement.transform.model.BucketSearchResult;
import org.opensearch.indexmanagement.transform.model.ShardNewDocuments;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.model.TransformSearchResult;
import org.opensearch.indexmanagement.transform.model.TransformStats;
import org.opensearch.indexmanagement.transform.settings.TransformSettings;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.aggregations.metrics.Percentiles;
import org.opensearch.search.aggregations.metrics.ScriptedMetric;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.RemoteTransportException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JO\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00192\u001c\b\u0002\u0010\u001b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00010\u0019\u0018\u00010\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ7\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J%\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u00192\u0006\u0010&\u001a\u00020\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformSearchService;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/client/Client;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/client/Client;)V", "backoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "kotlin.jvm.PlatformType", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "logger", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "calculateMaxPageSize", "", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "executeCompositeSearch", "Lorg/opensearch/indexmanagement/transform/model/TransformSearchResult;", "afterKey", "", "", "modifiedBuckets", "", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Ljava/util/Map;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getShardLevelModifiedBuckets", "Lorg/opensearch/indexmanagement/transform/model/BucketSearchResult;", "currentShard", "Lorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Ljava/util/Map;Lorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getShardsGlobalCheckpoint", "Lorg/opensearch/index/shard/ShardId;", "", "index", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
public final class TransformSearchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Client client;
    private Logger logger;
    private volatile BackoffPolicy backoffPolicy;
    @NotNull
    public static final String failedSearchErrorMessage = "Failed to search data in source indices";
    @NotNull
    public static final String modifiedBucketsErrorMessage = "Failed to get the modified buckets in source indices";
    @NotNull
    public static final String getShardsErrorMessage = "Failed to get the shards in the source indices";

    public TransformSearchService(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.settings = settings;
        this.clusterService = clusterService;
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_MILLIS().get(this.settings);
        Object object = TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_COUNT().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"TRANSFORM_JOB_SEARCH_BACKOFF_COUNT.get(settings)");
        this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_MILLIS(), TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_COUNT(), (arg_0, arg_1) -> TransformSearchService._init_$lambda-0(this, arg_0, arg_1));
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getShardsGlobalCheckpoint(@NotNull String var1_1, @NotNull Continuation<? super Map<ShardId, Long>> var2_2) {
        if (!(var2_2 instanceof getShardsGlobalCheckpoint.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ TransformSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getShardsGlobalCheckpoint(null, (Continuation<? super Map<ShardId, Long>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryAttempt = new Ref.IntRef();
                retryAttempt.element = 1;
                var5_11 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var5_11, (String)"backoffPolicy");
                v0 = var5_11;
                var5_11 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var5_11, (String)"logger");
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry(v0, (Logger)var5_11, CollectionsKt.listOf((Object)RestStatus.NOT_FOUND), (Function2)new Function2<TimeValue, Continuation<? super IndicesStatsResponse>, Object>((String)index, retryAttempt, this, null){
                    int label;
                    final /* synthetic */ String $index;
                    final /* synthetic */ Ref.IntRef $retryAttempt;
                    final /* synthetic */ TransformSearchService this$0;
                    {
                        this.$index = $index;
                        this.$retryAttempt = $retryAttempt;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                String[] stringArray = new String[]{this.$index};
                                IndicesStatsRequest request = ((IndicesStatsRequest)new IndicesStatsRequest().indices(stringArray)).clear();
                                if (this.$retryAttempt.element > 1) {
                                    TransformSearchService.access$getLogger$p(this.this$0).debug(org.opensearch.indexmanagement.transform.TransformSearchService$Companion.access$getShardsRetryMessage(TransformSearchService.Companion, this.$retryAttempt.element));
                                }
                                int n = this.$retryAttempt.element;
                                this.$retryAttempt.element = n + 1;
                                this.label = 1;
                                Object object3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformSearchService.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<IndicesStatsResponse>, Unit>(request){
                                    final /* synthetic */ IndicesStatsRequest $request;
                                    {
                                        this.$request = $request;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndicesStatsResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)this.$request, it);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super IndicesStatsResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v1 != var8_5) goto lbl25
lbl24:
                // 1 sources

                return var8_5;
lbl25:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    if ((searchResponse = (IndicesStatsResponse)v1).getStatus() == RestStatus.OK) {
                        return TransformSearchService.Companion.convertIndicesStatsResponse(searchResponse);
                    }
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices - " + searchResponse.getStatus(), null, 2, null);
                }
                catch (TransformSearchServiceException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    unwrappedException = (Exception)v2;
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getShardLevelModifiedBuckets(@NotNull Transform var1_1, @Nullable Map<String, ? extends Object> var2_2, @NotNull ShardNewDocuments var3_3, @NotNull Continuation<? super BucketSearchResult> var4_4) {
        if (!(var4_4 instanceof getShardLevelModifiedBuckets.1)) ** GOTO lbl-1000
        var10_5 = var4_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransformSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getShardLevelModifiedBuckets(null, null, null, (Continuation<? super BucketSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryAttempt = new Ref.IntRef();
                pageSize = new Ref.IntRef();
                pageSize.element = this.calculateMaxPageSize(transform);
                var8_15 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var8_15, (String)"backoffPolicy");
                v0 = var8_15;
                var8_15 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var8_15, (String)"logger");
                $continuation.L$0 = transform;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry$default(v0, (Logger)var8_15, null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(retryAttempt, this, pageSize, transform, (Map<String, ? extends Object>)afterKey, (ShardNewDocuments)currentShard, null){
                    int label;
                    final /* synthetic */ Ref.IntRef $retryAttempt;
                    final /* synthetic */ TransformSearchService this$0;
                    final /* synthetic */ Ref.IntRef $pageSize;
                    final /* synthetic */ Transform $transform;
                    final /* synthetic */ Map<String, Object> $afterKey;
                    final /* synthetic */ ShardNewDocuments $currentShard;
                    {
                        this.$retryAttempt = $retryAttempt;
                        this.this$0 = $receiver;
                        this.$pageSize = $pageSize;
                        this.$transform = $transform;
                        this.$afterKey = $afterKey;
                        this.$currentShard = $currentShard;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                int n = this.$retryAttempt.element;
                                this.$retryAttempt.element = n + 1;
                                float pageSizeDecay = (float)Math.pow(2.0f, n);
                                this.label = 1;
                                Object object3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformSearchService.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this.$pageSize, pageSizeDecay, this.$retryAttempt, this.this$0, this.$transform, this.$afterKey, this.$currentShard){
                                    final /* synthetic */ Ref.IntRef $pageSize;
                                    final /* synthetic */ float $pageSizeDecay;
                                    final /* synthetic */ Ref.IntRef $retryAttempt;
                                    final /* synthetic */ TransformSearchService this$0;
                                    final /* synthetic */ Transform $transform;
                                    final /* synthetic */ Map<String, Object> $afterKey;
                                    final /* synthetic */ ShardNewDocuments $currentShard;
                                    {
                                        this.$pageSize = $pageSize;
                                        this.$pageSizeDecay = $pageSizeDecay;
                                        this.$retryAttempt = $retryAttempt;
                                        this.this$0 = $receiver;
                                        this.$transform = $transform;
                                        this.$afterKey = $afterKey;
                                        this.$currentShard = $currentShard;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> listener) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(listener, (String)"listener");
                                        this.$pageSize.element = Math.max(1, this.$pageSize.element / (int)this.$pageSizeDecay);
                                        if (this.$retryAttempt.element > 1) {
                                            TransformSearchService.access$getLogger$p(this.this$0).debug("Attempt [" + (this.$retryAttempt.element - 1) + "] to get modified buckets for transform [" + this.$transform.getId() + "]. Attempting again with reduced page size [" + this.$pageSize.element + "]");
                                        }
                                        SearchRequest request = TransformSearchService.Companion.getShardLevelBucketsSearchRequest(this.$transform, this.$afterKey, this.$pageSize.element, this.$currentShard);
                                        $this$suspendUntil.search(request, listener);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super SearchResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v1 != var11_7) goto lbl27
lbl26:
                // 1 sources

                return var11_7;
lbl27:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                transform = (Transform)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl34:
                    // 2 sources

                    searchResponse = (SearchResponse)v1;
                    return org.opensearch.indexmanagement.transform.TransformSearchService$Companion.access$convertBucketSearchResponse(TransformSearchService.Companion, transform, searchResponse);
                }
                catch (TransformSearchServiceException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    unwrappedException = (Exception)v2;
                    throw new TransformSearchServiceException("Failed to get the modified buckets in source indices", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformSearchServiceException("Failed to get the modified buckets in source indices - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformSearchServiceException("Failed to get the modified buckets in source indices", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int calculateMaxPageSize(Transform transform2) {
        return Math.min(transform2.getPageSize(), 1024 / (transform2.getGroups().size() + 1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeCompositeSearch(@NotNull Transform var1_1, @Nullable Map<String, ? extends Object> var2_2, @Nullable Set<Map<String, Object>> var3_3, @NotNull Continuation<? super TransformSearchResult> var4_4) {
        if (!(var4_4 instanceof executeCompositeSearch.1)) ** GOTO lbl-1000
        var10_5 = var4_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TransformSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeCompositeSearch(null, null, null, (Continuation<? super TransformSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pageSize = new Ref.IntRef();
                var6_13 = modifiedBuckets;
                pageSize.element = (var6_13 == null || var6_13.isEmpty() != false) != false ? transform.getPageSize() : modifiedBuckets.size();
                retryAttempt = new Ref.IntRef();
                var8_15 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var8_15, (String)"backoffPolicy");
                v0 = var8_15;
                var8_15 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var8_15, (String)"logger");
                $continuation.L$0 = transform;
                $continuation.L$1 = modifiedBuckets;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry$default(v0, (Logger)var8_15, null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(retryAttempt, this, pageSize, transform, (Map<String, ? extends Object>)afterKey, (Set<Map<String, Object>>)modifiedBuckets, null){
                    int label;
                    final /* synthetic */ Ref.IntRef $retryAttempt;
                    final /* synthetic */ TransformSearchService this$0;
                    final /* synthetic */ Ref.IntRef $pageSize;
                    final /* synthetic */ Transform $transform;
                    final /* synthetic */ Map<String, Object> $afterKey;
                    final /* synthetic */ Set<Map<String, Object>> $modifiedBuckets;
                    {
                        this.$retryAttempt = $retryAttempt;
                        this.this$0 = $receiver;
                        this.$pageSize = $pageSize;
                        this.$transform = $transform;
                        this.$afterKey = $afterKey;
                        this.$modifiedBuckets = $modifiedBuckets;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                int n = this.$retryAttempt.element;
                                this.$retryAttempt.element = n + 1;
                                float pageSizeDecay = (float)Math.pow(2.0f, n);
                                this.label = 1;
                                Object object3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformSearchService.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this.$pageSize, pageSizeDecay, this.$retryAttempt, this.this$0, this.$transform, this.$afterKey, this.$modifiedBuckets){
                                    final /* synthetic */ Ref.IntRef $pageSize;
                                    final /* synthetic */ float $pageSizeDecay;
                                    final /* synthetic */ Ref.IntRef $retryAttempt;
                                    final /* synthetic */ TransformSearchService this$0;
                                    final /* synthetic */ Transform $transform;
                                    final /* synthetic */ Map<String, Object> $afterKey;
                                    final /* synthetic */ Set<Map<String, Object>> $modifiedBuckets;
                                    {
                                        this.$pageSize = $pageSize;
                                        this.$pageSizeDecay = $pageSizeDecay;
                                        this.$retryAttempt = $retryAttempt;
                                        this.this$0 = $receiver;
                                        this.$transform = $transform;
                                        this.$afterKey = $afterKey;
                                        this.$modifiedBuckets = $modifiedBuckets;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> listener) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(listener, (String)"listener");
                                        this.$pageSize.element = Math.max(1, this.$pageSize.element / (int)this.$pageSizeDecay);
                                        if (this.$retryAttempt.element > 1) {
                                            TransformSearchService.access$getLogger$p(this.this$0).debug("Attempt [" + (this.$retryAttempt.element - 1) + "] of composite search failed for transform [" + this.$transform.getId() + "]. Attempting again with reduced page size [" + this.$pageSize.element + "]");
                                        }
                                        SearchRequest request = TransformSearchService.Companion.getSearchServiceRequest(this.$transform, this.$afterKey, this.$pageSize.element, this.$modifiedBuckets);
                                        $this$suspendUntil.search(request, listener);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super SearchResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v1 != var11_7) goto lbl29
lbl28:
                // 1 sources

                return var11_7;
lbl29:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                modifiedBuckets = (Set)$continuation.L$1;
                transform = (Transform)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    searchResponse = (SearchResponse)v1;
                    return org.opensearch.indexmanagement.transform.TransformSearchService$Companion.convertResponse$default(TransformSearchService.Companion, transform, searchResponse, false, modifiedBuckets, 4, null);
                }
                catch (TransformSearchServiceException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    unwrappedException = (Exception)v2;
                    throw new TransformSearchServiceException("Failed to search data in source indices", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformSearchServiceException("Failed to search data in source indices - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformSearchServiceException("Failed to search data in source indices", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object executeCompositeSearch$default(TransformSearchService transformSearchService, Transform transform2, Map map, Set set, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        return transformSearchService.executeCompositeSearch(transform2, map, set, (Continuation<? super TransformSearchResult>)continuation);
    }

    private static final void _init_$lambda-0(TransformSearchService this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        this$0.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    public static final /* synthetic */ Logger access$getLogger$p(TransformSearchService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Client access$getClient$p(TransformSearchService $this) {
        return $this.client;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J>\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u001c\b\u0002\u0010\u0017\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000e\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000e0\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002JL\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020*2\u001c\b\u0002\u0010\u0017\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000e\u0018\u00010\u0018J\u001f\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00102\u0006\u0010.\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010/J6\u00100\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020*H\u0002J\u0010\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformSearchService$Companion;", "", "()V", "failedSearchErrorMessage", "", "getShardsErrorMessage", "modifiedBucketsErrorMessage", "convertBucketSearchResponse", "Lorg/opensearch/indexmanagement/transform/model/BucketSearchResult;", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "searchResponse", "Lorg/opensearch/action/search/SearchResponse;", "convertIndicesStatsResponse", "", "Lorg/opensearch/index/shard/ShardId;", "", "response", "Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;", "convertResponse", "Lorg/opensearch/indexmanagement/transform/model/TransformSearchResult;", "waterMarkDocuments", "", "modifiedBuckets", "", "getAggregationValue", "aggregation", "Lorg/opensearch/search/aggregations/Aggregation;", "getQueryWithModifiedBuckets", "Lorg/opensearch/index/query/QueryBuilder;", "originalQuery", "groups", "", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "getSearchServiceRequest", "Lorg/opensearch/action/search/SearchRequest;", "index", "query", "aggregationBuilder", "Lorg/opensearch/search/aggregations/bucket/composite/CompositeAggregationBuilder;", "afterKey", "pageSize", "", "getSeqNoRangeQuery", "Lorg/opensearch/index/query/RangeQueryBuilder;", "from", "to", "(Ljava/lang/Long;J)Lorg/opensearch/index/query/RangeQueryBuilder;", "getShardLevelBucketsSearchRequest", "currentShard", "Lorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;", "getShardsRetryMessage", "attemptNumber", "noTransformGroupErrorMessage", "bucketField", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        private final String getShardsRetryMessage(int attemptNumber) {
            return "Attempt [" + attemptNumber + "] to get shard global checkpoint numbers";
        }

        private final String noTransformGroupErrorMessage(String bucketField) {
            return "Failed to find a transform group matching the bucket field [" + bucketField + "]";
        }

        @NotNull
        public final SearchRequest getSearchServiceRequest(@NotNull Transform transform2, @Nullable Map<String, ? extends Object> afterKey, int pageSize, @Nullable Set<Map<String, Object>> modifiedBuckets) {
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            List sources = new ArrayList();
            Iterable $this$forEach$iv = transform2.getGroups();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Dimension group = (Dimension)element$iv;
                boolean bl = false;
                CompositeValuesSourceBuilder compositeValuesSourceBuilder = Dimension.toSourceBuilder$default(group, false, 1, null).missingBucket(true);
                Intrinsics.checkNotNullExpressionValue((Object)compositeValuesSourceBuilder, (String)"group.toSourceBuilder().missingBucket(true)");
                sources.add(compositeValuesSourceBuilder);
            }
            AbstractAggregationBuilder $i$f$forEach22 = new CompositeAggregationBuilder(transform2.getId(), sources).size(pageSize).subAggregations(transform2.getAggregations());
            CompositeAggregationBuilder $this$getSearchServiceRequest_u24lambda_u2d2 = (CompositeAggregationBuilder)$i$f$forEach22;
            boolean bl = false;
            Map<String, ? extends Object> map = afterKey;
            if (map != null) {
                Map<String, ? extends Object> it = map;
                boolean bl2 = false;
                $this$getSearchServiceRequest_u24lambda_u2d2.aggregateAfter(it);
            }
            CompositeAggregationBuilder aggregationBuilder = (CompositeAggregationBuilder)$i$f$forEach22;
            QueryBuilder query = modifiedBuckets == null ? transform2.getDataSelectionQuery() : this.getQueryWithModifiedBuckets(transform2.getDataSelectionQuery(), modifiedBuckets, transform2.getGroups());
            String string = transform2.getSourceIndex();
            Intrinsics.checkNotNullExpressionValue((Object)aggregationBuilder, (String)"aggregationBuilder");
            return this.getSearchServiceRequest(string, query, aggregationBuilder);
        }

        public static /* synthetic */ SearchRequest getSearchServiceRequest$default(Companion companion, Transform transform2, Map map, int n, Set set, int n2, Object object) {
            if ((n2 & 2) != 0) {
                map = null;
            }
            if ((n2 & 8) != 0) {
                set = null;
            }
            return companion.getSearchServiceRequest(transform2, map, n, set);
        }

        private final QueryBuilder getQueryWithModifiedBuckets(QueryBuilder originalQuery, Set<Map<String, Object>> modifiedBuckets, List<? extends Dimension> groups) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(originalQuery).minimumShouldMatch(1);
            Intrinsics.checkNotNullExpressionValue((Object)boolQueryBuilder, (String)"boolQuery().must(origina\u2026ry).minimumShouldMatch(1)");
            BoolQueryBuilder query = boolQueryBuilder;
            Iterable $this$forEach$iv = modifiedBuckets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map bucket = (Map)element$iv;
                boolean bl = false;
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                Intrinsics.checkNotNullExpressionValue((Object)boolQueryBuilder2, (String)"boolQuery()");
                BoolQueryBuilder bucketQuery = boolQueryBuilder2;
                Map $this$forEach$iv2 = bucket;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    ExistsQueryBuilder subQuery;
                    Object v0;
                    Map.Entry group;
                    block5: {
                        Map.Entry element$iv2;
                        group = element$iv2 = iterator.next();
                        boolean bl2 = false;
                        for (Object t : (Iterable)groups) {
                            Dimension it = (Dimension)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getTargetField(), group.getKey())) continue;
                            v0 = t;
                            break block5;
                        }
                        v0 = null;
                    }
                    Dimension dimension = v0;
                    if (dimension == null) {
                        throw new TransformSearchServiceException(Companion.noTransformGroupErrorMessage((String)group.getKey()), null, 2, null);
                    }
                    Dimension transformGroup = dimension;
                    if (group.getValue() == null) {
                        subQuery = new ExistsQueryBuilder(transformGroup.getSourceField());
                        bucketQuery.mustNot((QueryBuilder)subQuery);
                        continue;
                    }
                    subQuery = transformGroup.toBucketQuery(group.getValue());
                    bucketQuery.filter((QueryBuilder)subQuery);
                }
                query.should((QueryBuilder)bucketQuery);
            }
            return (QueryBuilder)query;
        }

        private final SearchRequest getSearchServiceRequest(String index2, QueryBuilder query, CompositeAggregationBuilder aggregationBuilder) {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().trackTotalHits(false).size(0).aggregation((AggregationBuilder)aggregationBuilder).query(query);
            String[] stringArray = new String[]{index2};
            SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSourceBuilder).allowPartialSearchResults(false);
            Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"SearchRequest(index)\n   \u2026rtialSearchResults(false)");
            return searchRequest;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SearchRequest getShardLevelBucketsSearchRequest(@NotNull Transform transform2, @Nullable Map<String, ? extends Object> afterKey, int pageSize, @NotNull ShardNewDocuments currentShard) {
            CompositeAggregationBuilder compositeAggregationBuilder;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)currentShard, (String)"currentShard");
            RangeQueryBuilder rangeQuery = this.getSeqNoRangeQuery(currentShard.getFrom(), currentShard.getTo());
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)rangeQuery).must(transform2.getDataSelectionQuery());
            Iterable $this$map$iv = transform2.getGroups();
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Dimension dimension = (Dimension)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Dimension.toSourceBuilder$default((Dimension)it, false, 1, null).missingBucket(true));
            }
            List sources = (List)destination$iv$iv;
            CompositeAggregationBuilder $this$getShardLevelBucketsSearchRequest_u24lambda_u2d8 = compositeAggregationBuilder = new CompositeAggregationBuilder(transform2.getId(), sources).size(pageSize);
            boolean bl = false;
            Map<String, ? extends Object> map = afterKey;
            if (map != null) {
                Map<String, ? extends Object> it = map;
                boolean bl2 = false;
                $this$getShardLevelBucketsSearchRequest_u24lambda_u2d8.aggregateAfter(it);
            }
            CompositeAggregationBuilder aggregationBuilder = compositeAggregationBuilder;
            object = currentShard.getShardId().getIndexName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentShard.shardId.indexName");
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"query");
            QueryBuilder queryBuilder = (QueryBuilder)query;
            Intrinsics.checkNotNullExpressionValue((Object)aggregationBuilder, (String)"aggregationBuilder");
            compositeAggregationBuilder = this.getSearchServiceRequest((String)object, queryBuilder, aggregationBuilder).preference("_shards:" + currentShard.getShardId().getId());
            Intrinsics.checkNotNullExpressionValue((Object)compositeAggregationBuilder, (String)"getSearchServiceRequest(\u2026rd.shardId.id.toString())");
            return compositeAggregationBuilder;
        }

        public static /* synthetic */ SearchRequest getShardLevelBucketsSearchRequest$default(Companion companion, Transform transform2, Map map, int n, ShardNewDocuments shardNewDocuments, int n2, Object object) {
            if ((n2 & 2) != 0) {
                map = null;
            }
            return companion.getShardLevelBucketsSearchRequest(transform2, map, n, shardNewDocuments);
        }

        private final RangeQueryBuilder getSeqNoRangeQuery(Long from, long to) {
            RangeQueryBuilder rangeQuery = new RangeQueryBuilder("_seq_no");
            if (to >= 0L) {
                rangeQuery.to((Object)to, true);
            }
            if (from != null && from >= 0L) {
                rangeQuery.from((Object)from, false);
            }
            return rangeQuery;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TransformSearchResult convertResponse(@NotNull Transform transform2, @NotNull SearchResponse searchResponse2, boolean waterMarkDocuments, @Nullable Set<Map<String, Object>> modifiedBuckets) {
            void $this$fold$iv;
            List list;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
            Aggregation aggregation = searchResponse2.getAggregations().get(transform2.getId());
            if (aggregation == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.composite.CompositeAggregation");
            }
            CompositeAggregation aggs = (CompositeAggregation)aggregation;
            if (modifiedBuckets != null) {
                List list2 = aggs.getBuckets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"aggs.buckets");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Iterator element$iv$iv : $this$filterTo$iv$iv) {
                    CompositeAggregation.Bucket it = (CompositeAggregation.Bucket)element$iv$iv;
                    boolean bl = false;
                    if (!modifiedBuckets.contains(it.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = aggs.getBuckets();
            }
            List buckets = list;
            Intrinsics.checkNotNullExpressionValue((Object)buckets, (String)"buckets");
            $this$filterTo$iv$iv = buckets;
            long initial$iv = 0L;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void it;
                CompositeAggregation.Bucket bl = (CompositeAggregation.Bucket)element$iv;
                long sum = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = sum + it.getDocCount();
            }
            long documentsProcessed = accumulator$iv;
            long pagesProcessed = 1L;
            long searchTime = searchResponse2.getTook().getMillis();
            TransformStats stats = new TransformStats(pagesProcessed, documentsProcessed, 0L, 0L, searchTime);
            Map afterKey = aggs.afterKey();
            List docsToIndex = new ArrayList();
            Iterable $this$forEach$iv = buckets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                CompositeAggregation.Bucket aggregatedBucket = (CompositeAggregation.Bucket)element$iv;
                boolean bl = false;
                String id2 = transform2.getId() + "#" + CollectionsKt.joinToString$default((Iterable)aggregatedBucket.getKey().entrySet(), (CharSequence)":", null, null, (int)0, null, (Function1)convertResponse.1.id.1.INSTANCE, (int)30, null);
                String hashedId = IndexUtils.Companion.hashToFixedSize(id2);
                Map<String, Object> document = transform2.convertToDoc(aggregatedBucket.getDocCount(), waterMarkDocuments);
                Iterable $this$forEach$iv2 = aggregatedBucket.getKey().entrySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Map.Entry bucket = (Map.Entry)element$iv2;
                    boolean bl3 = false;
                    object = bucket.getKey();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"bucket.key");
                    document.put((String)object, bucket.getValue());
                }
                $this$forEach$iv2 = aggregatedBucket.getAggregations();
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"aggregatedBucket.aggregations");
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Aggregation aggregation2 = (Aggregation)element$iv2;
                    boolean bl4 = false;
                    object = aggregation2.getName();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"aggregation.name");
                    Intrinsics.checkNotNullExpressionValue((Object)aggregation2, (String)"aggregation");
                    document.put((String)object, Companion.getAggregationValue(aggregation2));
                }
                IndexRequest indexRequest = new IndexRequest(transform2.getTargetIndex()).id(hashedId).source(document, XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)indexRequest, (String)"indexRequest");
                docsToIndex.add(indexRequest);
            }
            return new TransformSearchResult(stats, docsToIndex, afterKey);
        }

        public static /* synthetic */ TransformSearchResult convertResponse$default(Companion companion, Transform transform2, SearchResponse searchResponse2, boolean bl, Set set, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                set = null;
            }
            return companion.convertResponse(transform2, searchResponse2, bl, set);
        }

        /*
         * WARNING - void declaration
         */
        private final BucketSearchResult convertBucketSearchResponse(Transform transform2, SearchResponse searchResponse2) {
            void $this$mapTo$iv$iv;
            Aggregation aggregation = searchResponse2.getAggregations().get(transform2.getId());
            if (aggregation == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.composite.CompositeAggregation");
            }
            CompositeAggregation aggs = (CompositeAggregation)aggregation;
            List list = aggs.getBuckets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"aggs.buckets");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CompositeAggregation.Bucket bucket = (CompositeAggregation.Bucket)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            Set modifiedBuckets = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            return new BucketSearchResult(modifiedBuckets, aggs.afterKey(), searchResponse2.getTook().getMillis());
        }

        private final Object getAggregationValue(Aggregation aggregation) {
            Object object;
            Aggregation aggregation2 = aggregation;
            if ((((aggregation2 instanceof InternalSum ? true : aggregation2 instanceof InternalMin) ? true : aggregation2 instanceof InternalMax) ? true : aggregation2 instanceof InternalAvg) ? true : aggregation2 instanceof InternalValueCount) {
                NumericMetricsAggregation.SingleValue agg = (NumericMetricsAggregation.SingleValue)aggregation;
                object = agg.value();
            } else if (aggregation2 instanceof Percentiles) {
                Map percentiles = new LinkedHashMap();
                Iterable $this$forEach$iv = (Iterable)aggregation;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Percentile percentile = (Percentile)element$iv;
                    boolean bl = false;
                    percentiles.put(String.valueOf(percentile.getPercent()), percentile.getValue());
                }
                object = percentiles;
            } else if (aggregation2 instanceof ScriptedMetric) {
                object = ((ScriptedMetric)aggregation).aggregation();
            } else {
                throw new TransformSearchServiceException("Found aggregation [" + aggregation.getName() + "] of type [" + aggregation.getType() + "] in composite result that is not currently supported", null, 2, null);
            }
            Double d = object;
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"when (aggregation) {\n   \u2026          )\n            }");
            return d;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<ShardId, Long> convertIndicesStatsResponse(@NotNull IndicesStatsResponse response2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            HashMap shardStats = new HashMap();
            ShardStats[] shardStatsArray = response2.getShards();
            Intrinsics.checkNotNullExpressionValue((Object)shardStatsArray, (String)"response.shards");
            Object[] $this$filter$iv = shardStatsArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                ShardStats it = (ShardStats)element$iv$iv;
                boolean bl = false;
                if (!(it.getShardRouting().primary() && it.getShardRouting().active())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List shardsToSearch = (List)destination$iv$iv;
            for (ShardStats shard : shardsToSearch) {
                long l;
                ShardId shardId = shard.getShardRouting().shardId();
                ShardId shardIDNoUUID = new ShardId(new Index(shardId.getIndex().getName(), "_na_"), shardId.getId());
                Map map = shardStats;
                SeqNoStats seqNoStats = shard.getSeqNoStats();
                Long l2 = seqNoStats == null ? -2L : (l = seqNoStats.getGlobalCheckpoint());
                map.put(shardIDNoUUID, l2);
            }
            return shardStats;
        }

        public static final /* synthetic */ String access$getShardsRetryMessage(Companion $this, int attemptNumber) {
            return $this.getShardsRetryMessage(attemptNumber);
        }

        public static final /* synthetic */ BucketSearchResult access$convertBucketSearchResponse(Companion $this, Transform transform2, SearchResponse searchResponse2) {
            return $this.convertBucketSearchResponse(transform2, searchResponse2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

