/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.exception.ExpressionEvaluationException;

public final class ParseUtils {
    private static final Logger log = LogManager.getLogger(ParseUtils.class);
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");

    public static ExprValue parseValue(ExprValue value, Pattern pattern, String identifier) throws ExpressionEvaluationException {
        if (value.isNull() || value.isMissing()) {
            return ExprValueUtils.nullValue();
        }
        String rawString = value.stringValue();
        Matcher matcher = pattern.matcher(rawString);
        if (matcher.matches()) {
            return new ExprStringValue(matcher.group(identifier));
        }
        log.warn("failed to extract pattern {} from input {}", (Object)pattern.pattern(), (Object)rawString);
        return new ExprStringValue("");
    }

    public static List<String> getNamedGroupCandidates(String pattern) {
        ImmutableList.Builder namedGroups = ImmutableList.builder();
        Matcher m = GROUP_PATTERN.matcher(pattern);
        while (m.find()) {
            namedGroups.add((Object)m.group(1));
        }
        return namedGroups.build();
    }

    @Generated
    private ParseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

