/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.collector;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.utils.DateTimeUtils;

public abstract class Rounding<T> {
    protected T maxRounded;
    protected T minRounded;

    public static Rounding<?> createRounding(SpanExpression span) {
        ExprValue interval = span.getValue().valueOf(null);
        ExprType type = span.type();
        if (ExprCoreType.LONG.isCompatible(type)) {
            return new LongRounding(interval);
        }
        if (ExprCoreType.DOUBLE.isCompatible(type)) {
            return new DoubleRounding(interval);
        }
        if (type.equals(ExprCoreType.DATETIME)) {
            return new DatetimeRounding(interval, span.getUnit().getName());
        }
        if (type.equals(ExprCoreType.TIMESTAMP)) {
            return new TimestampRounding(interval, span.getUnit().getName());
        }
        if (type.equals(ExprCoreType.DATE)) {
            return new DateRounding(interval, span.getUnit().getName());
        }
        if (type.equals(ExprCoreType.TIME)) {
            return new TimeRounding(interval, span.getUnit().getName());
        }
        return new UnknownRounding();
    }

    public abstract ExprValue round(ExprValue var1);

    public abstract Integer locate(ExprValue var1);

    public abstract ExprValue[] createBuckets();

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rounding)) {
            return false;
        }
        Rounding other = (Rounding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$maxRounded = this.getMaxRounded();
        T other$maxRounded = other.getMaxRounded();
        if (this$maxRounded == null ? other$maxRounded != null : !this$maxRounded.equals(other$maxRounded)) {
            return false;
        }
        T this$minRounded = this.getMinRounded();
        T other$minRounded = other.getMinRounded();
        return !(this$minRounded == null ? other$minRounded != null : !this$minRounded.equals(other$minRounded));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rounding;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $maxRounded = this.getMaxRounded();
        result = result * 59 + ($maxRounded == null ? 43 : $maxRounded.hashCode());
        T $minRounded = this.getMinRounded();
        result = result * 59 + ($minRounded == null ? 43 : $minRounded.hashCode());
        return result;
    }

    @Generated
    public T getMaxRounded() {
        return this.maxRounded;
    }

    @Generated
    public T getMinRounded() {
        return this.minRounded;
    }

    static class LongRounding
    extends Rounding<Long> {
        private final Long longInterval;

        protected LongRounding(ExprValue interval) {
            this.longInterval = interval.longValue();
        }

        @Override
        public ExprValue round(ExprValue value) {
            long rounded = Math.floorDiv((long)value.longValue(), this.longInterval) * this.longInterval;
            this.updateRounded(rounded);
            return ExprValueUtils.longValue(rounded);
        }

        @Override
        public Integer locate(ExprValue value) {
            return Long.valueOf((value.longValue() - (Long)this.minRounded) / this.longInterval).intValue();
        }

        @Override
        public ExprValue[] createBuckets() {
            int size = Long.valueOf(((Long)this.maxRounded - (Long)this.minRounded) / this.longInterval).intValue() + 1;
            return new ExprValue[size];
        }

        private void updateRounded(Long value) {
            if (this.maxRounded == null || value > (Long)this.maxRounded) {
                this.maxRounded = value;
            }
            if (this.minRounded == null || value < (Long)this.minRounded) {
                this.minRounded = value;
            }
        }
    }

    static class DoubleRounding
    extends Rounding<Double> {
        private final Double doubleInterval;

        protected DoubleRounding(ExprValue interval) {
            this.doubleInterval = interval.doubleValue();
        }

        @Override
        public ExprValue round(ExprValue value) {
            double rounded = (double)Double.valueOf(value.doubleValue() / this.doubleInterval).intValue() * this.doubleInterval;
            this.updateRounded(rounded);
            return ExprValueUtils.doubleValue(rounded);
        }

        @Override
        public Integer locate(ExprValue value) {
            return Double.valueOf((value.doubleValue() - (Double)this.minRounded) / this.doubleInterval).intValue();
        }

        @Override
        public ExprValue[] createBuckets() {
            int size = Double.valueOf(((Double)this.maxRounded - (Double)this.minRounded) / this.doubleInterval).intValue() + 1;
            return new ExprValue[size];
        }

        private void updateRounded(Double value) {
            if (this.maxRounded == null || value > (Double)this.maxRounded) {
                this.maxRounded = value;
            }
            if (this.minRounded == null || value < (Double)this.minRounded) {
                this.minRounded = value;
            }
        }
    }

    static class DatetimeRounding
    extends Rounding<LocalDateTime> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public DatetimeRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.datetimeValue().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli(), this.interval.integerValue()));
            this.updateRounded(instant);
            return new ExprDatetimeValue(instant.atZone(ZoneId.of("UTC")).toLocalDateTime());
        }

        @Override
        public ExprValue[] createBuckets() {
            if (this.dateTimeUnit.isMillisBased) {
                int size = (int)((((LocalDateTime)this.maxRounded).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((LocalDateTime)this.minRounded).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / ((long)this.interval.integerValue().intValue() * this.dateTimeUnit.ratio)) + 1;
                return new ExprValue[size];
            }
            ZonedDateTime maxZonedDateTime = ((LocalDateTime)this.maxRounded).atZone(ZoneId.of("UTC"));
            ZonedDateTime minZonedDateTime = ((LocalDateTime)this.minRounded).atZone(ZoneId.of("UTC"));
            int monthDiff = (maxZonedDateTime.getYear() - minZonedDateTime.getYear()) * 12 + maxZonedDateTime.getMonthValue() - minZonedDateTime.getMonthValue();
            int size = monthDiff / ((int)this.dateTimeUnit.ratio * this.interval.integerValue()) + 1;
            return new ExprValue[size];
        }

        @Override
        public Integer locate(ExprValue value) {
            if (this.dateTimeUnit.isMillisBased) {
                long intervalInEpochMillis = this.dateTimeUnit.ratio;
                return Long.valueOf((value.datetimeValue().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((LocalDateTime)this.minRounded).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / (intervalInEpochMillis * (long)this.interval.integerValue().intValue())).intValue();
            }
            int monthDiff = (value.datetimeValue().getYear() - ((LocalDateTime)this.minRounded).getYear()) * 12 + value.dateValue().getMonthValue() - ((LocalDateTime)this.minRounded).getMonthValue();
            return (int)((long)monthDiff / (this.dateTimeUnit.ratio * (long)this.interval.integerValue().intValue()));
        }

        private void updateRounded(Instant value) {
            if (this.maxRounded == null || value.isAfter(((LocalDateTime)this.maxRounded).atZone(ZoneId.of("UTC")).toInstant())) {
                this.maxRounded = value.atZone(ZoneId.of("UTC")).toLocalDateTime();
            }
            if (this.minRounded == null || value.isBefore(((LocalDateTime)this.minRounded).atZone(ZoneId.of("UTC")).toInstant())) {
                this.minRounded = value.atZone(ZoneId.of("UTC")).toLocalDateTime();
            }
        }
    }

    static class TimestampRounding
    extends Rounding<Instant> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public TimestampRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.timestampValue().toEpochMilli(), this.interval.integerValue()));
            this.updateRounded(instant);
            return new ExprTimestampValue(instant);
        }

        @Override
        public ExprValue[] createBuckets() {
            if (this.dateTimeUnit.isMillisBased) {
                int size = (int)((((Instant)this.maxRounded).toEpochMilli() - ((Instant)this.minRounded).toEpochMilli()) / ((long)this.interval.integerValue().intValue() * this.dateTimeUnit.ratio)) + 1;
                return new ExprValue[size];
            }
            ZonedDateTime maxZonedDateTime = ((Instant)this.maxRounded).atZone(ZoneId.of("UTC"));
            ZonedDateTime minZonedDateTime = ((Instant)this.minRounded).atZone(ZoneId.of("UTC"));
            int monthDiff = (maxZonedDateTime.getYear() - minZonedDateTime.getYear()) * 12 + maxZonedDateTime.getMonthValue() - minZonedDateTime.getMonthValue();
            int size = monthDiff / ((int)this.dateTimeUnit.ratio * this.interval.integerValue()) + 1;
            return new ExprValue[size];
        }

        @Override
        public Integer locate(ExprValue value) {
            if (this.dateTimeUnit.isMillisBased) {
                long intervalInEpochMillis = this.dateTimeUnit.ratio;
                return Long.valueOf((value.timestampValue().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((Instant)this.minRounded).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / (intervalInEpochMillis * (long)this.interval.integerValue().intValue())).intValue();
            }
            int monthDiff = (value.dateValue().getYear() - ((Instant)this.minRounded).atZone(ZoneId.of("UTC")).getYear()) * 12 + value.dateValue().getMonthValue() - ((Instant)this.minRounded).atZone(ZoneId.of("UTC")).getMonthValue();
            return (int)((long)monthDiff / (this.dateTimeUnit.ratio * (long)this.interval.integerValue().intValue()));
        }

        private void updateRounded(Instant value) {
            if (this.maxRounded == null || value.isAfter((Instant)this.maxRounded)) {
                this.maxRounded = value;
            }
            if (this.minRounded == null || value.isBefore((Instant)this.minRounded)) {
                this.minRounded = value;
            }
        }
    }

    static class DateRounding
    extends Rounding<LocalDate> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public DateRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.dateValue().atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli(), this.interval.integerValue()));
            this.updateRounded(instant);
            return new ExprDateValue(instant.atZone(ZoneId.of("UTC")).toLocalDate());
        }

        @Override
        public ExprValue[] createBuckets() {
            if (this.dateTimeUnit.isMillisBased) {
                int size = (int)((((LocalDate)this.maxRounded).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((LocalDate)this.minRounded).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / ((long)this.interval.integerValue().intValue() * this.dateTimeUnit.ratio)) + 1;
                return new ExprValue[size];
            }
            ZonedDateTime maxZonedDateTime = ((LocalDate)this.maxRounded).atStartOfDay().atZone(ZoneId.of("UTC"));
            ZonedDateTime minZonedDateTime = ((LocalDate)this.minRounded).atStartOfDay().atZone(ZoneId.of("UTC"));
            int monthDiff = (maxZonedDateTime.getYear() - minZonedDateTime.getYear()) * 12 + maxZonedDateTime.getMonthValue() - minZonedDateTime.getMonthValue();
            int size = monthDiff / ((int)this.dateTimeUnit.ratio * this.interval.integerValue()) + 1;
            return new ExprValue[size];
        }

        @Override
        public Integer locate(ExprValue value) {
            if (this.dateTimeUnit.isMillisBased) {
                long intervalInEpochMillis = this.dateTimeUnit.ratio;
                return Long.valueOf((value.dateValue().atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((LocalDate)this.minRounded).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / (intervalInEpochMillis * (long)this.interval.integerValue().intValue())).intValue();
            }
            int monthDiff = (value.dateValue().getYear() - ((LocalDate)this.minRounded).getYear()) * 12 + value.dateValue().getMonthValue() - ((LocalDate)this.minRounded).getMonthValue();
            return (int)((long)monthDiff / (this.dateTimeUnit.ratio * (long)this.interval.integerValue().intValue()));
        }

        private void updateRounded(Instant value) {
            if (this.maxRounded == null || value.isAfter(((LocalDate)this.maxRounded).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant())) {
                this.maxRounded = value.atZone(ZoneId.of("UTC")).toLocalDate();
            }
            if (this.minRounded == null || value.isBefore(((LocalDate)this.minRounded).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant())) {
                this.minRounded = value.atZone(ZoneId.of("UTC")).toLocalDate();
            }
        }
    }

    static class TimeRounding
    extends Rounding<LocalTime> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public TimeRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            if (this.dateTimeUnit.id > 4) {
                throw new ExpressionEvaluationException(String.format("Unable to set span unit %s for TIME type", this.dateTimeUnit.getName()));
            }
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.timeValue().getLong(ChronoField.MILLI_OF_DAY), this.interval.integerValue()));
            this.updateRounded(instant);
            return new ExprTimeValue(instant.atZone(ZoneId.of("UTC")).toLocalTime());
        }

        @Override
        public ExprValue[] createBuckets() {
            int size = (int)((((LocalTime)this.maxRounded).atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((LocalTime)this.minRounded).atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / ((long)this.interval.integerValue().intValue() * this.dateTimeUnit.ratio)) + 1;
            return new ExprValue[size];
        }

        @Override
        public Integer locate(ExprValue value) {
            long intervalInEpochMillis = this.dateTimeUnit.ratio;
            return Long.valueOf((value.timeValue().atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() - ((LocalTime)this.minRounded).atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli()) / (intervalInEpochMillis * (long)this.interval.integerValue().intValue())).intValue();
        }

        private void updateRounded(Instant value) {
            if (this.maxRounded == null || value.isAfter(((LocalTime)this.maxRounded).atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.of("UTC")).toInstant())) {
                this.maxRounded = value.atZone(ZoneId.of("UTC")).toLocalTime();
            }
            if (this.minRounded == null) {
                this.minRounded = value.atZone(ZoneId.of("UTC")).toLocalTime();
            }
        }
    }

    static class UnknownRounding
    extends Rounding<Object> {
        @Override
        public ExprValue round(ExprValue var) {
            return null;
        }

        @Override
        public Integer locate(ExprValue value) {
            return null;
        }

        @Override
        public ExprValue[] createBuckets() {
            return new ExprValue[0];
        }

        @Generated
        public UnknownRounding() {
        }
    }

    public static enum DateTimeUnit {
        MILLISECOND(1, "ms", true, ChronoField.MILLI_OF_SECOND.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        SECOND(2, "s", true, ChronoField.SECOND_OF_MINUTE.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        MINUTE(3, "m", true, ChronoField.MINUTE_OF_HOUR.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        HOUR(4, "h", true, ChronoField.HOUR_OF_DAY.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        DAY(5, "d", true, ChronoField.DAY_OF_MONTH.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        WEEK(6, "w", true, TimeUnit.DAYS.toMillis(7L)){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundWeek(utcMillis, interval);
            }
        }
        ,
        MONTH(7, "M", false, 1L){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundMonth(utcMillis, interval);
            }
        }
        ,
        QUARTER(8, "q", false, 3L){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundQuarter(utcMillis, interval);
            }
        }
        ,
        YEAR(9, "y", false, 12L){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundYear(utcMillis, interval);
            }
        };

        private final int id;
        private final String name;
        protected final boolean isMillisBased;
        protected final long ratio;

        abstract long round(long var1, int var3);

        public static DateTimeUnit resolve(String name) {
            switch (name) {
                case "M": {
                    return MONTH;
                }
                case "m": {
                    return MINUTE;
                }
            }
            return Arrays.stream(DateTimeUnit.values()).filter(v -> v.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to resolve unit " + name));
        }

        @Generated
        private DateTimeUnit(int id, String name, boolean isMillisBased, long ratio) {
            this.id = id;
            this.name = name;
            this.isMillisBased = isMillisBased;
            this.ratio = ratio;
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

