/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.analysis.ExpressionReferenceOptimizer;
import org.opensearch.sql.analysis.HighlightAnalyzer;
import org.opensearch.sql.analysis.NamedExpressionAnalyzer;
import org.opensearch.sql.analysis.SelectExpressionAnalyzer;
import org.opensearch.sql.analysis.TypeEnvironment;
import org.opensearch.sql.analysis.WindowExpressionAnalyzer;
import org.opensearch.sql.analysis.symbol.Namespace;
import org.opensearch.sql.analysis.symbol.Symbol;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Limit;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.RelationSubquery;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ParseExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.planner.logical.LogicalAD;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalDedupe;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalMLCommons;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalRareTopN;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.logical.LogicalRemove;
import org.opensearch.sql.planner.logical.LogicalRename;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.logical.LogicalValues;
import org.opensearch.sql.storage.StorageEngine;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.utils.ParseUtils;

public class Analyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private final SelectExpressionAnalyzer selectExpressionAnalyzer;
    private final NamedExpressionAnalyzer namedExpressionAnalyzer;
    private final StorageEngine storageEngine;

    public Analyzer(ExpressionAnalyzer expressionAnalyzer, StorageEngine storageEngine) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.storageEngine = storageEngine;
        this.selectExpressionAnalyzer = new SelectExpressionAnalyzer(expressionAnalyzer);
        this.namedExpressionAnalyzer = new NamedExpressionAnalyzer(expressionAnalyzer);
    }

    public LogicalPlan analyze(UnresolvedPlan unresolved, AnalysisContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public LogicalPlan visitRelation(Relation node, AnalysisContext context) {
        context.push();
        TypeEnvironment curEnv = context.peek();
        Table table = this.storageEngine.getTable(node.getTableName());
        table.getFieldTypes().forEach((k, v) -> curEnv.define(new Symbol(Namespace.FIELD_NAME, (String)k), (ExprType)v));
        curEnv.define(new Symbol(Namespace.INDEX_NAME, node.getTableNameOrAlias()), ExprCoreType.STRUCT);
        return new LogicalRelation(node.getTableName());
    }

    @Override
    public LogicalPlan visitRelationSubquery(RelationSubquery node, AnalysisContext context) {
        LogicalPlan subquery = this.analyze(node.getChild().get(0), context);
        TypeEnvironment curEnv = context.peek();
        curEnv.define(new Symbol(Namespace.INDEX_NAME, node.getAliasAsTableName()), ExprCoreType.STRUCT);
        return subquery;
    }

    @Override
    public LogicalPlan visitLimit(Limit node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return new LogicalLimit(child, node.getLimit(), node.getOffset());
    }

    @Override
    public LogicalPlan visitFilter(Filter node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        Expression condition = this.expressionAnalyzer.analyze(node.getCondition(), context);
        ExpressionReferenceOptimizer optimizer = new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child);
        Expression optimized = optimizer.optimize(condition, context);
        return new LogicalFilter(child, optimized);
    }

    @Override
    public LogicalPlan visitRename(Rename node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableMap.Builder renameMapBuilder = new ImmutableMap.Builder();
        for (Map renameMap : node.getRenameList()) {
            Expression origin = this.expressionAnalyzer.analyze(renameMap.getOrigin(), context);
            if (renameMap.getTarget() instanceof Field) {
                ReferenceExpression target = new ReferenceExpression(((Field)renameMap.getTarget()).getField().toString(), origin.type());
                ReferenceExpression originExpr = DSL.ref(origin.toString(), origin.type());
                TypeEnvironment curEnv = context.peek();
                curEnv.remove(originExpr);
                curEnv.define(target);
                renameMapBuilder.put((Object)originExpr, (Object)target);
                continue;
            }
            throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
        }
        return new LogicalRename(child, (java.util.Map<ReferenceExpression, ReferenceExpression>)renameMapBuilder.build());
    }

    @Override
    public LogicalPlan visitAggregation(Aggregation node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression unresolvedExpression : node.getAggExprList()) {
            NamedExpression aggExpr = this.namedExpressionAnalyzer.analyze(unresolvedExpression, context);
            aggregatorBuilder.add((Object)new NamedAggregator(aggExpr.getNameOrAlias(), (Aggregator)aggExpr.getDelegated()));
        }
        ImmutableList.Builder groupbyBuilder = new ImmutableList.Builder();
        if (node.getSpan() != null) {
            groupbyBuilder.add((Object)this.namedExpressionAnalyzer.analyze(node.getSpan(), context));
        }
        for (UnresolvedExpression expr : node.getGroupExprList()) {
            groupbyBuilder.add((Object)this.namedExpressionAnalyzer.analyze(expr, context));
        }
        ImmutableList immutableList = groupbyBuilder.build();
        ImmutableList aggregators = aggregatorBuilder.build();
        context.push();
        TypeEnvironment newEnv = context.peek();
        aggregators.forEach(aggregator -> newEnv.define(new Symbol(Namespace.FIELD_NAME, aggregator.getName()), aggregator.type()));
        immutableList.forEach(group -> newEnv.define(new Symbol(Namespace.FIELD_NAME, group.getNameOrAlias()), group.type()));
        return new LogicalAggregation(child, (List<NamedAggregator>)aggregators, (List<NamedExpression>)immutableList);
    }

    @Override
    public LogicalPlan visitRareTopN(RareTopN node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder groupbyBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression expr : node.getGroupExprList()) {
            groupbyBuilder.add((Object)this.expressionAnalyzer.analyze(expr, context));
        }
        ImmutableList groupBys = groupbyBuilder.build();
        ImmutableList.Builder fieldsBuilder = new ImmutableList.Builder();
        for (Field f : node.getFields()) {
            fieldsBuilder.add((Object)this.expressionAnalyzer.analyze(f, context));
        }
        ImmutableList fields = fieldsBuilder.build();
        context.push();
        TypeEnvironment newEnv = context.peek();
        groupBys.forEach(group -> newEnv.define(new Symbol(Namespace.FIELD_NAME, group.toString()), group.type()));
        fields.forEach(field -> newEnv.define(new Symbol(Namespace.FIELD_NAME, field.toString()), field.type()));
        List<Argument> options = node.getNoOfResults();
        Integer noOfResults = (Integer)options.get(0).getValue().getValue();
        return new LogicalRareTopN(child, node.getCommandType(), noOfResults, (List<Expression>)fields, (List<Expression>)groupBys);
    }

    @Override
    public LogicalPlan visitProject(Project node, AnalysisContext context) {
        Iterator<UnresolvedExpression> argument;
        Boolean exclude;
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        if (node.hasArgument() && (exclude = (Boolean)((Argument)((Object)(argument = node.getArgExprList().get(0)))).getValue().getValue()).booleanValue()) {
            TypeEnvironment curEnv = context.peek();
            List<ReferenceExpression> referenceExpressions = node.getProjectList().stream().map(expr -> (ReferenceExpression)this.expressionAnalyzer.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
            referenceExpressions.forEach(ref -> curEnv.remove((ReferenceExpression)ref));
            return new LogicalRemove(child, (Set<ReferenceExpression>)ImmutableSet.copyOf(referenceExpressions));
        }
        for (UnresolvedExpression expr2 : node.getProjectList()) {
            WindowExpressionAnalyzer windowAnalyzer = new WindowExpressionAnalyzer(this.expressionAnalyzer, child);
            child = windowAnalyzer.analyze(expr2, context);
        }
        for (UnresolvedExpression expr2 : node.getProjectList()) {
            HighlightAnalyzer highlightAnalyzer = new HighlightAnalyzer(this.expressionAnalyzer, child);
            child = highlightAnalyzer.analyze(expr2, context);
        }
        List<NamedExpression> namedExpressions = this.selectExpressionAnalyzer.analyze(node.getProjectList(), context, new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child));
        context.push();
        TypeEnvironment newEnv = context.peek();
        namedExpressions.forEach(expr -> newEnv.define(new Symbol(Namespace.FIELD_NAME, expr.getNameOrAlias()), expr.type()));
        List<NamedExpression> namedParseExpressions = context.getNamedParseExpressions();
        return new LogicalProject(child, namedExpressions, namedParseExpressions);
    }

    @Override
    public LogicalPlan visitEval(Eval node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder expressionsBuilder = new ImmutableList.Builder();
        for (Let let : node.getExpressionList()) {
            Expression expression = this.expressionAnalyzer.analyze(let.getExpression(), context);
            ReferenceExpression ref = DSL.ref(let.getVar().getField().toString(), expression.type());
            expressionsBuilder.add((Object)ImmutablePair.of((Object)ref, (Object)expression));
            TypeEnvironment typeEnvironment = context.peek();
            typeEnvironment.define(ref);
        }
        return new LogicalEval(child, (List<Pair<ReferenceExpression, Expression>>)expressionsBuilder.build());
    }

    @Override
    public LogicalPlan visitParse(Parse node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        Expression expression = this.expressionAnalyzer.analyze(node.getExpression(), context);
        String pattern = (String)node.getPattern().getValue();
        LiteralExpression patternExpression = DSL.literal(pattern);
        TypeEnvironment curEnv = context.peek();
        ParseUtils.getNamedGroupCandidates(pattern).forEach(group -> {
            curEnv.define(new Symbol(Namespace.FIELD_NAME, (String)group), ExprCoreType.STRING);
            context.getNamedParseExpressions().add(new NamedExpression((String)group, new ParseExpression(expression, patternExpression, DSL.literal(group))));
        });
        return child;
    }

    @Override
    public LogicalPlan visitSort(Sort node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ExpressionReferenceOptimizer optimizer = new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child);
        List<Pair<Sort.SortOption, Expression>> sortList = node.getSortList().stream().map(sortField -> {
            Expression expression = optimizer.optimize(this.expressionAnalyzer.analyze(sortField.getField(), context), context);
            return ImmutablePair.of((Object)this.analyzeSortOption(sortField.getFieldArgs()), (Object)expression);
        }).collect(Collectors.toList());
        return new LogicalSort(child, sortList);
    }

    @Override
    public LogicalPlan visitDedupe(Dedupe node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        return new LogicalDedupe(child, node.getFields().stream().map(f -> this.expressionAnalyzer.analyze((UnresolvedExpression)f, context)).collect(Collectors.toList()), allowedDuplication, keepEmpty, consecutive);
    }

    @Override
    public LogicalPlan visitHead(Head node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return new LogicalLimit(child, node.getSize(), node.getFrom());
    }

    @Override
    public LogicalPlan visitValues(Values node, AnalysisContext context) {
        List<List<Literal>> values = node.getValues();
        ArrayList<List<LiteralExpression>> valueExprs = new ArrayList<List<LiteralExpression>>();
        for (List<Literal> value : values) {
            valueExprs.add(value.stream().map(val -> (LiteralExpression)this.expressionAnalyzer.analyze((UnresolvedExpression)val, context)).collect(Collectors.toList()));
        }
        return new LogicalValues((List<List<LiteralExpression>>)valueExprs);
    }

    @Override
    public LogicalPlan visitKmeans(Kmeans node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        java.util.Map<String, Literal> options = node.getArguments();
        TypeEnvironment currentEnv = context.peek();
        currentEnv.define(new Symbol(Namespace.FIELD_NAME, "ClusterID"), ExprCoreType.INTEGER);
        return new LogicalMLCommons(child, "kmeans", options);
    }

    @Override
    public LogicalPlan visitAD(AD node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        java.util.Map<String, Literal> options = node.getArguments();
        TypeEnvironment currentEnv = context.peek();
        currentEnv.define(new Symbol(Namespace.FIELD_NAME, "score"), ExprCoreType.DOUBLE);
        if (Objects.isNull(node.getArguments().get("time_field"))) {
            currentEnv.define(new Symbol(Namespace.FIELD_NAME, "anomalous"), ExprCoreType.BOOLEAN);
        } else {
            currentEnv.define(new Symbol(Namespace.FIELD_NAME, "anomaly_grade"), ExprCoreType.DOUBLE);
            currentEnv.define(new Symbol(Namespace.FIELD_NAME, "timestamp"), ExprCoreType.TIMESTAMP);
        }
        return new LogicalAD(child, options);
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }
}

