/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;

public class FileHelper {
    private static final Logger log = LogManager.getLogger(FileHelper.class);
    private static boolean jvmSupportMillisecondFileModityTime = true;
    private static long SECOND_TO_MILLISECONDS = 1000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getLastModified(File file, long startTime, long endTime) {
        if (!file.isFile()) return file.lastModified();
        if (jvmSupportMillisecondFileModityTime) {
            return file.lastModified();
        }
        if (file.lastModified() < startTime - SECOND_TO_MILLISECONDS) return file.lastModified();
        if (file.lastModified() > endTime) {
            return file.lastModified();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            if (line == null) return file.lastModified();
            String[] fields = line.split(":");
            if (!fields[0].equals("current_time")) return file.lastModified();
            long l = Long.parseLong(fields[1]);
            return l;
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.OTHER, "", 1);
            log.debug("Having issue to read current time from the content of file. Using file metadata; exception: {} ExceptionCode: {}", new Supplier[]{() -> ex, () -> ReaderMetrics.OTHER.toString()});
        }
        return file.lastModified();
    }

    static {
        try {
            for (int i = 0; i < 2; ++i) {
                File tmpFile = File.createTempFile("performanceanalyzer", ".tmp");
                tmpFile.deleteOnExit();
                boolean bl = jvmSupportMillisecondFileModityTime = tmpFile.lastModified() % 1000L != 0L;
                if (!jvmSupportMillisecondFileModityTime) {
                    Thread.sleep(2L);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            log.error("Having issue creating tmp file. Using default value.", (Throwable)ex);
        }
        log.info("jvmSupportMillisecondFileModityTime: {}", (Object)jvmSupportMillisecondFileModityTime);
    }
}

