/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.repackage.com.cronutils.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.CompositeCron;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.Cron;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.SingleCron;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.definition.CronDefinition;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.CronField;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.definition.FieldDefinition;
import org.opensearch.jobscheduler.repackage.com.cronutils.parser.CronParserField;
import org.opensearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;
import org.opensearch.jobscheduler.repackage.com.cronutils.utils.StringUtils;

public class CronParser {
    private final Map<Integer, List<CronParserField>> expressions = new HashMap<Integer, List<CronParserField>>();
    private final CronDefinition cronDefinition;

    public CronParser(CronDefinition cronDefinition) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
        this.buildPossibleExpressions(cronDefinition);
    }

    private void buildPossibleExpressions(CronDefinition cronDefinition) {
        List<CronParserField> sortedExpression;
        List<CronParserField> tempExpression = sortedExpression = cronDefinition.getFieldDefinitions().stream().map(this::toCronParserField).sorted(CronParserField.createFieldTypeComparator()).collect(Collectors.toList());
        while (this.lastFieldIsOptional(tempExpression)) {
            int expressionLength = tempExpression.size() - 1;
            ArrayList<CronParserField> possibleExpression = new ArrayList<CronParserField>(tempExpression.subList(0, expressionLength));
            this.expressions.put(expressionLength, possibleExpression);
            tempExpression = possibleExpression;
        }
        this.expressions.put(sortedExpression.size(), sortedExpression);
    }

    private CronParserField toCronParserField(FieldDefinition fieldDefinition) {
        return new CronParserField(fieldDefinition.getFieldName(), fieldDefinition.getConstraints(), fieldDefinition.isOptional());
    }

    private boolean lastFieldIsOptional(List<CronParserField> fields) {
        return !fields.isEmpty() && fields.get(fields.size() - 1).isOptional();
    }

    public Cron parse(String expression) {
        Preconditions.checkNotNull(expression, "Expression must not be null");
        String replaced = expression.replaceAll("\\s+", " ").trim();
        if (StringUtils.isEmpty(replaced)) {
            throw new IllegalArgumentException("Empty expression!");
        }
        if (expression.contains("||")) {
            List<Cron> crons = Arrays.stream(expression.split("\\|\\|")).map(this::parse).collect(Collectors.toList());
            return new CompositeCron(crons);
        }
        if (expression.contains("|")) {
            ArrayList<String> crons = new ArrayList<String>();
            int cronscount = Arrays.stream(expression.split("\\s+")).mapToInt(s -> s.split("\\|").length).max().orElse(0);
            for (int j = 0; j < cronscount; ++j) {
                StringBuilder builder = new StringBuilder();
                for (String s2 : expression.split("\\s+")) {
                    if (s2.contains("|")) {
                        builder.append(String.format("%s ", s2.split("\\|")[j]));
                        continue;
                    }
                    builder.append(String.format("%s ", s2));
                }
                crons.add(builder.toString().trim());
            }
            return new CompositeCron(crons.stream().map(this::parse).collect(Collectors.toList()));
        }
        String[] expressionParts = replaced.toUpperCase().split(" ");
        int expressionLength = expressionParts.length;
        String fieldWithTrailingCommas = Arrays.stream(expressionParts).filter(x -> x.endsWith(",")).findAny().orElse(null);
        if (fieldWithTrailingCommas != null) {
            throw new IllegalArgumentException(String.format("Invalid field value! Trailing commas not permitted! '%s'", fieldWithTrailingCommas));
        }
        List<CronParserField> fields = this.expressions.get(expressionLength);
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Cron expression contains %s parts but we expect one of %s", expressionLength, this.expressions.keySet()));
        }
        try {
            int size = expressionParts.length;
            ArrayList<CronField> results = new ArrayList<CronField>(size + 1);
            for (int j = 0; j < size; ++j) {
                results.add(fields.get(j).parse(expressionParts[j]));
            }
            return new SingleCron(this.cronDefinition, results).validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Failed to parse cron expression. %s", e.getMessage()), e);
        }
    }
}

