/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.model.NotificationConfigInfo;
import org.opensearch.commons.notifications.model.NotificationConfigSearchResult;
import org.opensearch.commons.notifications.model.SearchResults;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.notifications.index.ConfigOperations;
import org.opensearch.notifications.index.ConfigQueryHelper;
import org.opensearch.notifications.index.NotificationConfigIndex;
import org.opensearch.notifications.index.NotificationConfigIndexKt;
import org.opensearch.notifications.model.DocInfo;
import org.opensearch.notifications.model.NotificationConfigDoc;
import org.opensearch.notifications.model.NotificationConfigDocInfo;
import org.opensearch.notifications.settings.PluginSettings;
import org.opensearch.notifications.util.SecureIndexClient;
import org.opensearch.notifications.util.SuspendUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.script.Script;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0012\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0014\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ+\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J'\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(2\u0006\u0010)\u001a\u00020*H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u001b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001a\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ%\u0010.\u001a\b\u0012\u0004\u0012\u00020-0(2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0016\u0010/\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u00100\u001a\u00020\u001dH\u0002J\u001a\u00101\u001a\u0004\u0018\u00010-2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0002J!\u00104\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lorg/opensearch/notifications/index/NotificationConfigIndex;", "Lorg/opensearch/notifications/index/ConfigOperations;", "()V", "INDEX_NAME", "", "MAPPING_FILE_NAME", "SETTINGS_FILE_NAME", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "searchHitParser", "org/opensearch/notifications/index/NotificationConfigIndex$searchHitParser$1", "Lorg/opensearch/notifications/index/NotificationConfigIndex$searchHitParser$1;", "createIndex", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createNotificationConfig", "configDoc", "Lorg/opensearch/notifications/model/NotificationConfigDoc;", "id", "(Lorg/opensearch/notifications/model/NotificationConfigDoc;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteNotificationConfig", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteNotificationConfigs", "", "Lorg/opensearch/rest/RestStatus;", "ids", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllNotificationConfigs", "Lorg/opensearch/commons/notifications/model/NotificationConfigSearchResult;", "access", "", "request", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;", "(Ljava/util/List;Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNotificationConfig", "Lorg/opensearch/notifications/model/NotificationConfigDocInfo;", "getNotificationConfigs", "initialize", "isIndexExists", "parseNotificationConfigDoc", "response", "Lorg/opensearch/action/get/GetResponse;", "updateNotificationConfig", "notificationConfigDoc", "(Ljava/lang/String;Lorg/opensearch/notifications/model/NotificationConfigDoc;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-notifications"})
public final class NotificationConfigIndex
implements ConfigOperations {
    @NotNull
    public static final NotificationConfigIndex INSTANCE = new NotificationConfigIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(NotificationConfigIndex.class);
    @NotNull
    private static final String INDEX_NAME = ".opensearch-notifications-config";
    @NotNull
    private static final String MAPPING_FILE_NAME = "notifications-config-mapping.yml";
    @NotNull
    private static final String SETTINGS_FILE_NAME = "notifications-config-settings.yml";
    private static Client client;
    private static ClusterService clusterService;
    @NotNull
    private static final searchHitParser.1 searchHitParser;

    private NotificationConfigIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        NotificationConfigIndex.client = new SecureIndexClient(client);
        NotificationConfigIndex.clusterService = clusterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object createIndex(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof createIndex.1)) ** GOTO lbl-1000
        var14_2 = var1_1;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NotificationConfigIndex.access$createIndex(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.isIndexExists()) ** GOTO lbl85
                classLoader = NotificationConfigIndex.class.getClassLoader();
                v0 = classLoader.getResource("notifications-config-mapping.yml");
                if (v0 == null) {
                    v1 = null;
                } else {
                    var5_6 = v0;
                    var6_7 = Charsets.UTF_8;
                    var7_8 /* !! */  = TextStreamsKt.readBytes((URL)var5_6);
                    v1 = new String(var7_8 /* !! */ , var6_7);
                }
                Intrinsics.checkNotNull(v1);
                indexMappingSource = v1;
                indexMappingAsMap = XContentHelper.convertToMap((XContent)XContentType.YAML.xContent(), (String)indexMappingSource, (boolean)false);
                v2 = classLoader.getResource("notifications-config-settings.yml");
                if (v2 == null) {
                    v3 = null;
                } else {
                    var7_8 /* !! */  = (byte[])v2;
                    var8_11 = Charsets.UTF_8;
                    var9_14 = TextStreamsKt.readBytes((URL)var7_8 /* !! */ );
                    v3 = new String(var9_14, var8_11);
                }
                Intrinsics.checkNotNull(v3);
                indexSettingsSource = v3;
                request = new CreateIndexRequest(".opensearch-notifications-config").mapping(indexMappingAsMap).settings(indexSettingsSource, XContentType.YAML);
                v4 = NotificationConfigIndex.client;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v4 = null;
                }
                $this$use$iv = v4.threadPool().getThreadContext().stashContext();
                $i$f$use = false;
                exception$iv = null;
                $i$a$-use-NotificationConfigIndex$createIndex$2 = false;
                v5 = NotificationConfigIndex.client;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v5 = null;
                }
                $continuation.L$0 = $this$use$iv;
                $continuation.label = 1;
                v6 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v5, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<CreateIndexResponse>, Unit>(request){
                    final /* synthetic */ CreateIndexRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.admin().indices().create(this.$request, it);
                    }
                }, $continuation);
                ** if (v6 != var15_4) goto lbl57
lbl56:
                // 1 sources

                return var15_4;
lbl57:
                // 1 sources

                ** GOTO lbl68
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-NotificationConfigIndex$createIndex$2 = false;
                exception$iv = null;
                $this$use$iv = (ThreadContext.StoredContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl68:
                    // 2 sources

                    if (!(response = (CreateIndexResponse)v6).isAcknowledged()) {
                        throw new IllegalStateException("notifications:Index .opensearch-notifications-config creation not Acknowledged");
                    }
                    NotificationConfigIndex.INSTANCE.getLog().info("notifications:Index .opensearch-notifications-config creation Acknowledged");
                    {
                        catch (Exception exception) {
                            if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) ** GOTO lbl75
                            throw exception;
                        }
                    }
lbl75:
                    // 2 sources

                    var10_19 = Unit.INSTANCE;
                    ** GOTO lbl85
                }
                catch (Throwable e$iv) {
                    exception$iv = e$iv;
                    throw e$iv;
                }
            }
            catch (Throwable var10_21) {
                throw var10_21;
            }
            {
                finally {
                    NotificationConfigIndexKt.access$closeFinally($this$use$iv, exception$iv);
                }
lbl85:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isIndexExists() {
        ClusterService clusterService = NotificationConfigIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(INDEX_NAME);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object createNotificationConfig(@NotNull NotificationConfigDoc var1_1, @Nullable String var2_2, @NotNull Continuation<? super String> var3_3) {
        if (!(var3_3 instanceof createNotificationConfig.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createNotificationConfig(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = configDoc;
                $continuation.L$2 = id;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                id = (String)$continuation.L$2;
                configDoc = (NotificationConfigDoc)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                indexRequest = new IndexRequest(".opensearch-notifications-config").source(NotificationConfigDoc.toXContent$default(configDoc, null, 1, null)).create(true);
                if (id != null) {
                    indexRequest.id(id);
                }
                if ((v1 = NotificationConfigIndex.client) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v1 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v2 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v1, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(indexRequest){
                    final /* synthetic */ IndexRequest $indexRequest;
                    {
                        this.$indexRequest = $indexRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<IndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.index(this.$indexRequest, it);
                    }
                }, $continuation);
                if (v2 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl45
            }
            case 2: {
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl45:
                // 2 sources

                if ((response = (IndexResponse)v2).getResult() != DocWriteResponse.Result.CREATED) {
                    this.getLog().warn("notifications:createNotificationConfig - response:" + response);
                    v3 = null;
                } else {
                    v3 = response.getId();
                }
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object getNotificationConfigs(@NotNull Set<String> var1_1, @NotNull Continuation<? super List<NotificationConfigDocInfo>> var2_2) {
        if (!(var2_2 instanceof getNotificationConfigs.1)) ** GOTO lbl-1000
        var24_3 = var2_2;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getNotificationConfigs(null, (Continuation<? super List<NotificationConfigDocInfo>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = ids;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ids = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                getRequest = new MultiGetRequest();
                $this$forEach$iv = ids;
                $i$f$forEach = false;
                for (Object[] element$iv : $this$forEach$iv) {
                    it = (String)element$iv /* !! */ ;
                    $i$a$-forEach-NotificationConfigIndex$getNotificationConfigs$2 = false;
                    getRequest.add(".opensearch-notifications-config", it);
                }
                v1 = NotificationConfigIndex.client;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v1 = null;
                }
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v1, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<MultiGetResponse>, Unit>(getRequest){
                    final /* synthetic */ MultiGetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<MultiGetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.multiGet(this.$getRequest, it);
                    }
                }, $continuation);
                if (v2 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl44
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 2 sources

                response = (MultiGetResponse)v2;
                $i$f$forEach = response.getResponses();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach, (String)"response.responses");
                $this$mapNotNull$iv = $i$f$forEach;
                $i$f$mapNotNull = false;
                element$iv /* !! */  = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    element$iv$iv = element$iv$iv$iv;
                    $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                    it = (MultiGetItemResponse)element$iv$iv;
                    $i$a$-mapNotNull-NotificationConfigIndex$getNotificationConfigs$3 = false;
                    var20_25 = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var20_25, (String)"it.id");
                    v3 = var20_25;
                    var20_25 = it.getResponse();
                    Intrinsics.checkNotNullExpressionValue((Object)var20_25, (String)"it.response");
                    if (NotificationConfigIndex.INSTANCE.parseNotificationConfigDoc(v3, (GetResponse)var20_25) == null) continue;
                    $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getNotificationConfig(@NotNull String var1_1, @NotNull Continuation<? super NotificationConfigDocInfo> var2_2) {
        if (!(var2_2 instanceof getNotificationConfig.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getNotificationConfig(null, (Continuation<? super NotificationConfigDocInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                id = (String)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                getRequest = new GetRequest(".opensearch-notifications-config").id(id);
                v1 = NotificationConfigIndex.client;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v1 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.label = 2;
                v2 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v1, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.get(this.$getRequest, it);
                    }
                }, $continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                id = (String)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl41:
                // 2 sources

                response = (GetResponse)v2;
                return this.parseNotificationConfigDoc(id, response);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final NotificationConfigDocInfo parseNotificationConfigDoc(String id, GetResponse response2) {
        NotificationConfigDocInfo notificationConfigDocInfo;
        if (response2.getSourceAsString() == null) {
            this.getLog().warn("notifications:getNotificationConfig - " + id + " not found; response:" + response2);
            notificationConfigDocInfo = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response2.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            NotificationConfigDoc doc = NotificationConfigDoc.Companion.parse(parser);
            DocInfo info2 = new DocInfo(id, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm());
            notificationConfigDocInfo = new NotificationConfigDocInfo(info2, doc);
        }
        return notificationConfigDocInfo;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getAllNotificationConfigs(@NotNull List<String> var1_1, @NotNull GetNotificationConfigRequest var2_2, @NotNull Continuation<? super NotificationConfigSearchResult> var3_3) {
        if (!(var3_3 instanceof getAllNotificationConfigs.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAllNotificationConfigs(null, null, (Continuation<? super NotificationConfigSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = access;
                $continuation.L$2 = request;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                request = (GetNotificationConfigRequest)$continuation.L$2;
                access = (List)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                v1 = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS));
                v2 = ConfigQueryHelper.INSTANCE.getSortField(request.getSortField());
                v3 = request.getSortOrder();
                if (v3 == null) {
                    v3 = SortOrder.ASC;
                }
                sourceBuilder = v1.sort(v2, v3).size(request.getMaxItems()).from(request.getFromIndex());
                query = QueryBuilders.boolQuery();
                if (((Collection)access).isEmpty() == false) {
                    filterQuery = new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)"metadata.access", (Collection)access)).should((QueryBuilder)QueryBuilders.scriptQuery((Script)new Script("doc['metadata.access'] == []")));
                    query.filter((QueryBuilder)filterQuery);
                }
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"query");
                ConfigQueryHelper.INSTANCE.addQueryFilters(query, request.getFilterParams());
                sourceBuilder.query((QueryBuilder)query);
                var7_10 = new String[]{".opensearch-notifications-config"};
                searchRequest = new SearchRequest().indices(var7_10).source(sourceBuilder);
                v4 = NotificationConfigIndex.client;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v4 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v5 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v4, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.search(this.$searchRequest, it);
                    }
                }, $continuation);
                if (v5 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl60
            }
            case 2: {
                request = (GetNotificationConfigRequest)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl60:
                // 2 sources

                response = (SearchResponse)v5;
                result = new NotificationConfigSearchResult((long)request.getFromIndex(), response, (SearchResults.SearchHitParser)NotificationConfigIndex.searchHitParser);
                this.getLog().info("notifications:getAllNotificationConfigs from:" + request.getFromIndex() + ", maxItems:" + request.getMaxItems() + ", sortField:" + request.getSortField() + ", sortOrder=" + request.getSortOrder() + ", filters=" + request.getFilterParams() + " retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object updateNotificationConfig(@NotNull String var1_1, @NotNull NotificationConfigDoc var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof updateNotificationConfig.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateNotificationConfig(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.L$2 = notificationConfigDoc;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                notificationConfigDoc = (NotificationConfigDoc)$continuation.L$2;
                id = (String)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                indexRequest = new IndexRequest(".opensearch-notifications-config").source(NotificationConfigDoc.toXContent$default(notificationConfigDoc, null, 1, null)).create(false).id(id);
                v1 = NotificationConfigIndex.client;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v1 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v2 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v1, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(indexRequest){
                    final /* synthetic */ IndexRequest $indexRequest;
                    {
                        this.$indexRequest = $indexRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<IndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.index(this.$indexRequest, it);
                    }
                }, $continuation);
                if (v2 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl44
            }
            case 2: {
                id = (String)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 2 sources

                if ((response = (IndexResponse)v2).getResult() != DocWriteResponse.Result.UPDATED) {
                    this.getLog().warn("notifications:updateNotificationConfig failed for " + id + "; response:" + response);
                }
                return Boxing.boxBoolean((boolean)(response.getResult() == DocWriteResponse.Result.UPDATED));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object deleteNotificationConfig(@NotNull String var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof deleteNotificationConfig.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteNotificationConfig(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                id = (String)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                deleteRequest = ((DeleteRequest)new DeleteRequest().index(".opensearch-notifications-config")).id(id);
                v1 = NotificationConfigIndex.client;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v1 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.label = 2;
                v2 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v1, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<DeleteResponse>, Unit>(deleteRequest){
                    final /* synthetic */ DeleteRequest $deleteRequest;
                    {
                        this.$deleteRequest = $deleteRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<DeleteResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.delete(this.$deleteRequest, it);
                    }
                }, $continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                id = (String)$continuation.L$1;
                this = (NotificationConfigIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl41:
                // 2 sources

                if ((response = (DeleteResponse)v2).getResult() != DocWriteResponse.Result.DELETED) {
                    this.getLog().warn("notifications:deleteNotificationConfig failed for " + id + "; response:" + response);
                }
                return Boxing.boxBoolean((boolean)(response.getResult() == DocWriteResponse.Result.DELETED));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object deleteNotificationConfigs(@NotNull Set<String> var1_1, @NotNull Continuation<? super Map<String, ? extends RestStatus>> var2_2) {
        if (!(var2_2 instanceof deleteNotificationConfigs.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationConfigIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteNotificationConfigs(null, (Continuation<? super Map<String, ? extends RestStatus>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = ids;
                $continuation.label = 1;
                v0 = this.createIndex((Continuation<? super Unit>)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ids = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                bulkRequest = new BulkRequest();
                $this$forEach$iv = ids;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-NotificationConfigIndex$deleteNotificationConfigs$2 = false;
                    deleteRequest = ((DeleteRequest)new DeleteRequest().index(".opensearch-notifications-config")).id(it);
                    bulkRequest.add(deleteRequest);
                }
                v1 = NotificationConfigIndex.client;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v1 = null;
                }
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = SuspendUtils.Companion.suspendUntilTimeout((OpenSearchClient)v1, PluginSettings.INSTANCE.getOperationTimeoutMs(), (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                    final /* synthetic */ BulkRequest $bulkRequest;
                    {
                        this.$bulkRequest = $bulkRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntilTimeout, @NotNull ActionListener<BulkResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntilTimeout, (String)"$this$suspendUntilTimeout");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntilTimeout.bulk(this.$bulkRequest, it);
                    }
                }, $continuation);
                if (v2 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl46
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                response = (BulkResponse)v2;
                mutableMap = new LinkedHashMap<K, V>();
                $this$forEach$iv = (Iterable)response;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (BulkItemResponse)element$iv;
                    $i$a$-forEach-NotificationConfigIndex$deleteNotificationConfigs$3 = false;
                    var12_18 = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var12_18, (String)"it.id");
                    var13_19 = it.status();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_19, (String)"it.status()");
                    mutableMap.put(var12_18, var13_19);
                    if (!it.isFailed()) continue;
                    NotificationConfigIndex.INSTANCE.getLog().warn("notifications:deleteNotificationConfig failed for " + it.getId() + "; response:" + it.getFailureMessage());
                }
                return mutableMap;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$createIndex(NotificationConfigIndex $this, Continuation $completion) {
        return $this.createIndex((Continuation<? super Unit>)$completion);
    }

    static {
        searchHitParser = new SearchResults.SearchHitParser<NotificationConfigInfo>(){

            @NotNull
            public NotificationConfigInfo parse(@NotNull SearchHit searchHit) {
                Intrinsics.checkNotNullParameter((Object)searchHit, (String)"searchHit");
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchHit.getSourceAsString());
                parser.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
                NotificationConfigDoc doc = NotificationConfigDoc.Companion.parse(parser);
                String string = searchHit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchHit.id");
                return new NotificationConfigInfo(string, doc.getMetadata().getLastUpdateTime(), doc.getMetadata().getCreatedTime(), doc.getConfig());
            }
        };
    }
}

